/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.moving;

import boofcv.alg.background.moving.BackgroundMovingGaussian;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.GImageGray;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.distort.Point2Transform2Model_F32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import georegression.struct.InvertibleTransform;
import georegression.struct.point.Point2D_F32;
import pabeles.concurrency.GrowArray;

public class BackgroundMovingGaussian_SB<T extends ImageGray<T>, Motion extends InvertibleTransform<Motion>>
extends BackgroundMovingGaussian<T, Motion> {
    protected final InterpolatePixelS<T> _interpolationInput;
    protected final InterpolatePixelMB<InterleavedF32> _interpolationBG;
    protected final GImageGray inputWrapper;
    protected final InterleavedF32 background = new InterleavedF32(1, 1, 2);
    protected final GrowArray<Helper> helpers;
    protected final Helper helper;

    public BackgroundMovingGaussian_SB(float learnRate, float threshold, Point2Transform2Model_F32<Motion> transform, InterpolationType interpType, Class<T> imageType) {
        super(learnRate, threshold, transform, ImageType.single(imageType));
        this._interpolationInput = FactoryInterpolation.bilinearPixelS(imageType, BorderType.EXTENDED);
        this._interpolationBG = FactoryInterpolation.createPixelMB(0.0, 255.0, interpType, BorderType.EXTENDED, ImageType.il(2, InterleavedF32.class));
        this._interpolationBG.setImage(this.background);
        this.inputWrapper = FactoryGImageGray.create(imageType);
        this.helpers = new GrowArray<Helper>(() -> new Helper());
        this.helper = this.helpers.grow();
    }

    @Override
    public void initialize(int backgroundWidth, int backgroundHeight, Motion homeToWorld) {
        this.background.reshape(backgroundWidth, backgroundHeight);
        GImageMiscOps.fill((ImageBase)this.background, -1.0);
        this.homeToWorld.setTo(homeToWorld);
        this.homeToWorld.invert(this.worldToHome);
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
    }

    @Override
    public void reset() {
        ImageMiscOps.fill(this.background, -1.0f);
    }

    @Override
    protected void updateBackground(int x0, int y0, int x1, int y1, T frame) {
        int idx0 = y0;
        int idx1 = y1;
        this.helper.updateBackground(x0, idx0, x1, idx1, frame);
    }

    @Override
    protected void _segment(Motion currentToWorld, T frame, GrayU8 segmented) {
        this.inputWrapper.wrap((ImageGray)frame);
        boolean idx0 = false;
        int idx1 = ((ImageGray)frame).height;
        this.helper.segment(0, idx1, currentToWorld, frame, segmented);
    }

    private class Helper {
        private final Point2D_F32 pixel = new Point2D_F32();
        private final Point2Transform2Model_F32<Motion> transform;
        private final InterpolatePixelS<T> interpolationInput;
        private final InterpolatePixelMB<InterleavedF32> interpolationBG;
        private final float[] pixelBG = new float[2];

        public Helper() {
            this.transform = (Point2Transform2Model_F32)BackgroundMovingGaussian_SB.this._transform.copyConcurrent();
            this.interpolationInput = BackgroundMovingGaussian_SB.this._interpolationInput.copy();
            this.interpolationBG = BackgroundMovingGaussian_SB.this._interpolationBG.copy();
            this.interpolationBG.setImage(BackgroundMovingGaussian_SB.this.background);
        }

        public void updateBackground(int x0, int y0, int x1, int y1, T frame) {
            this.interpolationInput.setImage(frame);
            float minusLearn = 1.0f - BackgroundMovingGaussian_SB.this.learnRate;
            this.transform.setModel(BackgroundMovingGaussian_SB.this.worldToCurrent);
            for (int y = y0; y < y1; ++y) {
                int indexBG = BackgroundMovingGaussian_SB.this.background.startIndex + y * BackgroundMovingGaussian_SB.this.background.stride + x0 * BackgroundMovingGaussian_SB.this.background.numBands;
                int x = x0;
                while (x < x1) {
                    this.transform.compute(x, y, this.pixel);
                    if (this.pixel.x >= 0.0f && this.pixel.x < (float)((ImageGray)frame).width && this.pixel.y >= 0.0f && this.pixel.y < (float)((ImageGray)frame).height) {
                        float inputValue = this.interpolationInput.get(this.pixel.x, this.pixel.y);
                        float meanBG = BackgroundMovingGaussian_SB.this.background.data[indexBG];
                        float varianceBG = BackgroundMovingGaussian_SB.this.background.data[indexBG + 1];
                        if (varianceBG < 0.0f) {
                            BackgroundMovingGaussian_SB.this.background.data[indexBG] = inputValue;
                            BackgroundMovingGaussian_SB.this.background.data[indexBG + 1] = BackgroundMovingGaussian_SB.this.initialVariance;
                        } else {
                            float diff = meanBG - inputValue;
                            BackgroundMovingGaussian_SB.this.background.data[indexBG] = minusLearn * meanBG + BackgroundMovingGaussian_SB.this.learnRate * inputValue;
                            BackgroundMovingGaussian_SB.this.background.data[indexBG + 1] = minusLearn * varianceBG + BackgroundMovingGaussian_SB.this.learnRate * diff * diff;
                        }
                    }
                    ++x;
                    indexBG += 2;
                }
            }
        }

        protected void segment(int y0, int y1, Motion currentToWorld, T frame, GrayU8 segmented) {
            float minimumDifferenceSq = BackgroundMovingGaussian_SB.this.minimumDifference * BackgroundMovingGaussian_SB.this.minimumDifference;
            this.transform.setModel(currentToWorld);
            for (int y = y0; y < y1; ++y) {
                int indexFrame = ((ImageGray)frame).startIndex + y * ((ImageGray)frame).stride;
                int indexSegmented = segmented.startIndex + y * segmented.stride;
                int x = 0;
                while (x < ((ImageGray)frame).width) {
                    this.transform.compute(x, y, this.pixel);
                    if (this.pixel.x >= 0.0f && this.pixel.x < (float)BackgroundMovingGaussian_SB.this.background.width && this.pixel.y >= 0.0f && this.pixel.y < (float)BackgroundMovingGaussian_SB.this.background.height) {
                        float diff;
                        float chisq;
                        this.interpolationBG.get(this.pixel.x, this.pixel.y, this.pixelBG);
                        float pixelFrame = BackgroundMovingGaussian_SB.this.inputWrapper.getF(indexFrame);
                        float meanBG = this.pixelBG[0];
                        float varBG = this.pixelBG[1];
                        segmented.data[indexSegmented] = varBG < 0.0f ? BackgroundMovingGaussian_SB.this.unknownValue : ((chisq = (diff = meanBG - pixelFrame) * diff / varBG) <= BackgroundMovingGaussian_SB.this.threshold ? (byte)0 : (byte)(diff * diff > minimumDifferenceSq ? 1 : 0));
                    } else {
                        segmented.data[indexSegmented] = BackgroundMovingGaussian_SB.this.unknownValue;
                    }
                    ++x;
                    ++indexFrame;
                    ++indexSegmented;
                }
            }
        }
    }
}

