/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.tracker;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTracker;
import boofcv.abst.tracker.PointTrackerUtils;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.interpolate.InterpolateRectangle;
import boofcv.alg.tracker.PruneCloseTracks;
import boofcv.alg.tracker.klt.ConfigKlt;
import boofcv.alg.tracker.klt.KltTrackFault;
import boofcv.alg.tracker.klt.KltTracker;
import boofcv.alg.tracker.klt.PyramidKltFeature;
import boofcv.alg.tracker.klt.PyramidKltTracker;
import boofcv.alg.transform.pyramid.PyramidOps;
import boofcv.struct.ConfigLength;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.PyramidDiscrete;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I16;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PointTrackerKltPyramid<I extends ImageGray<I>, D extends ImageGray<D>>
implements PointTracker<I> {
    public ConfigLength configMaxTracks = ConfigLength.fixed(0.0);
    int actualMaxTracks;
    protected I input;
    protected long frameID = -1L;
    protected ImageGradient<I, D> gradient;
    protected double toleranceFB;
    protected ImageStruct currPyr;
    protected ImageStruct prevPyr;
    protected ImageType<D> derivType;
    protected ConfigKlt config;
    protected int templateRadius;
    protected List<PyramidKltFeature> active = new ArrayList<PyramidKltFeature>();
    protected List<PyramidKltFeature> spawned = new ArrayList<PyramidKltFeature>();
    protected List<PyramidKltFeature> dropped = new ArrayList<PyramidKltFeature>();
    protected List<PyramidKltFeature> unused = new ArrayList<PyramidKltFeature>();
    protected PyramidKltTracker<I, D> tracker;
    private GeneralFeatureDetector<I, D> detector;
    private final QueueCorner excludeList = new QueueCorner(10);
    private long totalFeatures = 0L;
    PruneCloseTracks<PyramidKltFeature> pruneClose;
    List<PyramidKltFeature> closeDropped = new ArrayList<PyramidKltFeature>();

    public PointTrackerKltPyramid(ConfigKlt config, double toleranceFB, int templateRadius, boolean performPruneClose, PyramidDiscrete<I> pyramid, GeneralFeatureDetector<I, D> detector, ImageGradient<I, D> gradient, InterpolateRectangle<I> interpInput, InterpolateRectangle<D> interpDeriv, Class<D> derivType) {
        this.config = config;
        this.toleranceFB = toleranceFB;
        this.templateRadius = templateRadius;
        this.gradient = gradient;
        this.derivType = ImageType.single(derivType);
        this.currPyr = new ImageStruct(pyramid);
        if (toleranceFB >= 0.0) {
            this.prevPyr = new ImageStruct(pyramid);
            this.prevPyr.basePyramid.setSaveOriginalReference(false);
            this.currPyr.basePyramid.setSaveOriginalReference(false);
        } else {
            this.currPyr.basePyramid.setSaveOriginalReference(true);
        }
        KltTracker<I, D> klt = new KltTracker<I, D>(interpInput, interpDeriv, config);
        this.tracker = new PyramidKltTracker<I, D>(klt);
        if (detector != null) {
            if (detector.getRequiresHessian()) {
                throw new IllegalArgumentException("Hessian based feature detectors not yet supported");
            }
            this.detector = detector;
            if (performPruneClose) {
                this.pruneClose = new PruneCloseTracks<PyramidKltFeature>(detector.getSearchRadius(), new PruneCloseTracks.TrackInfo<PyramidKltFeature>(){

                    @Override
                    public void getLocation(PyramidKltFeature track, Point2D_F64 location) {
                        location.x = track.x;
                        location.y = track.y;
                    }

                    @Override
                    public long getID(PyramidKltFeature track) {
                        return ((PointTrackMod)track.cookie).featureId;
                    }
                });
            }
        }
    }

    private PyramidKltFeature createNewTrack() {
        int numLayers = this.currPyr.basePyramid.getNumLayers();
        PyramidKltFeature t = new PyramidKltFeature(numLayers, this.templateRadius);
        PointTrackMod p = new PointTrackMod();
        p.setDescription(t);
        t.cookie = p;
        return t;
    }

    @Nullable
    public PointTrack addTrack(double x, double y) {
        if (!((ImageBase)this.input).isInBounds((int)x, (int)y)) {
            return null;
        }
        PyramidKltFeature t = this.getUnusedTrack();
        t.setPosition((float)x, (float)y);
        this.tracker.setDescription(t);
        PointTrackMod p = (PointTrackMod)t.getCookie();
        p.pixel.setTo(x, y);
        p.prev.setTo(x, y);
        if (this.checkValidSpawn(p)) {
            p.featureId = this.totalFeatures++;
            p.spawnFrameID = this.frameID;
            p.lastSeenFrameID = this.frameID;
            this.active.add(t);
            return p;
        }
        return null;
    }

    protected PyramidKltFeature getUnusedTrack() {
        if (this.unused.isEmpty()) {
            return this.createNewTrack();
        }
        PyramidKltFeature t = this.unused.remove(this.unused.size() - 1);
        t.checkUpdateLayers(this.currPyr.derivX.length);
        return t;
    }

    @Override
    public void spawnTracks() {
        this.spawned.clear();
        this.tracker.setImage(this.currPyr.basePyramid, (ImageGray[])this.currPyr.derivX, (ImageGray[])this.currPyr.derivY);
        float scaleBottom = (float)this.currPyr.basePyramid.getScale(0);
        this.excludeList.resize(this.active.size());
        for (int i = 0; i < this.active.size(); ++i) {
            PyramidKltFeature f = this.active.get(i);
            ((Point2D_I16)this.excludeList.get(i)).setTo((int)(f.x / scaleBottom), (int)(f.y / scaleBottom));
        }
        this.detector.setExclude(this.excludeList);
        ImageGray baseLayer = (ImageGray)this.currPyr.basePyramid.getLayer(0);
        this.actualMaxTracks = this.configMaxTracks.computeI(baseLayer.totalPixels());
        if (this.actualMaxTracks > 0) {
            int limit = this.actualMaxTracks - this.excludeList.size;
            if (limit <= 0) {
                return;
            }
            this.detector.setFeatureLimit(this.actualMaxTracks - this.excludeList.size);
        } else {
            this.detector.setFeatureLimit(-1);
        }
        this.detector.process(baseLayer, this.currPyr.derivX[0], this.currPyr.derivY[0], null, null, null);
        this.addToTracks(scaleBottom, this.detector.getMinimums());
        this.addToTracks(scaleBottom, this.detector.getMaximums());
    }

    @Override
    public ImageType<I> getImageType() {
        return this.gradient.getInputType();
    }

    private void addToTracks(float scaleBottom, QueueCorner found) {
        for (int i = 0; i < found.size(); ++i) {
            Point2D_I16 pt = (Point2D_I16)found.get(i);
            PyramidKltFeature t = this.getUnusedTrack();
            t.x = (float)pt.x * scaleBottom;
            t.y = (float)pt.y * scaleBottom;
            this.tracker.setDescription(t);
            PointTrackMod p = (PointTrackMod)t.getCookie();
            p.pixel.setTo(t.x, t.y);
            if (this.checkValidSpawn(p)) {
                ++this.totalFeatures;
                p.featureId = p.featureId;
                p.spawnFrameID = this.frameID;
                p.lastSeenFrameID = this.frameID;
                p.prev.setTo(t.x, t.y);
                this.active.add(t);
                this.spawned.add(t);
                continue;
            }
            this.unused.add(t);
        }
    }

    protected boolean checkValidSpawn(PointTrack p) {
        return true;
    }

    @Override
    public void dropAllTracks() {
        this.unused.addAll(this.active);
        this.active.clear();
        this.dropped.clear();
    }

    @Override
    public int getMaxSpawn() {
        return this.actualMaxTracks;
    }

    @Override
    public void process(I image) {
        this.input = image;
        ++this.frameID;
        if (this.toleranceFB >= 0.0) {
            ImageStruct tmp = this.currPyr;
            this.currPyr = this.prevPyr;
            this.prevPyr = tmp;
        }
        boolean activeTracks = this.active.size() > 0;
        this.spawned.clear();
        this.dropped.clear();
        this.currPyr.update(image);
        this.tracker.setImage(this.currPyr.basePyramid, (ImageGray[])this.currPyr.derivX, (ImageGray[])this.currPyr.derivY);
        for (int i = this.active.size() - 1; i >= 0; --i) {
            PyramidKltFeature t = this.active.get(i);
            KltTrackFault ret = this.tracker.track(t);
            boolean success = false;
            if (ret == KltTrackFault.SUCCESS && ((ImageBase)image).isInBounds((int)t.x, (int)t.y) && this.tracker.setDescription(t)) {
                PointTrack p = (PointTrack)t.getCookie();
                p.pixel.setTo(t.x, t.y);
                p.lastSeenFrameID = this.frameID;
                success = true;
            }
            if (success) continue;
            this.active.remove(i);
            this.dropped.add(t);
            this.unused.add(t);
        }
        if (this.toleranceFB >= 0.0) {
            if (activeTracks) {
                this.backwardsTrackValidate();
            } else {
                this.prevPyr.update(image);
            }
        }
        if (this.pruneClose != null) {
            this.pruneCloseTracks();
        }
    }

    protected void pruneCloseTracks() {
        this.pruneClose.init(((ImageGray)this.input).width, ((ImageGray)this.input).height);
        this.pruneClose.process(this.active, this.closeDropped);
        this.active.removeAll(this.closeDropped);
        this.dropped.addAll(this.closeDropped);
    }

    protected void backwardsTrackValidate() {
        double tol2 = this.toleranceFB * this.toleranceFB;
        this.tracker.setImage(this.prevPyr.basePyramid, (ImageGray[])this.prevPyr.derivX, (ImageGray[])this.prevPyr.derivY);
        for (int i = this.active.size() - 1; i >= 0; --i) {
            PyramidKltFeature t = this.active.get(i);
            PointTrackMod p = (PointTrackMod)t.getCookie();
            KltTrackFault ret = this.tracker.track(t);
            if (ret != KltTrackFault.SUCCESS || p.prev.distance2(t.x, t.y) > tol2) {
                this.active.remove(i);
                this.dropped.add(t);
                this.unused.add(t);
                continue;
            }
            p.prev.setTo(p.pixel);
            t.x = (float)p.pixel.x;
            t.y = (float)p.pixel.y;
        }
    }

    @Override
    public boolean dropTrack(PointTrack track) {
        if (this.active.remove((PyramidKltFeature)track.getDescription())) {
            this.unused.add((PyramidKltFeature)track.getDescription());
            return true;
        }
        return false;
    }

    @Override
    public void dropTracks(PointTracker.Dropper dropper) {
        for (int i = this.active.size() - 1; i >= 0; --i) {
            PointTrack t = (PointTrack)this.active.get((int)i).cookie;
            if (!dropper.shouldDropTrack(t)) continue;
            PyramidKltFeature klt = this.active.remove(i);
            this.unused.add(klt);
        }
    }

    @Override
    public List<PointTrack> getActiveTracks(@Nullable List<PointTrack> list) {
        list = PointTrackerUtils.declareTrackStorage(list);
        this.addToList(this.active, list);
        return list;
    }

    @Override
    public List<PointTrack> getInactiveTracks(@Nullable List<PointTrack> list) {
        return PointTrackerUtils.declareTrackStorage(list);
    }

    @Override
    public List<PointTrack> getDroppedTracks(@Nullable List<PointTrack> list) {
        list = PointTrackerUtils.declareTrackStorage(list);
        this.addToList(this.dropped, list);
        return list;
    }

    @Override
    public List<PointTrack> getNewTracks(@Nullable List<PointTrack> list) {
        list = PointTrackerUtils.declareTrackStorage(list);
        this.addToList(this.spawned, list);
        return list;
    }

    @Override
    public List<PointTrack> getAllTracks(@Nullable List<PointTrack> list) {
        return this.getActiveTracks(list);
    }

    protected void addToList(List<PyramidKltFeature> in, List<PointTrack> out) {
        for (int featIdx = 0; featIdx < in.size(); ++featIdx) {
            out.add((PointTrack)in.get((int)featIdx).cookie);
        }
    }

    @Override
    public void reset() {
        this.dropAllTracks();
        this.totalFeatures = 0L;
        this.frameID = -1L;
    }

    @Override
    public long getFrameID() {
        return this.frameID;
    }

    @Override
    public int getTotalActive() {
        return this.active.size();
    }

    @Override
    public int getTotalInactive() {
        return 0;
    }

    public ConfigLength getConfigMaxTracks() {
        return this.configMaxTracks;
    }

    public void setConfigMaxTracks(ConfigLength configMaxTracks) {
        this.configMaxTracks = configMaxTracks;
    }

    class ImageStruct {
        public PyramidDiscrete<I> basePyramid;
        public D[] derivX;
        public D[] derivY;

        public ImageStruct(PyramidDiscrete<I> o) {
            this.basePyramid = (PyramidDiscrete)o.copyStructure();
        }

        public void update(I image) {
            this.basePyramid.process(image);
            if (this.derivX == null || this.derivX.length != ((ImageGray[])this.basePyramid.layers).length) {
                this.derivX = PyramidOps.declareOutput(this.basePyramid, PointTrackerKltPyramid.this.derivType);
                this.derivY = PyramidOps.declareOutput(this.basePyramid, PointTrackerKltPyramid.this.derivType);
            }
            if (((ImageGray)this.derivX[0]).width != ((ImageGray)this.basePyramid.getLayer((int)0)).width || ((ImageGray)this.derivX[0]).height != ((ImageGray)this.basePyramid.getLayer((int)0)).height) {
                PyramidOps.reshapeOutput(this.basePyramid, this.derivX);
                PyramidOps.reshapeOutput(this.basePyramid, this.derivY);
            }
            PyramidOps.gradient(this.basePyramid, PointTrackerKltPyramid.this.gradient, this.derivX, this.derivY);
        }
    }

    static class PointTrackMod
    extends PointTrack {
        public final Point2D_F64 prev = new Point2D_F64();

        PointTrackMod() {
        }
    }
}

