/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.selfcalib;

import boofcv.abst.geo.selfcalib.ProjectiveToMetricCameras;
import boofcv.alg.geo.MetricCameras;
import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.selfcalib.ResolveSignAmbiguityPositiveDepth;
import boofcv.alg.geo.selfcalib.SelfCalibrationPraticalGuessAndCheckFocus;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.ElevateViewInfo;
import boofcv.struct.geo.AssociatedTuple;
import boofcv.struct.image.ImageDimension;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class ProjectiveToMetricCameraPracticalGuessAndCheck
implements ProjectiveToMetricCameras {
    final SelfCalibrationPraticalGuessAndCheckFocus selfCalib;
    final DMatrixRMaj K = new DMatrixRMaj(3, 3);
    final ResolveSignAmbiguityPositiveDepth resolveSign = new ResolveSignAmbiguityPositiveDepth();

    public ProjectiveToMetricCameraPracticalGuessAndCheck(SelfCalibrationPraticalGuessAndCheckFocus selfCalib) {
        this.selfCalib = selfCalib;
    }

    @Override
    public boolean process(List<ElevateViewInfo> views, List<DMatrixRMaj> cameraMatrices, List<AssociatedTuple> observations, MetricCameras metricViews) {
        BoofMiscOps.checkTrue(cameraMatrices.size() + 1 == views.size());
        metricViews.reset();
        ImageDimension dimension = views.get((int)0).shape;
        this.selfCalib.setCamera(0.0, 0.0, 0.0, dimension.width, dimension.height);
        if (!this.selfCalib.process(cameraMatrices)) {
            return false;
        }
        DMatrixRMaj H = this.selfCalib.getRectifyingHomography();
        CommonOps_DDRM.extract((DMatrix)H, 0, 0, (DMatrix)this.K);
        PerspectiveOps.matrixToPinhole(this.K, -1, -1, metricViews.intrinsics.grow());
        double largestT = 0.0;
        for (int viewIdx = 0; viewIdx < cameraMatrices.size(); ++viewIdx) {
            DMatrixRMaj P = cameraMatrices.get(viewIdx);
            if (!MultiViewOps.projectiveToMetric(P, H, metricViews.motion_1_to_k.grow(), this.K)) {
                return false;
            }
            PerspectiveOps.matrixToPinhole(this.K, -1, -1, metricViews.intrinsics.grow());
            largestT = Math.max(largestT, ((Se3_F64)metricViews.motion_1_to_k.getTail()).T.norm());
        }
        for (int i = 0; i < metricViews.motion_1_to_k.size; ++i) {
            ((Se3_F64)metricViews.motion_1_to_k.get((int)i)).T.divide(largestT);
        }
        this.resolveSign.process(observations, metricViews);
        return true;
    }

    @Override
    public int getMinimumViews() {
        return 2;
    }

    public SelfCalibrationPraticalGuessAndCheckFocus getSelfCalib() {
        return this.selfCalib;
    }
}

