/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.h;

import boofcv.abst.geo.RefineEpipolar;
import boofcv.abst.geo.optimization.ResidualsEpipolarMatrixN;
import boofcv.alg.geo.ModelObservationResidualN;
import boofcv.struct.geo.AssociatedPair;
import java.util.List;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ejml.data.DMatrixRMaj;

public class LeastSquaresHomography
implements RefineEpipolar {
    ResidualsEpipolarMatrixN func;
    UnconstrainedLeastSquares minimizer;
    int maxIterations;
    double convergenceTol;

    public LeastSquaresHomography(double convergenceTol, int maxIterations, ModelObservationResidualN residuals) {
        this.maxIterations = maxIterations;
        this.convergenceTol = convergenceTol;
        this.func = new ResidualsEpipolarMatrixN(null, residuals);
        this.minimizer = FactoryOptimization.levenbergMarquardt(null, false);
    }

    @Override
    public boolean fitModel(List<AssociatedPair> obs, DMatrixRMaj F, DMatrixRMaj refinedF) {
        this.func.setObservations(obs);
        this.minimizer.setFunction(this.func, null);
        this.minimizer.initialize(F.data, 0.0, this.convergenceTol * (double)obs.size());
        for (int i = 0; i < this.maxIterations && !this.minimizer.iterate(); ++i) {
        }
        System.arraycopy(this.minimizer.getParameters(), 0, refinedF.data, 0, 9);
        return true;
    }

    @Override
    public double getFitScore() {
        return this.minimizer.getFunctionValue();
    }
}

