/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.SceneStructure;
import boofcv.alg.geo.bundle.BundleAdjustmentOps;
import boofcv.alg.geo.bundle.cameras.BundleDummyCamera;
import boofcv.alg.geo.bundle.cameras.BundlePinhole;
import boofcv.alg.geo.bundle.cameras.BundlePinholeBrown;
import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import java.util.Objects;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;

public abstract class SceneStructureCommon
implements SceneStructure {
    public final DogArray<Camera> cameras = new DogArray<Camera>(Camera::new, Camera::reset);
    public DogArray<Point> points;
    protected boolean homogenous;
    protected int pointSize;

    protected SceneStructureCommon(boolean homogenous) {
        this.setHomogenous(homogenous);
    }

    public void setHomogenous(boolean homogenous) {
        this.homogenous = homogenous;
        this.pointSize = homogenous ? 4 : 3;
        this.points = new DogArray<Point>(() -> new Point(this.pointSize), Point::reset);
    }

    public void setPoint(int which, double x, double y, double z) {
        ((Point[])this.points.data)[which].set(x, y, z);
    }

    public void setPoint(int which, double x, double y, double z, double w) {
        ((Point[])this.points.data)[which].set(x, y, z, w);
    }

    public void setCamera(int which, boolean fixed, BundleAdjustmentCamera model) {
        ((Camera)this.cameras.get((int)which)).known = fixed;
        ((Camera)this.cameras.get((int)which)).model = model;
    }

    public void setCamera(int which, boolean fixed, CameraPinhole intrinsic) {
        this.setCamera(which, fixed, BundleAdjustmentOps.convert(intrinsic, (BundlePinhole)null));
    }

    public void setCamera(int which, boolean fixed, CameraPinholeBrown intrinsic) {
        this.setCamera(which, fixed, BundleAdjustmentOps.convert(intrinsic, (BundlePinholeBrown)null));
    }

    public void connectPointToView(int pointIndex, int viewIndex) {
        Point p = ((Point[])this.points.data)[pointIndex];
        if (p.views.contains(viewIndex)) {
            throw new IllegalArgumentException("Tried to add the same view twice. viewIndex=" + viewIndex);
        }
        p.views.add(viewIndex);
    }

    public DogArray<Point> getPoints() {
        return this.points;
    }

    public DogArray<Camera> getCameras() {
        return this.cameras;
    }

    public <T extends BundleAdjustmentCamera> T getCameraModel(int cameraIndex) {
        return (T)((BundleAdjustmentCamera)Objects.requireNonNull(((Camera)this.cameras.get(cameraIndex)).getModel()));
    }

    public int getUnknownCameraParameterCount() {
        int total = 0;
        for (int i = 0; i < this.cameras.size; ++i) {
            if (((Camera[])this.cameras.data)[i].known) continue;
            total += ((Camera[])this.cameras.data)[i].model.getIntrinsicCount();
        }
        return total;
    }

    public void removePoints(DogArray_I32 which) {
        this.points.remove(which.data, 0, which.size, null);
    }

    @Override
    public boolean isHomogenous() {
        return this.homogenous;
    }

    public int getObservationCount() {
        int total = 0;
        for (int i = 0; i < this.points.size; ++i) {
            total += ((Point[])this.points.data)[i].views.size;
        }
        return total;
    }

    public int getPointSize() {
        return this.pointSize;
    }

    public static class Point {
        public final double[] coordinate;
        public DogArray_I32 views = new DogArray_I32(0);

        public Point(int dof) {
            this.coordinate = new double[dof];
        }

        public void reset() {
            this.views.reset();
            this.coordinate[0] = Double.NaN;
        }

        public void removeView(int which) {
            int index = this.views.indexOf(which);
            if (index == -1) {
                throw new RuntimeException("BUG. Could not find in list of views. which=" + which);
            }
            this.views.remove(index);
        }

        public void set(double x, double y, double z) {
            this.coordinate[0] = x;
            this.coordinate[1] = y;
            this.coordinate[2] = z;
        }

        public void set(double x, double y, double z, double w) {
            this.coordinate[0] = x;
            this.coordinate[1] = y;
            this.coordinate[2] = z;
            this.coordinate[3] = w;
        }

        public void get(Point3D_F64 p) {
            p.x = this.coordinate[0];
            p.y = this.coordinate[1];
            p.z = this.coordinate[2];
        }

        public void get(Point4D_F64 p) {
            p.x = this.coordinate[0];
            p.y = this.coordinate[1];
            p.z = this.coordinate[2];
            p.w = this.coordinate[3];
        }

        public double getX() {
            return this.coordinate[0];
        }

        public double getY() {
            return this.coordinate[1];
        }

        public double getZ() {
            return this.coordinate[2];
        }

        public double getW() {
            return this.coordinate[3];
        }

        public double distanceSq(Point3D_F64 p) {
            double dx = this.coordinate[0] - p.x;
            double dy = this.coordinate[1] - p.y;
            double dz = this.coordinate[2] - p.z;
            return dx * dx + dy * dy + dz * dz;
        }

        public void normalizeH() {
            double n = 0.0;
            n += this.coordinate[0] * this.coordinate[0];
            n += this.coordinate[1] * this.coordinate[1];
            n += this.coordinate[2] * this.coordinate[2];
            n += this.coordinate[3] * this.coordinate[3];
            n = Math.sqrt(n);
            this.coordinate[0] = this.coordinate[0] / n;
            this.coordinate[1] = this.coordinate[1] / n;
            this.coordinate[2] = this.coordinate[2] / n;
            this.coordinate[3] = this.coordinate[3] / n;
        }

        public double distance(Point3D_F64 p) {
            return Math.sqrt(this.distance(p));
        }

        public double distance(Point p) {
            double dx = this.coordinate[0] - p.coordinate[0];
            double dy = this.coordinate[1] - p.coordinate[1];
            double dz = this.coordinate[2] - p.coordinate[2];
            return Math.sqrt(dx * dx + dy * dy + dz * dz);
        }
    }

    public static class Camera {
        public boolean known = true;
        public BundleAdjustmentCamera model = BundleDummyCamera.INSTANCE;

        @Nullable
        public <T extends BundleAdjustmentCamera> T getModel() {
            return (T)this.model;
        }

        public void reset() {
            this.known = true;
            this.model = BundleDummyCamera.INSTANCE;
        }

        public boolean isIdentical(Camera m, double tol) {
            if (this.known != m.known) {
                return false;
            }
            if (this.model == null) {
                return m.model == BundleDummyCamera.INSTANCE;
            }
            if (m.model == BundleDummyCamera.INSTANCE) {
                return false;
            }
            try {
                if (this.model instanceof BundlePinholeSimplified) {
                    BundlePinholeSimplified a = (BundlePinholeSimplified)this.model;
                    BundlePinholeSimplified b = (BundlePinholeSimplified)m.model;
                    return a.isIdentical(b, tol);
                }
                throw new RuntimeException("Add support for " + this.model.getClass().getSimpleName());
            }
            catch (ClassCastException e) {
                return false;
            }
        }
    }
}

