/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.struct.Configuration;

public class ConfigGridDimen
implements Configuration {
    public int numRows = -1;
    public int numCols = -1;
    public double shapeSize;
    public double shapeDistance;

    public ConfigGridDimen(int numRows, int numCols, double shapeSize) {
        this.numRows = numRows;
        this.numCols = numCols;
        this.shapeSize = shapeSize;
    }

    public ConfigGridDimen(int numRows, int numCols, double shapeSize, double shapeDistance) {
        this.numRows = numRows;
        this.numCols = numCols;
        this.shapeSize = shapeSize;
        this.shapeDistance = shapeDistance;
    }

    public ConfigGridDimen() {
    }

    public ConfigGridDimen setTo(int numRows, int numCols, double shapeSize, double shapeDistance) {
        this.numRows = numRows;
        this.numCols = numCols;
        this.shapeSize = shapeSize;
        this.shapeDistance = shapeDistance;
        return this;
    }

    public ConfigGridDimen setTo(ConfigGridDimen src) {
        this.numRows = src.numRows;
        this.numCols = src.numCols;
        this.shapeSize = src.shapeSize;
        this.shapeDistance = src.shapeDistance;
        return this;
    }

    public double getSpacetoSizeRatio() {
        return this.shapeSize / this.shapeDistance;
    }

    @Override
    public void checkValidity() {
        if (this.numCols <= 0 || this.numRows <= 0) {
            throw new IllegalArgumentException("Must specify then number of rows and columns in the target");
        }
    }

    public String toString() {
        return "ConfigGridDimen{numRows=" + this.numRows + ", numCols=" + this.numCols + ", shapeSize=" + this.shapeSize + ", shapeDistance=" + this.shapeDistance + "}";
    }
}

