/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial;

import boofcv.abst.fiducial.QrCodeDetector;
import boofcv.abst.filter.binary.BinaryContourHelper;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.fiducial.qrcode.PositionPatternNode;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeDecoderImage;
import boofcv.alg.fiducial.qrcode.QrCodePositionPatternDetector;
import boofcv.alg.fiducial.qrcode.QrCodePositionPatternGraphGenerator;
import boofcv.alg.shapes.polygon.DetectPolygonBinaryGrayRefine;
import boofcv.alg.shapes.polygon.DetectPolygonFromContour;
import boofcv.misc.MovingAverage;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class QrCodePreciseDetector<T extends ImageGray<T>>
implements QrCodeDetector<T> {
    QrCodePositionPatternDetector<T> detectPositionPatterns;
    QrCodePositionPatternGraphGenerator graphPositionPatterns = new QrCodePositionPatternGraphGenerator();
    QrCodeDecoderImage<T> decoder;
    InputToBinary<T> inputToBinary;
    Class<T> imageType;
    BinaryContourHelper contourHelper;
    boolean profiler = false;
    protected MovingAverage milliBinary = new MovingAverage(0.8);
    protected MovingAverage milliDecoding = new MovingAverage(0.8);

    public QrCodePreciseDetector(InputToBinary<T> inputToBinary, QrCodePositionPatternDetector<T> detectPositionPatterns, @Nullable String defaultEncoding, boolean copyBinary, Class<T> imageType) {
        this.inputToBinary = inputToBinary;
        this.detectPositionPatterns = detectPositionPatterns;
        this.decoder = new QrCodeDecoderImage<T>(defaultEncoding, imageType);
        this.imageType = imageType;
        this.contourHelper = new BinaryContourHelper(detectPositionPatterns.getSquareDetector().getDetector().getContourFinder(), copyBinary);
    }

    @Override
    public void process(T gray) {
        long time0 = System.nanoTime();
        this.contourHelper.reshape(((ImageGray)gray).width, ((ImageGray)gray).height);
        this.inputToBinary.process(gray, this.contourHelper.withoutPadding());
        long time1 = System.nanoTime();
        this.milliBinary.update((double)(time1 - time0) * 1.0E-6);
        if (this.profiler) {
            System.out.printf("qrcode: binary %5.2f ", this.milliBinary.getAverage());
        }
        this.detectPositionPatterns.process(gray, this.contourHelper.padded());
        List<PositionPatternNode> positionPatterns = this.detectPositionPatterns.getPositionPatterns().toList();
        this.graphPositionPatterns.process(positionPatterns);
        if (this.profiler) {
            DetectPolygonFromContour<T> detectorPoly = this.detectPositionPatterns.getSquareDetector().getDetector();
            System.out.printf(" contour %5.1f shapes %5.1f adjust_bias %5.2f PosPat %6.2f", detectorPoly.getMilliContour(), detectorPoly.getMilliShapes(), this.detectPositionPatterns.getSquareDetector().getMilliAdjustBias(), this.detectPositionPatterns.getProfilingMS().getAverage());
        }
        time0 = System.nanoTime();
        this.decoder.process(positionPatterns, gray);
        time1 = System.nanoTime();
        this.milliDecoding.update((double)(time1 - time0) * 1.0E-6);
        if (this.profiler) {
            System.out.printf(" decoding %5.1f\n", this.milliDecoding.getAverage());
        }
    }

    @Override
    public List<QrCode> getDetections() {
        return this.decoder.getFound();
    }

    @Override
    public List<QrCode> getFailures() {
        return this.decoder.getFailures();
    }

    public void setLensDistortion(int width, int height, @Nullable LensDistortionNarrowFOV model) {
        this.detectPositionPatterns.setLensDistortion(width, height, model);
        this.decoder.setLensDistortion(width, height, model);
    }

    public GrayU8 getBinary() {
        return this.contourHelper.withoutPadding();
    }

    public void setProfilerState(boolean active) {
        this.profiler = active;
    }

    public void resetRuntimeProfiling() {
        this.milliBinary.reset();
        this.milliDecoding.reset();
        this.detectPositionPatterns.resetRuntimeProfiling();
    }

    public DetectPolygonBinaryGrayRefine<T> getSquareDetector() {
        return this.detectPositionPatterns.getSquareDetector();
    }

    @Override
    public Class<T> getImageType() {
        return this.imageType;
    }

    public QrCodePositionPatternDetector<T> getDetectPositionPatterns() {
        return this.detectPositionPatterns;
    }

    public QrCodePositionPatternGraphGenerator getGraphPositionPatterns() {
        return this.graphPositionPatterns;
    }

    public QrCodeDecoderImage<T> getDecoder() {
        return this.decoder;
    }
}

