/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial;

import boofcv.abst.fiducial.FiducialDetectorPnP;
import boofcv.abst.fiducial.calib.ConfigECoCheckMarkers;
import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.alg.fiducial.calib.ecocheck.ECoCheckDetector;
import boofcv.alg.fiducial.calib.ecocheck.ECoCheckFound;
import boofcv.alg.fiducial.calib.ecocheck.ECoCheckUtils;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.geo.PointIndex2D_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.transform.homography.HomographyPointOps_F64;
import java.util.List;
import java.util.Objects;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastArray;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.fixed.CommonOps_DDF3;
import org.ejml.ops.DConvertMatrixStruct;
import org.jetbrains.annotations.Nullable;

public class ECoCheck_to_FiducialDetector<T extends ImageGray<T>>
extends FiducialDetectorPnP<T> {
    ECoCheckDetector<T> detector;
    private final DogArray<Point2D3D> points2D3D = new DogArray<Point2D3D>(Point2D3D::new);
    private final DogArray<Homography2D_F64> listMarkerToPixels = new DogArray<Homography2D_F64>(Homography2D_F64::new);
    DMatrixRMaj tmp = new DMatrixRMaj(3, 3);
    private final DogArray<AssociatedPair> pairs = new DogArray<AssociatedPair>(AssociatedPair::new);
    final FastArray<ConfigECoCheckMarkers.MarkerShape> markerShapes;
    DogArray_I32 foundToDetection = new DogArray_I32();
    final Point3D_F64 point3 = new Point3D_F64();

    public ECoCheck_to_FiducialDetector(ECoCheckDetector<T> detector, FastArray<ConfigECoCheckMarkers.MarkerShape> markerShapes) {
        this.detector = detector;
        this.markerShapes = markerShapes;
    }

    @Override
    public void detect(T input) {
        this.detector.process(input);
        this.foundToDetection.reset();
        for (int detectionID = 0; detectionID < this.detector.getFound().size; ++detectionID) {
            ECoCheckFound found = (ECoCheckFound)this.detector.found.get(detectionID);
            if (found.markerID < 0) continue;
            this.foundToDetection.add(detectionID);
        }
        ECoCheckUtils utils = this.detector.getUtils();
        Estimate1ofEpipolar computeHomography = FactoryMultiView.homographyTLS();
        this.listMarkerToPixels.reset();
        for (int knownIdx = 0; knownIdx < this.foundToDetection.size; ++knownIdx) {
            int detectionID = this.foundToDetection.get(knownIdx);
            ECoCheckFound found = (ECoCheckFound)this.detector.found.get(detectionID);
            int markerID = found.markerID;
            this.pairs.resetResize(found.corners.size);
            for (int i = 0; i < found.corners.size; ++i) {
                PointIndex2D_F64 foundCorner = (PointIndex2D_F64)found.corners.get(i);
                utils.cornerToMarker3D(markerID, foundCorner.index, this.point3);
                Point2D_F64 p = (Point2D_F64)((PointIndex2D_F64)found.corners.get((int)i)).p;
                ((AssociatedPair)this.pairs.get(i)).setTo(this.point3.x, this.point3.y, p.x, p.y);
            }
            Homography2D_F64 h = this.listMarkerToPixels.grow();
            if (!computeHomography.process(this.pairs.toList(), this.tmp)) {
                CommonOps_DDF3.fill(h, 0.0);
                continue;
            }
            DConvertMatrixStruct.convert(this.tmp, h);
        }
    }

    @Override
    public int totalFound() {
        return this.foundToDetection.size;
    }

    @Override
    public void getCenter(int which, Point2D_F64 location) {
        HomographyPointOps_F64.transform((Homography2D_F64)this.listMarkerToPixels.get(which), 0.0, 0.0, location);
    }

    @Override
    public Polygon2D_F64 getBounds(int which, @Nullable Polygon2D_F64 storage) {
        if (storage == null) {
            storage = new Polygon2D_F64(4);
        } else {
            storage.vertexes.resize(4);
        }
        HomographyPointOps_F64.transform((Homography2D_F64)this.listMarkerToPixels.get(which), -0.5, -0.5, storage.get(0));
        HomographyPointOps_F64.transform((Homography2D_F64)this.listMarkerToPixels.get(which), -0.5, 0.5, storage.get(1));
        HomographyPointOps_F64.transform((Homography2D_F64)this.listMarkerToPixels.get(which), 0.5, 0.5, storage.get(2));
        HomographyPointOps_F64.transform((Homography2D_F64)this.listMarkerToPixels.get(which), 0.5, -0.5, storage.get(3));
        return storage;
    }

    @Override
    public long getId(int which) {
        return this.foundIndexToFound((int)which).markerID;
    }

    @Override
    public String getMessage(int which) {
        return "" + this.getId(which);
    }

    @Override
    public double getWidth(int which) {
        int markerID = this.foundIndexToFound((int)which).markerID;
        ConfigECoCheckMarkers.MarkerShape marker = (ConfigECoCheckMarkers.MarkerShape)this.markerShapes.get(markerID);
        return (marker.getWidth() + marker.getHeight()) / 2.0;
    }

    @Override
    public boolean hasID() {
        return true;
    }

    @Override
    public boolean hasMessage() {
        return false;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.detector.getImageType();
    }

    @Override
    public double getSideWidth(int which) {
        int markerID = this.foundIndexToFound((int)which).markerID;
        return ((ConfigECoCheckMarkers.MarkerShape)this.markerShapes.get(markerID)).getWidth();
    }

    @Override
    public double getSideHeight(int which) {
        int markerID = this.foundIndexToFound((int)which).markerID;
        return ((ConfigECoCheckMarkers.MarkerShape)this.markerShapes.get(markerID)).getHeight();
    }

    @Override
    public List<PointIndex2D_F64> getDetectedControl(int which) {
        return this.foundIndexToFound((int)which).corners.toList();
    }

    @Override
    protected List<Point2D3D> getControl3D(int which) {
        Objects.requireNonNull(this.pixelToNorm);
        ECoCheckFound found = this.foundIndexToFound(which);
        ConfigECoCheckMarkers.MarkerShape marker = (ConfigECoCheckMarkers.MarkerShape)this.markerShapes.get(found.markerID);
        this.points2D3D.resetResize(found.corners.size);
        ECoCheckUtils utils = this.detector.getUtils();
        double markerLength = Math.max(marker.getWidth(), marker.getHeight());
        for (int i = 0; i < found.corners.size; ++i) {
            PointIndex2D_F64 corner = (PointIndex2D_F64)found.corners.get(i);
            Point2D3D p23 = (Point2D3D)this.points2D3D.get(i);
            utils.cornerToMarker3D(found.markerID, corner.index, p23.location);
            this.pixelToNorm.compute(((Point2D_F64)corner.p).x, ((Point2D_F64)corner.p).y, p23.observation);
            p23.location.scale(markerLength);
        }
        return this.points2D3D.toList();
    }

    private ECoCheckFound foundIndexToFound(int which) {
        return (ECoCheckFound)this.detector.getFound().get(this.foundToDetection.get(which));
    }

    public ECoCheckDetector<T> getDetector() {
        return this.detector;
    }
}

