/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.intensity;

import boofcv.abst.feature.detect.intensity.BaseGeneralFeatureIntensity;
import boofcv.alg.filter.derivative.HessianThreeDeterminant;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.struct.ListIntPoint2D;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import org.jetbrains.annotations.Nullable;

public class WrapperHessianThreeImageDetIntensity<I extends ImageGray<I>, D extends ImageGray<D>>
extends BaseGeneralFeatureIntensity<I, D> {
    ImageBorder_F32 borderF32 = (ImageBorder_F32)FactoryImageBorder.single(BorderType.EXTENDED, GrayF32.class);
    ImageBorder_S32 borderS32 = (ImageBorder_S32)FactoryImageBorder.single(BorderType.EXTENDED, GrayU8.class);

    public WrapperHessianThreeImageDetIntensity(Class<I> imageType) {
        super(imageType, null);
    }

    @Override
    public void process(I image, @Nullable D derivX, @Nullable D derivY, @Nullable D derivXX, @Nullable D derivYY, @Nullable D derivXY) {
        this.init(((ImageGray)image).width, ((ImageGray)image).height);
        if (image instanceof GrayU8) {
            HessianThreeDeterminant.process((GrayU8)image, this.intensity, (ImageBorder_S32<GrayU8>)this.borderS32);
        } else if (image instanceof GrayF32) {
            HessianThreeDeterminant.process((GrayF32)image, this.intensity, this.borderF32);
        } else {
            throw new IllegalArgumentException("Unsupported input image type");
        }
    }

    @Override
    @Nullable
    public ListIntPoint2D getCandidatesMin() {
        return null;
    }

    @Override
    @Nullable
    public ListIntPoint2D getCandidatesMax() {
        return null;
    }

    @Override
    public boolean getRequiresGradient() {
        return false;
    }

    @Override
    public boolean getRequiresHessian() {
        return false;
    }

    @Override
    public boolean hasCandidates() {
        return false;
    }

    @Override
    public int getIgnoreBorder() {
        return 0;
    }

    @Override
    public boolean localMinimums() {
        return true;
    }

    @Override
    public boolean localMaximums() {
        return true;
    }
}

