/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.describe;

import boofcv.abst.feature.describe.DescribePointRadiusAngle;
import boofcv.alg.feature.describe.DescribePointSurfPlanar;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;

public class DescribeSurfPlanar_RadiusAngle<T extends ImageGray<T>, II extends ImageGray<II>>
implements DescribePointRadiusAngle<Planar<T>, TupleDesc_F64> {
    DescribePointSurfPlanar<II> alg;
    T gray;
    II grayII;
    Planar<II> bandII;
    ImageType<Planar<T>> imageType;
    final double canonicalRadius;

    public DescribeSurfPlanar_RadiusAngle(DescribePointSurfPlanar<II> alg, Class<T> imageType, Class<II> integralType) {
        this.alg = alg;
        this.gray = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.grayII = GeneralizedImageOps.createSingleBand(integralType, 1, 1);
        this.bandII = new Planar<II>(integralType, 1, 1, alg.getNumBands());
        this.imageType = ImageType.pl(alg.getNumBands(), imageType);
        this.canonicalRadius = (double)alg.getDescribe().getCanonicalWidth() / 2.0;
    }

    @Override
    public void setImage(Planar<T> image) {
        ((ImageGray)this.gray).reshape(image.width, image.height);
        ((ImageGray)this.grayII).reshape(image.width, image.height);
        this.bandII.reshape(image.width, image.height);
        GConvertImage.average(image, this.gray);
        GIntegralImageOps.transform(this.gray, this.grayII);
        for (int i = 0; i < image.getNumBands(); ++i) {
            GIntegralImageOps.transform(image.getBand(i), this.bandII.getBand(i));
        }
        this.alg.setImage(this.grayII, this.bandII);
    }

    @Override
    public boolean process(double x, double y, double orientation, double radius, TupleDesc_F64 description) {
        double scale = radius / this.canonicalRadius;
        this.alg.describe(x, y, orientation, scale, description);
        return true;
    }

    @Override
    public boolean isScalable() {
        return true;
    }

    @Override
    public boolean isOriented() {
        return true;
    }

    @Override
    public ImageType<Planar<T>> getImageType() {
        return this.imageType;
    }

    @Override
    public double getCanonicalWidth() {
        return this.alg.getDescribe().getCanonicalWidth();
    }

    @Override
    public TupleDesc_F64 createDescription() {
        return this.alg.createDescription();
    }

    @Override
    public Class<TupleDesc_F64> getDescriptionType() {
        return TupleDesc_F64.class;
    }
}

