/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.dense;

import boofcv.abst.feature.dense.DescribeImageDense;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.dense.DescribeDenseSiftAlg;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_I32;
import java.util.List;

public class DescribeImageDenseSift<T extends ImageGray<T>, D extends ImageGray<D>>
implements DescribeImageDense<T, TupleDesc_F64> {
    DescribeDenseSiftAlg<D> alg;
    ImageGradient<T, D> gradient;
    ImageType<T> inputType;
    double periodX;
    double periodY;
    D derivX;
    D derivY;

    public DescribeImageDenseSift(DescribeDenseSiftAlg<D> alg, double periodX, double periodY, Class<T> inputType) {
        this.alg = alg;
        this.periodX = periodX;
        this.periodY = periodY;
        this.inputType = ImageType.single(inputType);
        Class<D> gradientType = alg.getDerivType();
        this.gradient = FactoryDerivative.three(inputType, gradientType);
        this.derivX = GeneralizedImageOps.createSingleBand(gradientType, 1, 1);
        this.derivY = GeneralizedImageOps.createSingleBand(gradientType, 1, 1);
    }

    @Override
    public void process(T input) {
        this.alg.setPeriodColumns(this.periodX);
        this.alg.setPeriodRows(this.periodY);
        ((ImageGray)this.derivX).reshape(((ImageGray)input).width, ((ImageGray)input).height);
        ((ImageGray)this.derivY).reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.gradient.process(input, this.derivX, this.derivY);
        this.alg.setImageGradient(this.derivX, this.derivY);
        this.alg.process();
    }

    @Override
    public List<TupleDesc_F64> getDescriptions() {
        return this.alg.getDescriptors().toList();
    }

    @Override
    public List<Point2D_I32> getLocations() {
        return this.alg.getLocations().toList();
    }

    @Override
    public ImageType<T> getImageType() {
        return this.inputType;
    }

    @Override
    public TupleDesc_F64 createDescription() {
        return new TupleDesc_F64(this.alg.getDescriptorLength());
    }

    @Override
    public Class<TupleDesc_F64> getDescriptionType() {
        return TupleDesc_F64.class;
    }

    public DescribeDenseSiftAlg<D> getAlg() {
        return this.alg;
    }
}

