/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.associate;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.BaseAssociateDescriptionSets;
import boofcv.abst.feature.associate.BaseAssociateSets;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;

public class AssociateDescriptionHashSets<Desc>
extends BaseAssociateDescriptionSets<Desc> {
    final AssociateDescription<Desc> associator;
    TIntIntMap setToIndex = new TIntIntHashMap(10, 0.5f, -1, -1);
    public boolean createNewSetsFromSource = true;
    public boolean createNewSetsFromDestination = true;
    public final DogArray_I32 setsAddedBySrc = new DogArray_I32();
    public final DogArray_I32 setsAddedByDst = new DogArray_I32();

    public AssociateDescriptionHashSets(AssociateDescription<Desc> associator) {
        super(associator);
        this.associator = associator;
    }

    @Override
    public void initialize(int numberOfSets) {
        assert (numberOfSets > 0);
        this.countSrc = 0;
        this.countDst = 0;
        this.unassociatedDst.reset();
        this.unassociatedDst.reset();
        this.sets.reset();
        this.setToIndex.clear();
        this.setsAddedBySrc.reset();
        this.setsAddedByDst.reset();
    }

    @Override
    public void addSource(Desc description, int set) {
        BaseAssociateSets.SetStruct ss = this.lookupSetByID(set, true, this.createNewSetsFromSource);
        if (ss == null) {
            return;
        }
        ss.src.add(description);
        ss.indexSrc.add(this.countSrc++);
    }

    @Override
    public void addDestination(Desc description, int set) {
        BaseAssociateSets.SetStruct ss = this.lookupSetByID(set, false, this.createNewSetsFromDestination);
        if (ss == null) {
            return;
        }
        ss.dst.add(description);
        ss.indexDst.add(this.countDst++);
    }

    @Nullable
    private BaseAssociateSets.SetStruct lookupSetByID(int set, boolean src, boolean createNewSet) {
        BaseAssociateSets.SetStruct ss;
        int setIndex = this.setToIndex.get(set);
        if (setIndex == -1) {
            if (!createNewSet) {
                return null;
            }
            if (src) {
                this.setsAddedBySrc.add(this.sets.size);
            } else {
                this.setsAddedByDst.add(this.sets.size);
            }
            this.setToIndex.put(set, this.sets.size);
            ss = (BaseAssociateSets.SetStruct)this.sets.grow();
        } else {
            ss = (BaseAssociateSets.SetStruct)this.sets.get(setIndex);
        }
        return ss;
    }

    @Override
    public void clearSource() {
        super.clearSource();
        this.setsAddedBySrc.reset();
    }

    @Override
    public void clearDestination() {
        super.clearDestination();
        this.setsAddedByDst.reset();
    }

    @Override
    public void associate() {
        if (this.sets.size <= 0) {
            throw new IllegalArgumentException("You must initialize first with the number of sets");
        }
        this.matches.reset();
        this.unassociatedSrc.reset();
        this.unassociatedDst.reset();
        DogArray_I32 setList = this.setsAddedBySrc.size > this.setsAddedByDst.size ? this.setsAddedBySrc : this.setsAddedByDst;
        for (int setListIdx = 0; setListIdx < setList.size; ++setListIdx) {
            int setIdx = setList.get(setListIdx);
            BaseAssociateSets.SetStruct set = (BaseAssociateSets.SetStruct)this.sets.get(setIdx);
            if (set.src.size == 0 || set.dst.size == 0) continue;
            this.associator.setSource(set.src);
            this.associator.setDestination(set.dst);
            this.associator.associate();
            this.saveSetAssociateResults(set);
        }
    }
}

