# Generated by Django 3.2.15 on 2022-11-14 12:52

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('django_apscheduler', '0008_remove_djangojobexecution_started'),
    ]

    operations = [
        migrations.CreateModel(
            name='MonitorRecipients',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('method', models.CharField(max_length=50, verbose_name='通知工具，邮件或者钉钉')),
                ('rev_addr', models.CharField(max_length=255, unique=True, verbose_name='地址')),
                ('rev_name', models.CharField(max_length=100, null=True, unique=True, verbose_name='名称')),
                ('is_default', models.SmallIntegerField(default=0, verbose_name='0: 不是默认， 1：默认收件人')),
                ('create_time', models.DateTimeField(auto_now=True)),
                ('update_time', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='MonitorRules',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('spider_host', models.CharField(max_length=50, verbose_name='爬虫所在主机')),
                ('spider_project', models.CharField(max_length=100, null=True, verbose_name='爬虫项目')),
                ('spider_name', models.CharField(max_length=100, null=True, verbose_name='爬虫名称')),
                ('spider_job_id', models.CharField(db_index=True, max_length=100, null=True)),
                ('monitor_freq', models.IntegerField(default=1800, verbose_name='监控频率，秒为单位')),
                ('log_alive_limit', models.IntegerField(default=80, verbose_name='日志存活时间上限, 默认80sec')),
                ('errlog_rate_limit', models.FloatField(default=0.005, verbose_name='1小时日志错误率上限，默认0.5%')),
                ('memory_use_limit', models.IntegerField(default=500, verbose_name='占用最大内存，默认500MB')),
                ('create_time', models.DateTimeField(auto_now=True)),
                ('update_time', models.DateTimeField(auto_now_add=True)),
                ('recipients', models.ManyToManyField(to='app_schedule.MonitorRecipients', verbose_name='收件人')),
                ('timer_task', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, to='django_apscheduler.djangojob')),
            ],
        ),
    ]
