# Generated by Django 3.2.15 on 2022-09-23 01:15

from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='DailyErrLogRate',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('host', models.CharField(max_length=50)),
                ('project', models.CharField(max_length=255)),
                ('spider', models.CharField(max_length=255)),
                ('job_id', models.CharField(db_index=True, max_length=50)),
                ('record_time', models.DateTimeField(db_index=True)),
                ('log_total_count', models.IntegerField()),
                ('log_error_count', models.IntegerField()),
                ('log_error_rate', models.FloatField(verbose_name='一天范围日志错误率')),
                ('log_date', models.DateField()),
                ('create_time', models.DateTimeField(auto_now=True)),
                ('update_time', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='ErrorLog',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('host', models.CharField(max_length=50)),
                ('project', models.CharField(max_length=255)),
                ('spider', models.CharField(max_length=255)),
                ('job_id', models.CharField(db_index=True, max_length=50)),
                ('record_time', models.DateTimeField(db_index=True)),
                ('content', models.TextField()),
                ('level', models.CharField(max_length=20)),
                ('log_time', models.DateTimeField(db_index=True)),
                ('module', models.CharField(max_length=1000)),
                ('lineno', models.IntegerField()),
                ('exc_info', models.TextField(default=None, null=True)),
                ('func_name', models.CharField(default=None, max_length=255)),
                ('create_time', models.DateTimeField(auto_now=True)),
                ('update_time', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='HourlyErrLogRate',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('host', models.CharField(max_length=50)),
                ('project', models.CharField(max_length=255)),
                ('spider', models.CharField(max_length=255)),
                ('job_id', models.CharField(db_index=True, max_length=50)),
                ('record_time', models.DateTimeField(db_index=True)),
                ('log_total_count', models.IntegerField()),
                ('log_error_count', models.IntegerField()),
                ('log_error_rate', models.FloatField(verbose_name='一小时范围日志错误率')),
                ('log_date', models.DateField()),
                ('log_hour', models.IntegerField(verbose_name='0-23 represent 24 hours')),
                ('create_time', models.DateTimeField(auto_now=True)),
                ('update_time', models.DateTimeField(auto_now_add=True)),
            ],
        ),
    ]
