#!/bin/bash

# This script starts the server; the following options are available:
#
# -h the help
#
#
# $Revision: 1.3 $
# FracPete

function usage()
{
   echo
   echo "usage: ${0##*/} -j <filename> -r <filename> -p <port> -o <dir> [-h]"
   echo "       -J <Java-home> -A <ANT-home>"
   echo 
   echo "starts the JobServer"
   echo 
   echo " -h   this help"
   echo " -j   the filename of the jobs (optional)"
   echo "      default: $JOBS"
   echo " -r   the file where to store the results (optional)"
   echo "      default: $RESULTS"
   echo " -o   the directory to store received files in"
   echo "      default: $OUTPUT"
   echo " -p   the port on which the server should listen (optional)"
   echo "      default: $PORT"
   echo " -v   classname(s) (comma separated list) for which to switch verbose"
   echo "      mode on (optional)"
   echo "      default: $VERBOSE"
   echo " -A   the location of ANT (above 'bin')"
   echo "      default: $ANT_HOME"
   echo " -J   the location of Java (above 'bin')"
   echo "      default: $JAVA_HOME"
   echo
}

# variables
ANT=$ANT_HOME/bin/ant
ROOT=`expr "$0" : '\(.*\)/'`
XMLDIR="$ROOT/../xml"
PORT=31415
RESULTS="$ROOT/../tmp/results.$PORT"
OUTPUT="$ROOT/../tmp"
JOBS="$OUTPUT/jobs"
VERBOSE=""

# interprete parameters
while getopts ":hj:o:p:r:v:A:J:" flag
do
   case $flag in
      h) usage
         exit 0
         ;;
      j) JOBS=$OPTARG
         ;;
      o) OUTPUT=$OPTARG
         ;;
      p) PORT=$OPTARG
         ;;
      r) RESULTS=$OPTARG
         ;;
      v) VERBOSE=$OPTARG
         ;;
      A) ANT_HOME=$OPTARG
         ;;
      J) JAVA_HOME=$OPTARG
         ;;
      *) usage
         exit 1
         ;;
   esac
done

export JAVA_HOME
export ANT_HOME

# start server
COMMAND="$ANT -f $XMLDIR/remote.xml server -Dserver.port=$PORT -Dserver.jobs=$JOBS -Dserver.results=$RESULTS -Dserver.output=$OUTPUT -Dverbose=$VERBOSE"

if [ ! "$VERBOSE" = "" ]
then
   echo $COMMAND
fi

$COMMAND
