#!/bin/bash

# This script runs the jobs generated for the distributed experiments on a
# single machine.
#
# -h  displays the help
#
#
# $Revision: 1.2 $
# FracPete

function usage()
{
   echo
   echo "usage: ${0##*/} -j <job-file> [-h]"
   echo 
   echo "Runs the jobs generateed for the distributed experiments on a single"
   echo "machine."
   echo
   echo " -h   this help"
   echo " -j   the name of the jobfile to execute"
   echo "      default: $JOBS"
   echo
}

# counts the lines of the job file and returns the result in TMP
function count_jobs()
{
   TMP=`cat $JOBS | grep -v "^$\|^#\|synchronize" | wc -l | sed s/" "*//g`
}

# returns the specified line (in LINE) from the job file in TMP
function get_line()
{
   TMP=`cat $JOBS | grep -v "^$\|^#\|synchronize" | head -n $LINE | tail -n 1`
}

# variables
ROOT=`expr "$0" : '\(.*\)/'`
JOBS="$ROOT/../tmp/jobs"
JAVA=java
MEMORY=1200m

# interprete parameters
while getopts ":hj:" flag
do
   case $flag in
      h) usage
         exit 0
         ;;
      j) JOBS=$OPTARG
         ;;
      *) usage
         exit 1
         ;;
   esac
done

# start the clients
count_jobs;COUNT=$TMP

# build classpath
CP=`$ROOT/classpath.sh`

for ((i = 1; i <= $COUNT; i++))
do
   # get job
   LINE=$i;get_line;JOB=$TMP

   # was it a comment?
   JOB=`echo $JOB | sed s/#.*//g`
   if [ "$JOB" = "" ]
   then
      continue
   fi
   
   # run job
   echo "$i/$COUNT"
   $JAVA -Xmx$MEMORY -classpath "$CP" $JOB
done

