#!/bin/bash

# Starts the main GUI if no specific class is specified.
#
# -h for help
#
#
# $Revision: 1.7 $
# FracPete

function usage()
{
   echo
   echo "usage: ${0##*/} [-c <classname>] [-p <parameter>] [-m <memory>] [-h]"
   echo 
   echo "starts the main GUI if no specific class is specified"
   echo 
   echo " -h   this help"
   echo " -c   <classname>"
   echo "      the class to run instead of the main GUI (additional parameters"
   echo "      can be specified with '-p')"
   echo " -p   <parameters>"
   echo "      additional parameters for other classes besides the main GUI"
   echo " -m   <memory>"
   echo "      amount of memory for the VM, e.g. 800m"
   echo
}

# variables
JAVA=java
ROOT=`expr "$0" : '\(.*\)/'`
SHELL=`which xterm`
if [ "$OSTYPE" = "cygwin" ]
then
   SHELL=`cygpath -m $SHELL`
fi
BASH=`which bash`
SHELL="$SHELL -sl 1000 -sb -rightbar -fg lightgrey -bd lightgrey -bg black -T WEKA-Proper -e $BASH -il"
CLASS=
PARAMETER=
MEMORY=800m

# interprete parameters
while getopts ":hc:p:m:" flag
do
   case $flag in
      c) CLASS=$OPTARG
         ;;
      p) PARAMETER=$OPTARG
         ;;
      m) MEMORY=$OPTARG
         ;;
      h) usage
         exit 0
         ;;
      *) usage
         exit 1
         ;;
   esac
done

# no class? -> main GUI
CP=`$ROOT/classpath.sh`
if [ "$CLASS" = "" ]
then
   CLASS="proper.gui.Proper"
   $JAVA -Xmx$MEMORY -classpath "$CP" $CLASS -shell "$SHELL"
else
   $JAVA -Xmx$MEMORY -classpath "$CP" $CLASS $PARAMETER
fi


