#!/bin/bash

# This script uses ssh agent to retrieve information from clients.
# For ssh-agent see: http://mah.everybody.org/docs/ssh
#
# -h  displays the help
#
#
# $Revision: 1.1.1.1 $
# FracPete

function usage()
{
   echo
   echo "usage: ${0##*/} -H <host-file> -o <filename> [-h]"
   echo 
   echo "Retrieves information from clients"
   echo "For ssh-agent see: http://mah.everybody.org/docs/ssh"
   echo "The clients file is a simple text file with a hostname in each line."
   echo "E.g.:"
   echo "   somehost"
   echo "   anotherone"
   echo
   echo " -h   this help"
   echo " -H   the name of the file containing the hostnames for the clients"
   echo "      default: $HOSTS"
   echo " -o   <filename>"
   echo "      the file where to store the output"
   echo "      default: $OUTPUT"
   echo
}

# counts the lines of the hosts file and returns the result in TMP
function count_hosts()
{
   TMP=`cat $HOSTS | grep -v "^$\|^#" | wc -l | sed s/" "*//g`
}

# returns the specified line (in LINE) from the hosts file in TMP
function get_line()
{
   TMP=`cat $HOSTS | grep -v "^$\|^#" | head -n $LINE | tail -n 1`
}

# returns the hosts from the specified line (in LINE) from the hosts file in TMP
function get_host()
{
   get_line
   TMP=`echo $TMP | cut -f1 -d";"`
}

# returns additional commands from the specified line (in LINE) from the hosts
# file in TMP
function get_additional()
{
   get_host
   TMP2=$TMP
   get_line
   TMP=`echo $TMP | sed s/"$TMP2;"//g`
}

# variables
ROOT=`expr "$0" : '\(.*\)/'`
SCRIPT=
HOSTS="$ROOT/../tmp/clients"
OUTPUT="$ROOT/../tmp/info_clients.txt"
OUTPUT_CSV=$OUTPUT".csv"
SCRIPT="$ROOT/info_client.sh"

# interprete parameters
while getopts ":hH:o:" flag
do
   case $flag in
      h) usage
         exit 0
         ;;
      H) HOSTS=$OPTARG
         ;;
      o) OUTPUT=$OPTARG
         OUTPUT_CSV=$OPTARG".csv"
         ;;
      *) usage
         exit 1
         ;;
   esac
done
shift $(($OPTIND - 1))

# delete the output
rm -f $OUTPUT
rm -f $OUTPUT_CSV

# start the clients
count_hosts;COUNT=$TMP

for ((i = 1; i <= $COUNT; i++))
do
   # get host
   LINE=$i;get_host;HOST=$TMP

   # was it a comment?
   HOST=`echo $HOST | sed s/#.*//g`
   if [ "$HOST" = "" ]
   then
      continue
   fi
   
   # additional parameters?
   get_additional

   # ssh
   echo "$i/$COUNT: $HOST"
   ssh $HOST "bash --login -ic \"cd `pwd`; $SCRIPT -o $OUTPUT\""
done

