#!/bin/bash
#
# This script checks the ant XML files based on the file given in XML; it
# it only checks whether all targets in this XML file also appear in the others.
#
# $Revision: 1.3 $
# FracPete

# the usage of this script
function usage()
{
   echo
   echo "usage: ${0##*/} [-h]"
   echo 
   echo "Performs some checks on the ANT XML files, e.g. whether the targets in"
   echo "$XML also appear in the other files."
   echo
   echo " -h   this help"
   echo
}

# returns the contents of "all" target from XML file TMP in TMP
function get_all_target()
{
   TMP=`cat $TMP`
   TMP=`echo $TMP | sed s/.*"\<target name=\"all\" depends=\""//g | sed s/"\"\/>".*//g`
}

# extracts the targets from the XML file TMPIN and writes them to TMPOUT
function get_targets()
{
   TMP=$TMPIN
   get_all_target
   echo $TMP | sed s/","/\\n/g | sed s/" "*//g > $TMPOUT
}

# cleans up
function clean_up()
{
   rm $CHECKTMP
   rm $CHECKTMP2
}

# variables
ROOT=`expr "$0" : '\(.*\)/'`
XMLDIR="$ROOT/../xml"
XML="$XMLDIR/database.xml"
CHECKTMP="$ROOT/check_ant.tmp"
CHECKTMP2="$ROOT/check_ant.tmp2"

# interprete parameters
while getopts ":h" flag
do
   case $flag in
      h) usage
         exit 0
         ;;
      *) usage
         exit 1
         ;;
   esac
done

# get all target
TMPIN=$XML;TMPOUT=$CHECKTMP;get_targets

# check all xml files
for i in $XMLDIR/*.xml
do
   FILE=`echo ${i##*/}`

   # skip file?
   if [ "$FILE" = "dispatcher.xml" ] || [ "$FILE" = "experiment.xml" ] || [ "$FILE" = "javadoc.xml" ] || [ "$FILE" = "remote.xml" ] || [ "$FILE" = "gui.xml" ]
   then
      continue
   fi
   
   # info
   echo $FILE

   # extract all target
   TMPIN=$i;TMPOUT=$CHECKTMP2;get_targets

   # compare files
   diff $CHECKTMP $CHECKTMP2
done

# clean up
clean_up

