/*
 * Decompiled with CFR 0.152.
 */
package proper.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSL {
    public static String transform(String xml, String xsl) {
        String result = "";
        try {
            result = XSL.transform(new StringReader(xml), new StringReader(xsl));
        }
        catch (Exception e) {
            e.printStackTrace();
            result = e.toString();
        }
        return result;
    }

    public static String transform(Reader xml, Reader xsl) {
        String result;
        try {
            StringWriter writer = new StringWriter();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer trans = factory.newTransformer(new StreamSource(xsl));
            trans.transform(new StreamSource(xml), new StreamResult(writer));
            result = writer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = e.toString();
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        Writer out;
        BufferedReader xsl;
        BufferedReader xml;
        if (args.length == 2) {
            xml = new BufferedReader(new FileReader(args[0]));
            xsl = new BufferedReader(new FileReader(args[1]));
            out = new BufferedWriter(new OutputStreamWriter(System.out));
        } else if (args.length == 3) {
            xml = new BufferedReader(new FileReader(args[0]));
            xsl = new BufferedReader(new FileReader(args[1]));
            out = new BufferedWriter(new FileWriter(args[2]));
        } else {
            xml = null;
            xsl = null;
            out = null;
            System.out.println("\nusage: XSL <xml> <xslt> [<out>]\n");
            System.exit(1);
        }
        String result = XSL.transform(xml, xsl);
        out.write(result);
        ((BufferedWriter)out).newLine();
        ((BufferedWriter)out).flush();
        ((BufferedWriter)out).close();
        xml.close();
        xsl.close();
    }
}

