/*
 * Decompiled with CFR 0.152.
 */
package proper.xml;

import java.util.Enumeration;
import java.util.Vector;
import proper.util.ProperVector;
import proper.xml.Document;
import proper.xml.Element;

public class Path {
    private static final boolean VERBOSE = false;

    private Vector find(Element node, String name, boolean all) {
        ProperVector result = new ProperVector();
        Enumeration enm = node.children();
        while (enm.hasMoreElements()) {
            Element e = (Element)enm.nextElement();
            if (this.fitsName(e, name)) {
                result.add(e);
            }
            if (e.getChildCount() <= 0 || !all) continue;
            Vector children = this.find(e, name, all);
            result.addAll(children);
        }
        return result;
    }

    private boolean fitsName(Element node, String name) {
        boolean result = name.equals("*");
        if (!result) {
            result = node.getName().equals(name);
        }
        return result;
    }

    private boolean fitsIndex(Element node, String indexStr) {
        boolean result = true;
        if (!indexStr.equals("")) {
            boolean bl = result = node.getParent() != null;
            if (result) {
                int index = indexStr.equals("last()") ? node.getParent().getChildCount() : Integer.parseInt(indexStr);
                result = node.getParent().getIndex(node) == index - 1;
            }
        }
        return result;
    }

    private Vector search(Vector nodes, String path) {
        String name;
        Vector result = new ProperVector();
        boolean descendants = false;
        boolean pathSeparator = false;
        if (path.startsWith("//")) {
            descendants = true;
            pathSeparator = true;
            path = path.substring(2, path.length());
        } else if (path.startsWith("/")) {
            pathSeparator = true;
            path = path.substring(1, path.length());
        } else if (path.startsWith(".//")) {
            descendants = true;
            pathSeparator = true;
            path = path.substring(3, path.length());
        } else if (path.startsWith("./")) {
            pathSeparator = true;
            path = path.substring(2, path.length());
        }
        if (path.indexOf("/") > -1) {
            name = path.substring(0, path.indexOf("/"));
            path = path.substring(path.indexOf("/"), path.length());
        } else {
            name = path;
            path = "";
        }
        String indexStr = "";
        if (name.indexOf("[") > -1) {
            indexStr = name.substring(name.indexOf("[") + 1, name.length() - 1);
            name = name.substring(0, name.indexOf("["));
        }
        int i = 0;
        while (i < nodes.size()) {
            Element elem = (Element)nodes.get(i);
            if (!pathSeparator && this.fitsName(elem, name) && this.fitsIndex(elem, indexStr)) {
                result.add(elem);
            }
            Vector found = this.find(elem, name, descendants);
            Enumeration enm = found.elements();
            while (enm.hasMoreElements()) {
                elem = (Element)enm.nextElement();
                if (!this.fitsIndex(elem, indexStr)) continue;
                result.add(elem);
            }
            ++i;
        }
        if (!path.equals("")) {
            result = this.search(result, path);
        }
        return result;
    }

    public Vector get(Element node, String path) {
        Vector result = new ProperVector();
        if (path.startsWith("/") || path.startsWith("//")) {
            node = (Element)node.getRoot();
        }
        result.add(node);
        result = this.search(result, path);
        return result;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: Path <xml-file> <path-expr>");
            System.exit(1);
        }
        Document doc = new Document();
        doc.read(args[0]);
        System.out.println("XML:\n" + doc);
        Path path = new Path();
        String pathStr = args[1];
        System.out.println("\nSearching for '" + pathStr + "'");
        Vector result = path.get(doc.getRoot(), pathStr);
        int i = 0;
        while (i < result.size()) {
            Element e = (Element)result.get(i);
            System.out.println(e.getName());
            ++i;
        }
    }
}

