/*
 * Decompiled with CFR 0.152.
 */
package proper.util;

import java.util.StringTokenizer;
import java.util.Vector;
import proper.util.ProperVector;

public class Strings {
    public static String[] breakUp(String s) {
        return Strings.breakUp(s, null);
    }

    public static String[] breakUp(String s, String delimiter) {
        StringTokenizer tok = delimiter == null ? new StringTokenizer(s) : new StringTokenizer(s, delimiter);
        String[] result = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            result[i] = tok.nextToken();
            ++i;
        }
        return result;
    }

    public static String[] breakUp(String s, String delimiter, String qualifier) {
        return Strings.breakUp(s, delimiter, qualifier, -1);
    }

    public static String[] breakUp(String s, String delimiter, String qualifier, int times) {
        int i;
        ProperVector parts = new ProperVector();
        boolean isString = false;
        boolean isDelimiter = false;
        boolean added = false;
        String part = "";
        String str = s;
        while (str.length() > 0) {
            if (times == 0) break;
            i = 0;
            while (i < delimiter.length()) {
                if (str.charAt(0) == delimiter.charAt(i)) {
                    isDelimiter = true;
                    break;
                }
                ++i;
            }
            if (isDelimiter && !isString) {
                --times;
                parts.add(part);
                part = "";
                str = str.substring(1, str.length());
                isDelimiter = false;
                added = !str.equals("");
                continue;
            }
            if (str.startsWith(qualifier)) {
                if (!isString && part.equals("") || isString) {
                    isString = !isString;
                } else {
                    part = String.valueOf(part) + str.substring(0, 1);
                }
            } else {
                part = String.valueOf(part) + str.substring(0, 1);
            }
            str = str.substring(1, str.length());
            added = false;
        }
        if (!added || !str.equals("")) {
            if (!str.equals("")) {
                part = String.valueOf(part) + str;
            }
            parts.add(part);
        }
        String[] result = new String[parts.size()];
        i = 0;
        while (i < parts.size()) {
            result[i] = (String)parts.get(i);
            ++i;
        }
        return result;
    }

    public static Vector breakUpVector(String s) {
        return Strings.arrayToVector(Strings.breakUp(s));
    }

    public static Vector breakUpVector(String s, String delimiter) {
        return Strings.arrayToVector(Strings.breakUp(s, delimiter));
    }

    public static Vector breakUpVector(String s, String delimiter, String qualifier) {
        return Strings.arrayToVector(Strings.breakUp(s, delimiter, qualifier));
    }

    public static Vector breakUpVector(String s, String delimiter, String qualifier, int times) {
        return Strings.arrayToVector(Strings.breakUp(s, delimiter, qualifier, times));
    }

    public static Vector arrayToVector(String[] array) {
        ProperVector result = new ProperVector();
        if (array == null) {
            return result;
        }
        int i = 0;
        while (i < array.length) {
            result.add(array[i]);
            ++i;
        }
        return result;
    }

    public static String[] vectorToArray(Vector vector) {
        return vector.toArray(new String[1]);
    }

    public static String escape(String line) {
        String tmp = "";
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) == '\"' || line.charAt(i) == '\\') {
                tmp = String.valueOf(tmp) + "\\";
            }
            tmp = String.valueOf(tmp) + line.charAt(i);
            ++i;
        }
        return tmp;
    }

    public static String[] fromCommalist(String list) {
        return Strings.breakUp(list, ",");
    }

    public static Vector fromCommalistVector(String list) {
        return Strings.arrayToVector(Strings.fromCommalist(list));
    }

    public static String toCommalist(String[] array) {
        return Strings.toCommalistVector(Strings.arrayToVector(array));
    }

    public static String toCommalistVector(Vector vector) {
        String result = "";
        int i = 0;
        while (i < vector.size()) {
            if (i > 0) {
                result = String.valueOf(result) + ",";
            }
            result = String.valueOf(result) + vector.get(i).toString();
            ++i;
        }
        return result;
    }

    public static String replaceAll(String src, String replace, String with) {
        String result = "";
        while (!src.equals("")) {
            int pos = src.indexOf(replace);
            if (pos == -1) {
                result = String.valueOf(result) + src;
                src = "";
                continue;
            }
            result = String.valueOf(result) + src.substring(0, pos) + with;
            src = src.substring(pos + replace.length(), src.length());
        }
        return result;
    }

    public static String left(String s, int count) {
        if (s.length() >= count) {
            return s.substring(0, count);
        }
        return s;
    }

    public static String right(String s, int count) {
        if (s.length() >= count) {
            return s.substring(s.length() - count, s.length());
        }
        return s;
    }

    public static String stringOf(char chr, int count) {
        return Strings.stringOf("" + chr, count);
    }

    public static String stringOf(String str, int count) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < count) {
            result.append(str);
            ++i;
        }
        return result.toString();
    }

    public static void main(String[] args) {
        String str = "This is a test w/o qualifier.";
        String[] parts = Strings.breakUp(str);
        System.out.println(str);
        int i = 0;
        while (i < parts.length) {
            System.out.println(parts[i]);
            ++i;
        }
        System.out.println();
        str = "This is a test, with other delimiters.";
        parts = Strings.breakUp(str, " ,");
        System.out.println(str);
        i = 0;
        while (i < parts.length) {
            System.out.println(parts[i]);
            ++i;
        }
        System.out.println();
        str = "This is a test \"with a\" qualifier.";
        parts = Strings.breakUp(str, " ", "\"");
        System.out.println(str);
        i = 0;
        while (i < parts.length) {
            System.out.println(parts[i]);
            ++i;
        }
        System.out.println();
        str = "This,is,another,test,";
        parts = Strings.breakUp(str, ",", "\"");
        System.out.println(str);
        i = 0;
        while (i < parts.length) {
            System.out.println(parts[i]);
            ++i;
        }
        System.out.println();
        str = "This,i\"s,\"another,test\",";
        parts = Strings.breakUp(str, ",", "\"");
        System.out.println(str);
        i = 0;
        while (i < parts.length) {
            System.out.println(parts[i]);
            ++i;
        }
        System.out.println();
        str = "nominal-filter=weka.filters.unsupervised.attribute.NominalToTrueBinary,nominal-filter-additional=\"=R first,last -V\",missing_binary_to_zero=-missing_binary_to_zero";
        parts = Strings.breakUp(str, ",", "\"");
        System.out.println(str);
        i = 0;
        while (i < parts.length) {
            System.out.println(parts[i]);
            ++i;
        }
        System.out.println();
        str = "a max=1 \"number=\" test=OK?";
        parts = Strings.breakUp(str, "=", "\"", 1);
        System.out.println(str);
        i = 0;
        while (i < parts.length) {
            System.out.println(parts[i]);
            ++i;
        }
        System.out.println();
        str = "a max=2 \"number=\" test=OK?";
        parts = Strings.breakUp(str, "=", "\"", 2);
        System.out.println(str);
        i = 0;
        while (i < parts.length) {
            System.out.println(parts[i]);
            ++i;
        }
        System.out.println();
        str = "a max=-1 \"number=\" test=OK?";
        parts = Strings.breakUp(str, "=", "\"", -1);
        System.out.println(str);
        i = 0;
        while (i < parts.length) {
            System.out.println(parts[i]);
            ++i;
        }
        System.out.println();
        str = "comma,list,with,bla,bla,and,nothing,else";
        System.out.println(String.valueOf(str) + "\nbecomes\n" + Strings.fromCommalistVector(str));
        System.out.println("\nand back\n" + Strings.toCommalist(Strings.vectorToArray(Strings.fromCommalistVector(str))));
        str = "123456890";
        System.out.println();
        System.out.println("left(3)   from " + str + " = " + Strings.left(str, 3));
        System.out.println("left(20)  from " + str + " = " + Strings.left(str, 20));
        System.out.println("right(3)  from " + str + " = " + Strings.right(str, 3));
        System.out.println("right(20) from " + str + " = " + Strings.right(str, 20));
    }
}

