/*
 * Decompiled with CFR 0.152.
 */
package proper.util;

import java.util.Vector;
import proper.util.CluderInterface;
import proper.util.Strings;

public class Excluder
implements CluderInterface {
    private Vector list;
    private boolean casesensitive;
    private boolean regexp;

    public Excluder(Vector l) {
        this(l, false);
    }

    public Excluder(Vector l, boolean casesensitive) {
        this(l, casesensitive, false);
    }

    public Excluder(Vector l, boolean casesensitive, boolean regexp) {
        this.list = l;
        this.casesensitive = casesensitive;
        this.regexp = regexp;
    }

    public Excluder(String l) {
        this(l, false);
    }

    public Excluder(String l, boolean casesensitive) {
        this(l, casesensitive, false);
    }

    public Excluder(String l, boolean casesensitive, boolean regexp) {
        this(Strings.fromCommalistVector(l), casesensitive, regexp);
    }

    @Override
    public Vector getList() {
        return this.list;
    }

    @Override
    public boolean getCaseSensitive() {
        return this.casesensitive;
    }

    public boolean getRegExp() {
        return this.regexp;
    }

    private boolean matches(String pattern, String s, boolean regexp) {
        boolean result = false;
        if (regexp) {
            if (!this.getCaseSensitive()) {
                pattern = pattern.toLowerCase();
            }
            result = pattern.matches(s);
        } else if (this.getRegExp()) {
            if (!this.getCaseSensitive()) {
                s = s.toLowerCase();
            }
            result = s.matches(pattern);
        } else {
            if (!this.getCaseSensitive()) {
                pattern = pattern.toLowerCase();
                s = s.toLowerCase();
            }
            String tmp = pattern.replaceAll("\\*", "");
            if (pattern.indexOf("*") >= 0) {
                if (pattern.startsWith("*")) {
                    result = pattern.endsWith("*") ? s.indexOf(tmp) >= 0 : s.endsWith(tmp);
                } else if (pattern.endsWith("*")) {
                    result = s.startsWith(tmp);
                }
            } else {
                result = pattern.equals(s);
            }
        }
        return result;
    }

    @Override
    public int matchIndex(String s) {
        return this.matchIndex(s, false);
    }

    @Override
    public int matchIndex(String s, boolean regexp) {
        int result = -1;
        int i = 0;
        while (i < this.list.size()) {
            if (this.matches((String)this.list.get(i), s, regexp)) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    public boolean contains(String s) {
        return this.contains(s, false);
    }

    @Override
    public boolean contains(String s, boolean regexp) {
        return this.matchIndex(s, regexp) > -1;
    }

    public String toString() {
        String result = "List         : " + this.list + "\n" + "Casesensitive: " + this.getCaseSensitive() + "\n" + "RegExp       : " + this.getRegExp();
        return result;
    }

    public static void main(String[] args) {
        Excluder e = new Excluder("What,ever,Letter,did,you,write");
        System.out.println("\n" + e);
        String tmp = "what";
        System.out.println(String.valueOf(tmp) + " = " + e.contains(tmp) + " (" + e.matchIndex(tmp) + ")");
        tmp = "letter";
        System.out.println(String.valueOf(tmp) + " = " + e.contains(tmp) + " (" + e.matchIndex(tmp) + ")");
        tmp = "write";
        System.out.println(String.valueOf(tmp) + " = " + e.contains(tmp) + " (" + e.matchIndex(tmp) + ")");
        tmp = ".*i.*";
        System.out.println(String.valueOf(tmp) + " = " + e.contains(tmp, true) + " (" + e.matchIndex(tmp, true) + ")");
        e = new Excluder("What,ever,Lett*,did,you,*rite");
        System.out.println("\n" + e);
        tmp = "what";
        System.out.println(String.valueOf(tmp) + " = " + e.contains(tmp) + " (" + e.matchIndex(tmp) + ")");
        tmp = "letter";
        System.out.println(String.valueOf(tmp) + " = " + e.contains(tmp) + " (" + e.matchIndex(tmp) + ")");
        tmp = "write";
        System.out.println(String.valueOf(tmp) + " = " + e.contains(tmp) + " (" + e.matchIndex(tmp) + ")");
        e = new Excluder("What,ever,Lett.*,did,you,.*rite", true, true);
        System.out.println("\n" + e);
        tmp = "what";
        System.out.println(String.valueOf(tmp) + " = " + e.contains(tmp) + " (" + e.matchIndex(tmp) + ")");
        tmp = "letter";
        System.out.println(String.valueOf(tmp) + " = " + e.contains(tmp) + " (" + e.matchIndex(tmp) + ")");
        tmp = "write";
        System.out.println(String.valueOf(tmp) + " = " + e.contains(tmp) + " (" + e.matchIndex(tmp) + ")");
    }
}

