/*
 * Decompiled with CFR 0.152.
 */
package proper.util;

import java.util.Collection;
import java.util.Vector;
import proper.util.ProperVector;
import proper.util.Strings;

public class Cells {
    private Vector matrix = new ProperVector();
    private Vector names;
    private boolean rowNumbers = false;

    public Cells(int rows, int columns) {
        this(rows, columns, null);
    }

    public Cells(int rows, int columns, Collection names) {
        this.setRowCount(1);
        this.setColumnCount(columns);
        this.setRowCount(rows);
        this.setNames(names);
    }

    public void setNames(Collection names) {
        this.names = new ProperVector();
        if (names != null) {
            this.names.addAll(names);
            int count = this.names.size();
            if (this.names.size() < this.getColumnCount()) {
                this.names.setSize(this.getColumnCount());
                int i = count;
                while (i < this.getColumnCount()) {
                    this.names.set(i, "");
                    ++i;
                }
            } else {
                this.names.setSize(this.getColumnCount());
            }
        }
    }

    public Vector getNames() {
        return this.names;
    }

    public String getName(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.names.size()) {
            return this.names.get(columnIndex).toString();
        }
        return null;
    }

    public boolean hasNames() {
        return this.getName(0) != null;
    }

    public void setRowNumbers(boolean rowNumbers) {
        this.rowNumbers = rowNumbers;
    }

    public boolean hasRowNumbers() {
        return this.rowNumbers;
    }

    public void setColumnCount(int columns) {
        if (columns > this.getColumnCount()) {
            int i = 0;
            while (i < this.getRowCount()) {
                int count = this.getColumnCount();
                Vector v = (Vector)this.matrix.get(i);
                v.setSize(columns);
                int n = count;
                while (n < v.size()) {
                    v.set(n, "");
                    ++n;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.getRowCount()) {
                Vector v = (Vector)this.matrix.get(i);
                v.setSize(columns);
                ++i;
            }
        }
    }

    public int getColumnCount() {
        int result = this.getRowCount() == 0 ? 0 : (this.matrix.get(0) instanceof Vector ? ((Vector)this.matrix.get(0)).size() : 0);
        return result;
    }

    public void setRowCount(int rows) {
        if (rows < this.getRowCount()) {
            this.matrix.setSize(rows);
        } else {
            int count = this.getRowCount();
            ProperVector v = new ProperVector();
            int i = 0;
            while (i < this.getColumnCount()) {
                v.add("");
                ++i;
            }
            this.matrix.setSize(rows);
            i = count;
            while (i < rows) {
                this.matrix.set(i, v.clone());
                ++i;
            }
        }
    }

    public int getRowCount() {
        return this.matrix.size();
    }

    private boolean isValidIndex(int rowIndex, int columnIndex) {
        return rowIndex >= 0 && rowIndex < this.getRowCount() && columnIndex >= 0 && columnIndex < this.getColumnCount();
    }

    public void setCellAt(int rowIndex, int columnIndex, Object value) {
        if (!this.isValidIndex(rowIndex, columnIndex)) {
            if (rowIndex >= this.getRowCount()) {
                this.setRowCount(rowIndex + 1);
            }
            if (columnIndex >= this.getColumnCount()) {
                this.setColumnCount(columnIndex + 1);
            }
        }
        ((Vector)this.matrix.get(rowIndex)).set(columnIndex, value);
    }

    public Object getCellAt(int rowIndex, int columnIndex) {
        if (this.isValidIndex(rowIndex, columnIndex)) {
            return ((Vector)this.matrix.get(rowIndex)).get(columnIndex);
        }
        return null;
    }

    private String fixCellValue(Object value) {
        if (value == null) {
            value = "null";
        }
        return value.toString();
    }

    public String getCellStringAt(int rowIndex, int columnIndex) {
        return this.fixCellValue(this.getCellAt(rowIndex, columnIndex));
    }

    public Object[][] toArray() {
        int col;
        int i = this.hasNames() ? this.getRowCount() + 1 : this.getRowCount();
        int n = this.hasRowNumbers() ? this.getColumnCount() + 1 : this.getColumnCount();
        Object[][] result = new Object[i][n];
        if (this.hasNames()) {
            if (this.hasRowNumbers()) {
                result[0][0] = "No.";
            }
            n = 0;
            while (n < this.getColumnCount()) {
                col = result[0].length - this.getColumnCount() + n;
                result[0][col] = this.getName(n);
                ++n;
            }
        }
        i = 0;
        while (i < this.getRowCount()) {
            int row = result.length - this.getRowCount() + i;
            if (this.hasRowNumbers()) {
                result[row][0] = Integer.toString(i + 1);
            }
            n = 0;
            while (n < this.getColumnCount()) {
                col = result[0].length - this.getColumnCount() + n;
                result[row][col] = this.getCellAt(i, n);
                ++n;
            }
            ++i;
        }
        return result;
    }

    public Vector toCSV() {
        ProperVector result = new ProperVector();
        Object[][] cells = this.toArray();
        int i = 0;
        while (i < cells.length) {
            StringBuffer line = new StringBuffer();
            int n = 0;
            while (n < cells[i].length) {
                String value = this.fixCellValue(cells[i][n]);
                if (n > 0) {
                    line.append(";");
                }
                if (value instanceof String) {
                    line.append("\"");
                }
                line.append(value.toString());
                if (value instanceof String) {
                    line.append("\"");
                }
                ++n;
            }
            result.add(line.toString());
            ++i;
        }
        return result;
    }

    public String toString() {
        String value;
        int i;
        StringBuffer result = new StringBuffer();
        Object[][] cells = this.toArray();
        if (cells.length == 0) {
            return result.toString();
        }
        int[] length = new int[cells[0].length];
        int n = 0;
        while (n < cells[0].length) {
            length[n] = -1;
            i = 0;
            while (i < cells.length) {
                value = this.fixCellValue(cells[i][n]);
                int len = value.toString().length();
                if (len > length[n]) {
                    length[n] = len;
                }
                ++i;
            }
            ++n;
        }
        i = 0;
        while (i < cells.length) {
            if (i > 0) {
                result.append("\n");
            }
            if (this.hasNames() && i == 1) {
                result.append(String.valueOf(Strings.stringOf("-", result.length() - 1)) + "\n");
            }
            n = 0;
            while (n < cells[i].length) {
                value = this.fixCellValue(cells[i][n]);
                String cell = value.toString();
                result.append(cell);
                result.append(Strings.stringOf(" ", length[n] - cell.length() + 1));
                ++n;
            }
            ++i;
        }
        return result.toString();
    }

    public static void main(String[] args) {
        Cells c = new Cells(2, 3);
        System.out.println(c.toCSV() + "\n");
        c.setCellAt(1, 1, "2");
        c.setCellAt(0, 0, "1");
        c.setCellAt(1, 2, "3");
        System.out.println(String.valueOf(c.toString()) + "\n");
        c.setCellAt(2, 2, "4");
        System.out.println(String.valueOf(c.toString()) + "\n");
        System.out.println(c.toCSV() + "\n");
        ProperVector v = new ProperVector();
        v.add("col1");
        v.add("column2");
        v.add("col3");
        c.setNames(v);
        System.out.println(String.valueOf(c.toString()) + "\n");
        System.out.println(c.toCSV() + "\n");
    }
}

