/*
 * Decompiled with CFR 0.152.
 */
package proper.tester.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import proper.tester.Tester;
import proper.tester.database.Column;
import proper.tester.database.Table;

public class CSVFileGenerator {
    private static CSVFileGenerator instance;
    private boolean haveLegend = false;

    private CSVFileGenerator() {
    }

    public static CSVFileGenerator getInstance() {
        if (instance == null) {
            instance = new CSVFileGenerator();
        }
        return instance;
    }

    public String getPath() {
        return String.valueOf(Tester.getProjectPath()) + Tester.getProjectName() + ".csv";
    }

    private void addCSVLegend() {
        Object param = Tester.getVariableParam();
        String line = "";
        line = param instanceof Table ? "Nb instances of " + ((Table)param).getName() + ",Percent" : String.valueOf(((Column)param).getName()) + " Max Value,Percent";
        File f = new File(this.getPath());
        try {
            FileWriter fw = new FileWriter(this.getPath(), false);
            BufferedWriter output = new BufferedWriter(fw);
            output.write(line);
            output.flush();
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addCSVLine(String value) {
        if (!this.haveLegend) {
            this.addCSVLegend();
            this.haveLegend = true;
        }
        Object param = Tester.getVariableParam();
        String line = "\n";
        line = param instanceof Table ? String.valueOf(line) + ((Table)param).getNbInstances() + "," + value : String.valueOf(((Column)param).getMaxValue()) + "," + value;
        File f = new File(this.getPath());
        try {
            FileWriter fw = new FileWriter(this.getPath(), true);
            BufferedWriter output = new BufferedWriter(fw);
            output.write(line);
            output.flush();
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

