/*
 * Decompiled with CFR 0.152.
 */
package proper.tester;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Scanner;
import java.util.Vector;
import proper.tester.database.Column;
import proper.tester.database.Table;
import proper.tester.engine.CommandLineRunner;
import proper.tester.engine.DatabaseEngine;
import proper.tester.engine.Labeler;
import proper.tester.file.CSVFileGenerator;
import proper.tester.file.XMLFileGenerator;

public class Tester {
    private static String dataBaseHost;
    private static String dataBaseType;
    private static String dataBaseName;
    private static String dataBaseUserLogin;
    private static String dataBaseUserPassword;
    private static String projectName;
    private static String properTableName;
    private static String properFieldName;
    private static String properResultTableName;
    private static String exportTableName;
    private static String exportFieldName;
    private static String exportFileOutput;
    private static Connection conn;
    private static Table rootTable;
    private static Object vCols;
    private static int vColsMaxValues;
    private static int vColsInc;

    private static void initializeDefault() {
        dataBaseHost = "localhost";
        dataBaseType = "postgresql";
        dataBaseName = "johnny";
        dataBaseUserLogin = "johnny";
        dataBaseUserPassword = "johnny";
        projectName = "testjonathan";
        properTableName = "ilot";
        properFieldName = "classe";
        properResultTableName = "_cardinalized";
        exportTableName = "_cardinalized";
        exportFieldName = "classe";
        exportFileOutput = "cardtest.arff";
        Tester.createProjectFolder();
    }

    public static void createProjectFolder() {
        try {
            Runtime run = Runtime.getRuntime();
            Process p = run.exec("mkdir " + System.getProperty("user.dir") + "/" + "tmp/" + projectName);
            System.out.println("Project folder create !");
        }
        catch (Exception e) {
            System.out.println("ERROR : Project folder create FAILED !");
            System.exit(0);
        }
    }

    private static void connectTest() {
        try {
            DatabaseEngine.getInstance().connect(dataBaseType, dataBaseHost, dataBaseName, dataBaseUserLogin, dataBaseUserPassword);
            rootTable = DatabaseEngine.getInstance().discoverRelations(properTableName);
            conn = DatabaseEngine.getInstance().getConnection();
            System.out.println("Connection test OK ! - " + Tester.postFixeTree(rootTable, new Vector<Table>()));
        }
        catch (Exception e) {
            System.out.println("ERROR : database connection FAILED !\n" + e.getMessage());
            System.exit(0);
        }
    }

    private static int countSteps() {
        return 5;
    }

    private static void configStep() {
        Tester.changeGenerationParameters();
        Tester.changeLabelingParameters();
    }

    private static void runStep() {
        Tester.clearTables();
        DatabaseEngine.getInstance().generation(rootTable);
        DatabaseEngine.getInstance().label(rootTable);
        CommandLineRunner cmdProper = new CommandLineRunner("sh tester.sh " + Tester.getProjectName());
        cmdProper.run();
        String cmd = "java -cp " + System.getProperty("user.dir") + "/jar/weka.jar weka.classifiers.trees.J48 -t " + Tester.getProjectPath() + Tester.getProjectName() + "-" + Tester.getExportOutputFile() + " -i";
        CommandLineRunner cmdWeka = new CommandLineRunner(cmd);
        cmdWeka.run();
        CSVFileGenerator csv = CSVFileGenerator.getInstance();
        csv.addCSVLine(cmdWeka.getOutputLine("Correctly Classified Instances").replaceAll("\\s+", " ").split(" ")[4]);
    }

    private static void clearTables() {
        Vector<Table> allTables = Tester.postFixeTree(rootTable, new Vector<Table>());
        for (Table tcurrent : allTables) {
            try {
                Statement st = conn.createStatement(1004, 1008);
                st.execute("DELETE FROM " + tcurrent.getName());
                st.close();
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
    }

    private static void changeGenerationParameters() {
        boolean testSettingChanged = false;
        Vector<Table> allTables = Tester.postFixeTree(rootTable, new Vector<Table>());
        Scanner scan = new Scanner(System.in);
        for (Table tcurrent : allTables) {
            System.out.println("TABLE : \"" + tcurrent.getName() + "\"");
            System.out.print("Nb instances: ");
            tcurrent.setNbInstances(scan.nextInt());
            if (!testSettingChanged) {
                System.out.print("Used this setting as unique variable columns : (1=yes/0=no) ");
                if (String.valueOf(scan.nextInt()).equals("1")) {
                    int nb;
                    vCols = tcurrent;
                    System.out.print("Maximal test value :");
                    vColsMaxValues = nb = scan.nextInt();
                    System.out.print("Incrementale value :");
                    vColsInc = nb = scan.nextInt();
                    testSettingChanged = true;
                }
            }
            int i = 0;
            while (i < tcurrent.getColumnCount()) {
                if (!tcurrent.getColumnAt(i).isKey()) {
                    System.out.print("Max values of \"" + tcurrent.getColumnAt(i) + "\" : ");
                    tcurrent.getColumnAt(i).setMaxValue(String.valueOf(scan.nextInt()));
                    if (!testSettingChanged) {
                        System.out.print("Used this column as unique variable columns : (1=yes/0=no) ");
                        if (String.valueOf(scan.nextInt()).equals("1")) {
                            vCols = tcurrent.getColumnAt(i);
                            System.out.print("Maximal test value :");
                            vColsMaxValues = scan.nextInt();
                            System.out.print("Incrementale value :");
                            vColsInc = scan.nextInt();
                            testSettingChanged = true;
                        }
                    }
                }
                ++i;
            }
        }
        scan.close();
    }

    private static void changeLabelingParameters() {
        Labeler.getInstance().setLabeledColumn(rootTable.getColumnAt(2));
        Labeler.getInstance().setMatchLabel("yes");
        Labeler.getInstance().setNoMatchLabel("no");
        Labeler.getInstance().setTableCondition("batiment");
        Labeler.getInstance().setColumnCondition("aire");
        Labeler.getInstance().setDepth(1);
        int val = (int)Math.round((double)vColsMaxValues * 0.6);
        if (val == 0) {
            val = 1;
        }
        int[] cardinality = new int[2];
        if (vCols instanceof Column) {
            Labeler.getInstance().setLimitCondition(val);
            cardinality[0] = ((Table)rootTable.getChildAt(0)).getNbInstances();
            cardinality[1] = 1;
            Labeler.getInstance().setCardinality(cardinality);
        } else {
            cardinality[0] = val;
            cardinality[1] = 1;
            Labeler.getInstance().setCardinality(cardinality);
            Labeler.getInstance().setLimitCondition(60);
        }
    }

    private static Vector<Table> postFixeTree(Table root, Vector<Table> vectTable) {
        int i = 0;
        while (i < root.getChildCount()) {
            Tester.postFixeTree((Table)root.getChildAt(i), vectTable);
            ++i;
        }
        vectTable.add(root);
        return vectTable;
    }

    private static void initialize() {
        Scanner scn = new Scanner(System.in);
        System.out.println("1---1> Choose the server type : ");
        System.out.println("1 - mysql");
        System.out.println("2 - postgresql");
        int nbType = scn.nextInt();
        if (nbType == 1) {
            dataBaseType = "mysql";
        } else if (nbType == 2) {
            dataBaseType = "postgresql";
        } else {
            System.out.println("Syntax error - Program will stop !");
            System.exit(0);
        }
        System.out.println("1---2> Choose the basename : ");
        dataBaseName = scn.nextLine();
        System.out.println("1---3> Choose the user login : ");
        dataBaseUserLogin = scn.nextLine();
        System.out.println("1---4> Choose the user password : ");
        dataBaseUserPassword = scn.nextLine();
        System.out.println("1---5> Choose the database host : ");
        dataBaseHost = scn.nextLine();
        System.out.println("1---6> Choose the project name : ");
        projectName = scn.nextLine();
        Tester.createProjectFolder();
    }

    public static String getProjectPath() {
        return String.valueOf(System.getProperty("user.dir")) + "/" + "tmp/" + projectName + "/";
    }

    public static String getProjectName() {
        return projectName;
    }

    public static String getServerType() {
        return dataBaseType;
    }

    public static String getServerHost() {
        return dataBaseHost;
    }

    public static String getDataBaseName() {
        return dataBaseName;
    }

    public static String getUserLogin() {
        return dataBaseUserLogin;
    }

    public static String getUserPassword() {
        return dataBaseUserPassword;
    }

    public static String getProperTableName() {
        return properTableName;
    }

    public static String getProperFieldName() {
        return properFieldName;
    }

    public static String getProperResultTableName() {
        return properResultTableName;
    }

    public static String getExportTableName() {
        return exportTableName;
    }

    public static String getExportFieldName() {
        return exportFieldName;
    }

    public static String getExportOutputFile() {
        return exportFileOutput;
    }

    public static void main(String[] args) {
        Tester.initializeDefault();
        System.out.println("Initializing finished !");
        XMLFileGenerator file = XMLFileGenerator.getInstance();
        file.exportFile();
        Tester.connectTest();
        Tester.configStep();
        boolean testFinished = false;
        int numStep = 1;
        int totalSteps = Tester.countSteps();
        while (!testFinished) {
            int valCurrent;
            System.out.println("TEST STEP : " + numStep + "/" + totalSteps);
            Tester.runStep();
            if (vCols instanceof Column) {
                valCurrent = Integer.parseInt(((Column)vCols).getMaxValue());
                if (String.valueOf(valCurrent).equals(String.valueOf(vColsMaxValues))) {
                    testFinished = true;
                } else {
                    if ((valCurrent += vColsInc) > vColsMaxValues) {
                        valCurrent = vColsMaxValues;
                        Labeler.getInstance().setLimitCondition((int)Math.round((double)vColsMaxValues * 0.6));
                    }
                    ((Column)vCols).setMaxValue(String.valueOf(valCurrent));
                }
            } else {
                valCurrent = ((Table)vCols).getNbInstances();
                if (String.valueOf(valCurrent).equals(String.valueOf(vColsMaxValues))) {
                    testFinished = true;
                } else {
                    if ((valCurrent += vColsInc) > vColsMaxValues) {
                        valCurrent = vColsMaxValues;
                        int[] card = new int[]{(int)Math.round((double)vColsMaxValues * 0.6), 1};
                        Labeler.getInstance().setCardinality(card);
                    }
                    ((Table)vCols).setNbInstances(valCurrent);
                }
            }
            ++numStep;
        }
    }

    public static Object getVariableParam() {
        return vCols;
    }
}

