/*
 * Decompiled with CFR 0.152.
 */
package proper.remote;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Stack;
import java.util.Vector;
import proper.io.TextFile;
import proper.net.Address;
import proper.remote.ClientList;
import proper.remote.JobServer;
import proper.remote.Processor;
import proper.remote.Server;
import proper.remote.messages.DataMessage;
import proper.remote.messages.FileMessage;
import proper.remote.messages.JobMessage;
import proper.remote.messages.Message;
import proper.util.ProperVector;
import proper.util.Strings;
import proper.util.Timestamp;

public class JobServerProcessor
extends Processor {
    private ClientList clients = this.getServer().getClientList(0);
    private ClientList available = this.getServer().getClientList(1);
    private ClientList pending = this.getServer().getClientList(2);
    private ClientList additional = this.getServer().getClientList(3);
    private Stack jobs = this.getServer().getJobs();
    private Vector jobsDone = this.getServer().getJobs(2);
    private Vector jobsFailed = this.getServer().getJobs(3);
    private String results = "";
    private String output = "";
    private Vector received = this.getServer().getReceived();

    public JobServerProcessor(Server server, Socket client) {
        super(server, client);
    }

    private JobServer getServer() {
        return (JobServer)this.server;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
        if (!output.endsWith("/") && !output.endsWith("\\")) {
            this.output = String.valueOf(this.output) + "/";
        }
    }

    public String getResults() {
        return this.results;
    }

    public void setResults(String results) {
        this.results = results;
    }

    private int getPort() {
        return this.getMessage().getPort();
    }

    private InetSocketAddress getClientAddress() {
        return new InetSocketAddress(this.client.getInetAddress().getCanonicalHostName(), this.getPort());
    }

    private void addClient() {
        InetSocketAddress addr = this.getClientAddress();
        this.server.checkClients();
        if (!this.clients.contains(addr)) {
            this.clients.add(addr);
            this.available.add(addr);
            String msg = addr + " registered.";
            this.addToAccessLog(msg);
            this.server.println("\n" + msg + "\n");
            this.server.checkClients();
        }
    }

    private void removeClient() {
        InetSocketAddress addr = this.getClientAddress();
        if (this.clients.contains(addr)) {
            this.clients.remove(addr);
            this.available.remove(addr);
            String msg = addr + " removed.\n";
            this.addToAccessLog(msg);
            this.server.println("\n" + msg);
        }
    }

    private void reregisterClients() {
        DataMessage datamsg = new DataMessage(this.getMessage());
        Vector lines = datamsg.getLines();
        Message message = this.createMessage("reregister");
        int i = 0;
        while (i < lines.size()) {
            String host = lines.get(i).toString();
            if (host.indexOf(":") == -1) {
                host = String.valueOf(host) + ":31416";
            }
            if (host.indexOf("/") == -1) {
                host = host.charAt(0) >= '1' && host.charAt(0) <= '9' ? "/" + host : host.replaceAll(":", "/:");
            }
            Address address = new Address(host);
            InetSocketAddress addr = null;
            try {
                addr = !address.getHost().equals("") ? new InetSocketAddress(address.getHost(), address.getPort()) : new InetSocketAddress(address.getIPStr(), address.getPort());
            }
            catch (Exception e) {
                this.server.println(e);
            }
            if (addr != null) {
                message = this.createMessage("reregister");
                this.sender.send(addr, message.toString());
            }
            String msg = "Sent re-register to " + addr;
            this.addToAccessLog(msg);
            this.server.println(msg);
            ++i;
        }
    }

    private void saveResult(boolean failed) throws Exception {
        FileMessage message = new FileMessage(this.getMessage());
        Vector lines = message.getLines();
        String stamp = new Timestamp(String.valueOf(message.getIP()) + ":" + message.getPort()).toString();
        int i = 0;
        while (i < lines.size()) {
            String line = (String)lines.get(i);
            line = String.valueOf(stamp.toString()) + line;
            lines.set(i, line);
            ++i;
        }
        TextFile.save(this.getResults(), lines, true);
        TextFile.save(message.getFilename(), lines, false);
        InetSocketAddress addr = this.getClientAddress();
        this.available.add(addr);
        this.pending.remove(addr);
        if (!failed) {
            this.jobsDone.add(lines.get(0));
        } else {
            this.jobsFailed.add(lines.get(0));
        }
        this.getServer().saveJobLists();
        String msg = !failed ? "Job finished by " + addr : "Job of " + addr + " failed";
        this.addToAccessLog(msg);
        this.server.println(msg);
    }

    private void addJobs() throws Exception {
        DataMessage msg = new DataMessage(this.getMessage());
        this.getServer().addJobs(msg.getLines());
    }

    private void deleteJob() throws Exception {
        DataMessage msg = new DataMessage(this.getMessage());
        Vector lines = msg.getLines();
        int[] indexes = new int[lines.size()];
        int i = 0;
        while (i < lines.size()) {
            String[] line = Strings.breakUp((String)lines.get(i), "\t");
            int index = line.length > 0 ? this.jobs.size() - Integer.parseInt(line[0]) - 1 : 0;
            String job = line.length > 1 ? line[1] : "";
            indexes[i] = this.jobs.get(index).equals(job) ? index : -1;
            if (this.server.getVerbose()) {
                this.server.println(lines.get(i) + " = " + indexes[i]);
            }
            ++i;
        }
        i = 0;
        while (i < indexes.length) {
            if (indexes[i] > -1) {
                String tmp = "Remove: " + lines.get(i);
                this.addToAccessLog(tmp);
                if (this.server.getVerbose()) {
                    this.server.println(tmp);
                }
                this.jobs.remove(indexes[i]);
            }
            ++i;
        }
    }

    private void saveFile() throws Exception {
        FileMessage message = new FileMessage(this.getMessage());
        TextFile.save(String.valueOf(this.getOutput()) + message.getFilename(), message.getLines());
        this.received.add(message.getFilename());
        InetSocketAddress addr = this.getClientAddress();
        String msg = "File '" + message.getFilename() + "' received from " + addr;
        this.addToAccessLog(msg);
        this.server.println(msg);
    }

    private void sendJobList() {
        ProperVector lines = new ProperVector();
        if (this.getRequest().equals("jobs_todo")) {
            int i = 0;
            while (i < this.jobs.size()) {
                lines.add(0, this.jobs.get(i));
                ++i;
            }
        } else if (this.getRequest().equals("jobs_done")) {
            lines.addAll(this.jobsDone);
        } else if (this.getRequest().equals("jobs_failed")) {
            lines.addAll(this.jobsFailed);
        }
        DataMessage message = new DataMessage(this.createMessage());
        message.setType(this.getMessage().getType());
        message.setLines(lines);
        InetSocketAddress addr = new InetSocketAddress(this.client.getInetAddress().getCanonicalHostName(), this.getMessage().getPort());
        this.sender.send(addr, message.toString());
        String msg = "JobList (" + this.getRequest() + ") sent to " + addr;
        this.server.addToAccessLog(msg);
        this.server.println(msg);
    }

    private void sendClients() {
        ProperVector lines = new ProperVector();
        if (this.getRequest().equals("clients")) {
            int i = 0;
            while (i < this.clients.size()) {
                lines.add(0, this.clients.get(i).toString());
                ++i;
            }
        } else if (this.getRequest().equals("pending")) {
            int i = 0;
            while (i < this.pending.size()) {
                lines.add(0, String.valueOf(this.pending.get(i).toString()) + ": " + this.pending.getJob(i));
                ++i;
            }
        } else if (this.getRequest().equals("additional")) {
            int i = 0;
            while (i < this.additional.size()) {
                lines.add(0, String.valueOf(this.additional.get(i).toString()) + ": " + this.additional.getJob(i));
                ++i;
            }
        }
        DataMessage message = new DataMessage(this.createMessage());
        message.setType(this.getMessage().getType());
        message.setLines(lines);
        InetSocketAddress addr = new InetSocketAddress(this.client.getInetAddress().getCanonicalHostName(), this.getMessage().getPort());
        this.sender.send(addr, message.toString());
        String msg = "ClientList (" + this.getRequest() + ") sent to " + addr;
        this.server.addToAccessLog(msg);
        this.server.println(msg);
    }

    @Override
    protected void initialize() throws Exception {
        String msg = "Request: " + this.getRequest();
        this.addToAccessLog(msg);
        if (this.server.getVerbose()) {
            this.server.println(msg);
        }
        if (this.server.getVerbose()) {
            this.server.println("Client-Port: " + this.getPort());
        }
    }

    @Override
    protected boolean process() throws Exception {
        boolean result;
        String request = this.getRequest();
        if (request.equals("nop") || request.equals("is_alive")) {
            result = true;
        } else if (request.equals("register")) {
            this.addClient();
            result = true;
        } else if (request.equals("unregister")) {
            this.removeClient();
            result = true;
        } else if (request.equals("reregister")) {
            this.reregisterClients();
            result = true;
        } else if (request.equals("shutdown")) {
            this.jobs.clear();
            this.getServer().sendKill();
            result = true;
        } else if (request.equals("add_jobs")) {
            this.addJobs();
            result = true;
        } else if (request.equals("job")) {
            String msg = "The server does not perform any Jobs!";
            this.addToErrorLog(msg);
            this.server.println(msg);
            result = false;
        } else if (request.equals("next_job")) {
            result = true;
        } else if (request.equals("delete_job")) {
            this.deleteJob();
            result = true;
        } else if (request.equals("result") || request.equals("failed")) {
            this.saveResult(request.equals("failed"));
            result = true;
        } else if (request.equals("jobs_todo") || request.equals("jobs_done") || request.equals("jobs_failed")) {
            this.sendJobList();
            result = true;
        } else if (request.equals("clients") || request.equals("pending") || request.equals("additional")) {
            this.sendClients();
            result = true;
        } else if (request.equals("get_file")) {
            String msg = "The server does not send any files!";
            this.addToErrorLog(msg);
            this.server.println(msg);
            result = false;
        } else if (request.equals("file")) {
            this.saveFile();
            result = true;
        } else if (request.equals("add_additional")) {
            this.additional.add(this.getClientAddress(), new JobMessage(this.getMessage()).getRun());
            result = true;
        } else if (request.equals("remove_additional") || request.equals("remove_failed")) {
            this.additional.remove(this.getClientAddress());
            result = true;
        } else {
            String msg = "The request '" + request + "' is unknown!";
            this.addToErrorLog(msg);
            this.server.println(msg);
            result = false;
        }
        return result;
    }
}

