/*
 * Decompiled with CFR 0.152.
 */
package proper.remote;

import java.io.File;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Vector;
import proper.app.Application;
import proper.io.TextFile;
import proper.remote.Job;
import proper.remote.JobClient;
import proper.remote.Processor;
import proper.remote.Server;
import proper.remote.messages.DataMessage;
import proper.remote.messages.FileMessage;
import proper.remote.messages.JobMessage;
import proper.util.Strings;

public class JobClientProcessor
extends Processor {
    public JobClientProcessor(Server server, Socket client) {
        super(server, client);
    }

    private JobClient getClient() {
        return (JobClient)this.server;
    }

    private String getLogFilename() {
        return String.valueOf(this.getClient().getOutput()) + "/result-" + this.getClient().getHostName() + "-" + this.getClient().getPort();
    }

    private String getJob() {
        return new JobMessage(this.getMessage()).getJobData();
    }

    private InetSocketAddress getServerAddress() {
        return new InetSocketAddress(this.getClient().getServerHostName(), this.getClient().getServerPort());
    }

    private void notifyAdditionalJob(String request) {
        this.notifyAdditionalJob(request, "");
    }

    private void notifyAdditionalJob(String request, String job) {
        JobMessage message = new JobMessage(this.createMessage(request));
        message.setJobData(";" + job);
        this.getClient().sendToJobServer(message);
    }

    private void runJob() {
        Job job = new Job(this.getJob());
        try {
            Application app = Application.createInstance(job.getClassName());
            if (this.server.getVerbose()) {
                this.server.println(job);
            } else {
                this.server.println("Processing job");
            }
            this.addToAccessLog(job.toString());
            boolean result = app.run(job.getParameter());
            this.server.println(" = " + result);
            Vector lines = TextFile.load(job.getLogFilename());
            String data = job + "\n";
            int i = 0;
            while (i < lines.size()) {
                data = String.valueOf(data) + (String)lines.get(i) + "\n";
                ++i;
            }
            data = String.valueOf(data) + " = " + result + "\n\n";
            String[] add = job.getAdditional();
            if (add != null) {
                InetSocketAddress addr = new InetSocketAddress(this.server.getHostName(), this.server.getPort());
                i = 0;
                while (i < add.length) {
                    String[] parts = new String[]{add[i].substring(0, add[i].indexOf(" ")), add[i].substring(add[i].indexOf(" ") + 1, add[i].length())};
                    JobMessage jobmsg = new JobMessage(this.createMessage(parts[0]));
                    jobmsg.setRun(parts[1]);
                    this.notifyAdditionalJob("add_additional", add[i]);
                    this.sender.send(addr, jobmsg.toString());
                    ++i;
                }
            }
            FileMessage filemsg = result ? new FileMessage(this.createMessage("result")) : new FileMessage(this.createMessage("failed"));
            filemsg.setLines(new StringReader(data));
            filemsg.setFilename(job.getLogFilename());
            this.sender.send(this.getServerAddress(), filemsg.toString());
        }
        catch (Throwable e) {
            this.server.println(e);
            boolean result = false;
            String data = job + " = " + result + "\nbecause of:\n" + e.getMessage() + "\n\n";
            this.addToErrorLog(job + " -> " + e.getMessage());
            FileMessage filemsg = new FileMessage(this.createMessage("failed"));
            filemsg.setLines(new StringReader(data));
            filemsg.setFilename(job.getLogFilename());
            this.sender.send(this.getServerAddress(), filemsg.toString());
        }
    }

    private void sendFile() {
        try {
            JobMessage jobmsg = new JobMessage(this.getMessage());
            String[] parts = Strings.breakUp(jobmsg.getRun(), " ", "\"");
            String filename = parts.length == 2 ? parts[1] : new File(parts[0]).getName();
            String data = "";
            Vector lines = TextFile.load(parts[0]);
            int i = 0;
            while (i < lines.size()) {
                data = String.valueOf(data) + (String)lines.get(i) + "\n";
                ++i;
            }
            FileMessage filemsg = new FileMessage(this.createMessage("file"));
            filemsg.setFilename(filename);
            filemsg.setLines(new StringReader(data));
            this.sender.send(this.getServerAddress(), filemsg.toString());
            String msg = "File '" + filename + "' sent to " + this.getServerAddress() + "!";
            this.addToAccessLog(msg);
            this.server.println(msg);
            this.notifyAdditionalJob("remove_additional");
        }
        catch (Exception e) {
            this.server.println(e);
            String data = String.valueOf(this.getRequest()) + "\nfailed because of:\n" + e.getMessage() + "\n\n";
            this.addToErrorLog(String.valueOf(this.getRequest()) + " -> " + e.getMessage());
            DataMessage datamsg = new DataMessage(this.createMessage("remove_failed"));
            datamsg.setLines(new StringReader(data));
            this.sender.send(this.getServerAddress(), datamsg.toString());
        }
    }

    private void saveFile() throws Exception {
        FileMessage message = new FileMessage(this.getMessage());
        TextFile.save(String.valueOf(this.getClient().getOutput()) + message.getFilename(), message.getLines());
        this.notifyAdditionalJob("remove_additional");
        InetSocketAddress addr = this.getServerAddress();
        String msg = "File '" + message.getFilename() + "' received from " + addr;
        this.addToAccessLog(msg);
        this.server.println(msg);
    }

    private void receivedShutdown() {
        String msg = "SHUTDOWN received!";
        this.addToAccessLog(msg);
        this.server.println("\n" + msg);
        this.getClient().setRunning(false);
    }

    private void receivedKill() {
        String msg = "KILL received!";
        this.addToAccessLog(msg);
        this.server.println("\n" + msg);
        this.getClient().setRunning(false);
        this.getClient().unregister();
        System.exit(0);
    }

    @Override
    protected void initialize() throws Exception {
    }

    @Override
    protected boolean process() throws Exception {
        boolean result;
        String request = this.getRequest();
        if (this.server.getVerbose()) {
            this.server.println("Request: " + request);
        }
        if (request.equals("nop") || request.equals("is_alive")) {
            result = true;
        } else if (request.equals("shutdown")) {
            this.receivedShutdown();
            result = true;
        } else if (request.equals("kill")) {
            this.receivedKill();
            result = true;
        } else if (request.equals("job")) {
            this.runJob();
            result = true;
        } else if (request.equals("get_file")) {
            this.sendFile();
            result = true;
        } else if (request.equals("file")) {
            this.saveFile();
            result = true;
        } else if (request.equals("reregister")) {
            this.getClient().register();
            result = true;
        } else {
            this.server.println("The request '" + request + "' is unknown!");
            result = false;
        }
        return result;
    }
}

