/*
 * Decompiled with CFR 0.152.
 */
package proper.relaggs;

import java.util.Hashtable;
import proper.relaggs.SqlEngine;

public class RelaggsAttribute
implements Comparable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_INT = 1;
    public static final int TYPE_BIGINT = 10;
    public static final int TYPE_REAL = 2;
    public static final int TYPE_CHAR = 3;
    public static final int TYPE_TEXT = 4;
    public static final int TYPE_DATE = 5;
    public static final int TYPE_DATETIME = 6;
    public static final int TYPE_TIME = 7;
    public static final int TYPE_ENUM = 8;
    public static final int TYPE_SET = 9;
    private String name;
    private String jdbc_type;
    private String type_name;
    private int type_size;
    private int type;
    private static Hashtable types = new Hashtable();

    static {
        types.put(Integer.toString(2003), new Integer(8));
        types.put(Integer.toString(-5), new Integer(1));
        types.put(Integer.toString(-2), new Integer(4));
        types.put(Integer.toString(-7), new Integer(1));
        types.put(Integer.toString(2004), new Integer(4));
        types.put(Integer.toString(16), new Integer(1));
        types.put(Integer.toString(1), new Integer(3));
        types.put(Integer.toString(2005), new Integer(4));
        types.put(Integer.toString(70), new Integer(0));
        types.put(Integer.toString(91), new Integer(5));
        types.put(Integer.toString(3), new Integer(2));
        types.put(Integer.toString(2001), new Integer(0));
        types.put(Integer.toString(8), new Integer(2));
        types.put(Integer.toString(6), new Integer(2));
        types.put(Integer.toString(4), new Integer(1));
        types.put(Integer.toString(2000), new Integer(0));
        types.put(Integer.toString(-4), new Integer(4));
        types.put(Integer.toString(-1), new Integer(4));
        types.put(Integer.toString(0), new Integer(0));
        types.put(Integer.toString(2), new Integer(2));
        types.put(Integer.toString(1111), new Integer(0));
        types.put(Integer.toString(7), new Integer(2));
        types.put(Integer.toString(2006), new Integer(0));
        types.put(Integer.toString(5), new Integer(1));
        types.put(Integer.toString(2002), new Integer(0));
        types.put(Integer.toString(92), new Integer(7));
        types.put(Integer.toString(93), new Integer(6));
        types.put(Integer.toString(-6), new Integer(1));
        types.put(Integer.toString(-3), new Integer(4));
        types.put(Integer.toString(12), new Integer(3));
    }

    public RelaggsAttribute(String name, String jdbc_type, String type_name, int type_size) {
        this.name = name;
        this.jdbc_type = jdbc_type;
        this.type_name = type_name;
        this.type_size = type_size;
    }

    public String getTypeName() {
        return this.type_name;
    }

    public String getTypeCreate() {
        String typeStr = SqlEngine.getTypeString(Integer.parseInt(this.jdbc_type), this.type_size);
        if (typeStr.equals("UNKNOWN")) {
            typeStr = this.type_name;
        }
        return typeStr;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        Object type = types.get(this.jdbc_type);
        if (type != null) {
            return (Integer)type;
        }
        return 0;
    }

    public String getAggregateFunctions(String table_name, String table_short_name, boolean is_primary_key) {
        String sql = "";
        if (is_primary_key) {
            sql = String.valueOf(sql) + "COUNT(" + table_name + "." + this.name + ") AS " + table_short_name + "_" + this.name + "_CNT_ALL, ";
        }
        switch (this.getType()) {
            case 1: 
            case 2: 
            case 10: {
                sql = String.valueOf(sql) + "COUNT(DISTINCT " + table_name + "." + this.name + ") AS " + table_short_name + "_" + this.name + "_CNT_VAL, ";
                sql = String.valueOf(sql) + "COALESCE(SUM(" + table_name + "." + this.name + "), " + "9999999" + ") AS " + table_short_name + "_" + this.name + "_SUM, ";
                sql = String.valueOf(sql) + "COALESCE(AVG(" + table_name + "." + this.name + "), " + "9999999" + ")  AS  " + table_short_name + "_" + this.name + "_AVG, ";
                sql = String.valueOf(sql) + "COALESCE(MIN(" + table_name + "." + this.name + "), " + "9999999" + ") AS " + table_short_name + "_" + this.name + "_MIN, ";
                sql = String.valueOf(sql) + "COALESCE(MAX(" + table_name + "." + this.name + "), " + "9999999" + ") AS " + table_short_name + "_" + this.name + "_MAX, ";
                sql = String.valueOf(sql) + "COALESCE(" + SqlEngine.getStddev(String.valueOf(table_name) + "." + this.name) + ", " + "9999999" + ") AS " + table_short_name + "_" + this.name + "_STDDEV";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                sql = String.valueOf(sql) + "COUNT(DISTINCT " + table_name + "." + this.name + ") AS  " + table_short_name + "_" + this.name + "_CNT_VAL";
            }
        }
        return sql;
    }

    public int compareTo(Object o) {
        if (o instanceof RelaggsAttribute) {
            return this.name.compareTo(((RelaggsAttribute)o).getName());
        }
        throw new ClassCastException();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelaggsAttribute) {
            return this.name.equals(((RelaggsAttribute)obj).getName());
        }
        return false;
    }
}

