/*
 * Decompiled with CFR 0.152.
 */
package proper.net;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import proper.core.ProperObject;

public class Data
extends ProperObject {
    private Exception lastException = null;
    private ServerSocket serverSocket = null;

    public boolean send(InetSocketAddress addr, String data) {
        return this.send(addr, data, false);
    }

    public boolean send(InetSocketAddress addr, String data, boolean silent) {
        boolean result = false;
        this.lastException = null;
        try {
            Socket socket = new Socket();
            socket.connect(addr);
            if (socket.isConnected()) {
                BufferedWriter output = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                output.write(data);
                output.flush();
                output.close();
                socket.close();
                if (this.getVerbose()) {
                    this.println("Data sent to " + addr + ":\n" + data);
                }
                result = true;
            } else {
                this.println("Data not sent to " + addr + "!");
                result = false;
            }
        }
        catch (Exception e) {
            if (!silent) {
                this.println(e);
            }
            this.lastException = e;
            result = false;
        }
        return result;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public String receive(int port) {
        return this.receive(port, 0);
    }

    public String receive(int port, int timeout) {
        String result = "";
        this.lastException = null;
        this.serverSocket = null;
        try {
            this.serverSocket = new ServerSocket(port);
            this.serverSocket.setSoTimeout(timeout);
            Socket client = this.serverSocket.accept();
            BufferedReader reader = new BufferedReader(new InputStreamReader(client.getInputStream()));
            while (!reader.ready()) {
            }
            while (reader.ready()) {
                result = String.valueOf(result) + reader.readLine() + "\n";
            }
            reader.close();
            client.close();
            this.serverSocket.close();
        }
        catch (Exception e) {
            if (e instanceof SocketTimeoutException) {
                try {
                    this.serverSocket.close();
                }
                catch (Exception exception) {}
            } else if (!(e instanceof SocketException) || !e.getMessage().startsWith("socket closed")) {
                this.println(e);
                this.lastException = e;
            }
            result = "";
        }
        return result;
    }

    public Exception getLastException() {
        return this.lastException;
    }
}

