/*
 * Decompiled with CFR 0.152.
 */
package proper.imp;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.StringTokenizer;
import proper.imp.Parser;

public class CSVParser
extends Parser {
    public static String FILE_PREDICATE = "_file";
    public static String IDENTIFIER_PREDICATE = "_identifier";
    private boolean firstLine;
    private boolean hasIdentifiers = true;
    private String identifiers;
    private String name = "predicate1";
    private int colCount;
    private char separator = (char)44;
    private char qualifier = (char)34;
    private boolean treatEmptyAsNull = true;

    public void setPredicateName(String name) {
        this.setPredicateName(name, true);
    }

    public void setPredicateName(String name, boolean lowercase) {
        this.name = lowercase ? name.toLowerCase() : name;
    }

    public String getPredicateName() {
        return this.name;
    }

    public void setHasIdentifiers(boolean hasIdentifiers) {
        this.hasIdentifiers = hasIdentifiers;
    }

    public boolean getHasIdentifiers() {
        return this.hasIdentifiers;
    }

    public void setSeparator(String separator) {
        if (separator.length() == 1) {
            this.setSeparator(separator.charAt(0));
        } else if (separator.equalsIgnoreCase("tab")) {
            this.setSeparator('\t');
        }
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setQualifier(String qualifier) {
        if (qualifier.length() == 1) {
            this.setQualifier(qualifier.charAt(0));
        }
    }

    public void setQualifier(char qualifier) {
        this.qualifier = qualifier;
    }

    public char getQualifier() {
        return this.qualifier;
    }

    public void setTreatEmptyAsNull(boolean treatEmptyAsNull) {
        this.treatEmptyAsNull = treatEmptyAsNull;
    }

    public boolean getTreatEmptyAsNull() {
        return this.treatEmptyAsNull;
    }

    private void addIdentifier(String identifier) {
        StringTokenizer tok = new StringTokenizer(identifier, "" + this.getSeparator());
        this.newPredicate(FILE_PREDICATE);
        this.add(this.getFilename());
        this.add(this.getPredicateName());
        this.newList();
        int i = 0;
        while (tok.hasMoreTokens()) {
            this.newPredicate(IDENTIFIER_PREDICATE);
            this.add(new Integer(i));
            this.add(tok.nextToken());
            this.removeCurrent();
            ++i;
        }
        this.removeCurrent();
        this.addPredicate();
    }

    private void determineColCount(String line) {
        if (this.colCount > -1) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(line, "" + this.getSeparator());
        this.colCount = tok.countTokens();
    }

    private String nextLine() throws Exception {
        String result = null;
        if (this.reader.ready()) {
            ++this.line;
            result = ((BufferedReader)this.reader).readLine();
        }
        return result;
    }

    @Override
    protected String nextClause() throws Exception {
        super.nextClause();
        if (this.firstLine && this.getHasIdentifiers()) {
            this.firstLine = false;
            this.identifiers = this.nextLine();
            this.determineColCount(this.identifiers);
        }
        String line = this.nextLine();
        this.determineColCount(line);
        return line;
    }

    private void newPredicate() {
        this.newPredicate(this.getPredicateName());
    }

    @Override
    protected Object process(Object o) {
        String str = o.toString();
        String strNew = "";
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) <= '\u007f' && str.charAt(i) >= ' ') {
                strNew = String.valueOf(strNew) + str.charAt(i);
            }
            ++i;
        }
        o = strNew;
        o = super.process(o);
        if (this.getTreatEmptyAsNull() && o.toString().trim().equals("")) {
            o = "NULL";
        }
        return o;
    }

    @Override
    protected void parseClause(String clause) {
        if (clause.equals("")) {
            return;
        }
        boolean isString = false;
        String str = "";
        this.current.clear();
        this.setIsNot(false);
        this.newPredicate();
        int i = 0;
        while (i < clause.length()) {
            char c = clause.charAt(i);
            boolean add = true;
            if (c == this.getQualifier()) {
                if (isString) {
                    str = str.replaceAll("" + this.getQualifier(), "");
                    if (this.getVerbose()) {
                        this.print(str);
                    }
                }
                isString = !isString;
                add = false;
            } else if (c == this.getSeparator() && !isString) {
                this.add(str, false);
                if (this.getVerbose()) {
                    this.print(String.valueOf(str) + this.getSeparator());
                }
                add = false;
                str = "";
            }
            if (add) {
                str = String.valueOf(str) + c;
            }
            ++i;
        }
        this.add(str);
        if (this.getVerbose()) {
            this.println(str);
        }
        while (this.getCurrent().size() < this.colCount) {
            this.add("");
        }
        while (this.getCurrent().size() > this.colCount) {
            this.getCurrent().remove(this.getCurrent().size() - 1);
        }
        this.addPredicate();
    }

    public void parse(BufferedReader reader) throws Exception {
        this.parse(reader);
    }

    @Override
    public void parse(Reader reader) throws Exception {
        this.firstLine = true;
        this.colCount = -1;
        super.parse(reader);
        if (this.getHasIdentifiers()) {
            this.addIdentifier(this.identifiers);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 0) {
            CSVParser s = new CSVParser();
            s.setVerbose(true);
            s.parse(args[0]);
            System.out.println(s);
        }
    }
}

