/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.remote;

import java.io.StringReader;
import proper.gui.remote.JobMonitor;
import proper.net.Data;
import proper.remote.messages.DataMessage;

class JobListener
extends Thread {
    private JobMonitor owner;
    private int port;
    private Data data;
    private boolean active;

    public JobListener(JobMonitor owner, int port) {
        this.owner = owner;
        this.port = port;
        this.data = new Data();
        this.active = true;
        this.start();
    }

    public void setActive(boolean active) {
        this.active = active;
        if (!active) {
            try {
                this.data.getServerSocket().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean getActive() {
        return this.active;
    }

    @Override
    public void run() {
        this.owner.println("List-Listener started.");
        while (this.getActive()) {
            String line = this.data.receive(this.port, 1000);
            if (this.getActive()) {
                if (line.equals("")) continue;
                if (this.data.getLastException() == null) {
                    if (line.equals("")) {
                        this.owner.setData(new DataMessage());
                        continue;
                    }
                    this.owner.setData(new DataMessage(new StringReader(line)));
                    continue;
                }
                this.owner.setServerIsAlive(false);
                continue;
            }
            this.owner.println("List-Listener shut down.");
        }
    }
}

