/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.help;

import java.util.Vector;
import javax.swing.event.HyperlinkEvent;
import proper.util.ProperVector;

class History {
    private Vector links = new ProperVector();
    private HyperlinkEvent current = null;
    private boolean verbose = false;

    public History(HyperlinkEvent start) {
        this.add(start);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void add(HyperlinkEvent link) {
        if (link == null) {
            return;
        }
        if (this.getLink(this.getCurrentIndex() + 1) != null && !this.getLink(this.getCurrentIndex() + 1).equals(link)) {
            while (this.links.size() - 1 > this.links.indexOf(this.current)) {
                this.links.remove(this.links.size() - 1);
            }
        }
        if (this.links.indexOf(link) == -1) {
            this.links.add(link);
        }
        this.current = link;
    }

    private HyperlinkEvent getLink(int index) {
        if (index >= 0 && index < this.links.size()) {
            return (HyperlinkEvent)this.links.get(index);
        }
        return null;
    }

    public HyperlinkEvent getCurrent() {
        return this.current;
    }

    private int getCurrentIndex() {
        return this.links.indexOf(this.current);
    }

    public HyperlinkEvent goBack() {
        if (this.canGoBack()) {
            this.current = this.getLink(this.links.indexOf(this.current) - 1);
        }
        return this.getCurrent();
    }

    public HyperlinkEvent goForward() {
        if (this.canGoForward()) {
            this.current = this.getLink(this.links.indexOf(this.current) + 1);
        }
        return this.getCurrent();
    }

    public HyperlinkEvent goHome() {
        this.current = this.getLink(0);
        return this.getCurrent();
    }

    public boolean canGoBack() {
        return this.links.indexOf(this.current) >= 1;
    }

    public boolean canGoForward() {
        return this.links.indexOf(this.current) < this.links.size() - 1;
    }

    public String toString() {
        String result = "Current: " + this.getCurrent().getURL() + " (" + this.links.indexOf(this.current) + ")\n";
        int i = 0;
        while (i < this.links.size()) {
            result = String.valueOf(result) + i + ". " + this.getLink(i).getURL() + "\n";
            ++i;
        }
        return result;
    }
}

