/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import proper.gui.core.frame.ApplicationFrame;
import proper.gui.core.frame.ChildFrame;
import proper.gui.core.io.ImageLoader;
import proper.gui.help.History;

public class Help
extends ChildFrame
implements HyperlinkListener {
    public static final String INDEX = "index.html";
    private static final String ACTION_BACK = "back";
    private static final String ACTION_FORWARD = "forward";
    private static final String ACTION_HOME = "home";
    private JEditorPane editorHtml;
    private JScrollPane paneHtml;
    private JPanel panelButtons;
    private JButton buttonBack;
    private JButton buttonForward;
    private JButton buttonHome;
    private String filename;
    private History history;

    public Help(ApplicationFrame parent) {
        super(parent, "Help...");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.filename = "doc/index.html";
        this.history = null;
    }

    @Override
    protected void createFrame() {
        super.createFrame();
        this.getContentPane().setLayout(new BorderLayout());
        this.setConfirmExit(false);
        this.buttonBack = new JButton("Back", ImageLoader.getImageIcon("back.gif"));
        this.buttonBack.setActionCommand(ACTION_BACK);
        this.buttonBack.addActionListener(this);
        this.buttonForward = new JButton("Forward", ImageLoader.getImageIcon("forward.gif"));
        this.buttonForward.setActionCommand(ACTION_FORWARD);
        this.buttonForward.addActionListener(this);
        this.buttonHome = new JButton("Home", ImageLoader.getImageIcon("home.gif"));
        this.buttonHome.setActionCommand(ACTION_HOME);
        this.buttonHome.addActionListener(this);
        this.panelButtons = new JPanel(new FlowLayout());
        this.panelButtons.add(this.buttonBack);
        this.panelButtons.add(this.buttonForward);
        this.panelButtons.add(this.buttonHome);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.panelButtons, "West");
        this.getContentPane().add((Component)panel, "North");
        this.editorHtml = new JEditorPane();
        this.editorHtml.setEditable(false);
        this.editorHtml.addHyperlinkListener(this);
        this.paneHtml = new JScrollPane(this.editorHtml);
        this.getContentPane().add((Component)this.paneHtml, "Center");
    }

    @Override
    protected boolean afterCreate() {
        this.filename = this.cl.getValue("file", this.filename);
        HyperlinkEvent e = new HyperlinkEvent(this.editorHtml, HyperlinkEvent.EventType.ACTIVATED, this.createURL(this.filename), "");
        this.processLink(e, true);
        return true;
    }

    private String processResource(HyperlinkEvent e) {
        String resource = e.getURL().toString();
        if (resource.endsWith("/")) {
            resource = String.valueOf(resource) + INDEX;
        }
        return resource;
    }

    private URL createURL(String resource) {
        URL result = null;
        try {
            result = new URL(resource);
        }
        catch (Exception e) {
            result = null;
        }
        if (result == null) {
            try {
                result = new File(resource).toURL();
            }
            catch (Exception e) {
                this.println(e);
                result = null;
            }
        }
        return result;
    }

    private void showPage(HyperlinkEvent event) {
        this.showPage(event.getURL());
    }

    private void showPage(URL url) {
        try {
            this.editorHtml.setPage(url);
        }
        catch (Exception ex) {
            this.println(ex);
        }
    }

    private void goBack() {
        if (!this.history.canGoBack()) {
            return;
        }
        HyperlinkEvent target = this.history.goBack();
        if (target instanceof HTMLFrameHyperlinkEvent) {
            HyperlinkEvent current = target;
            while (current instanceof HTMLFrameHyperlinkEvent) {
                current = this.history.goBack();
            }
            while (!current.equals(target)) {
                this.goForward();
                current = this.history.getCurrent();
            }
        }
        this.processLink(target, false);
    }

    private void goForward() {
        if (this.history.canGoForward()) {
            this.processLink(this.history.goForward(), false);
        }
    }

    private void goHome() {
        this.processLink(this.history.goHome(), false);
    }

    private void processLink(HyperlinkEvent e, boolean add) {
        String resource = this.processResource(e);
        if (!resource.equals(e.getURL().toString())) {
            e = new HyperlinkEvent(e.getSource(), e.getEventType(), this.createURL(resource), e.getDescription());
        }
        if (e instanceof HTMLFrameHyperlinkEvent) {
            JEditorPane pane = (JEditorPane)e.getSource();
            HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
            HTMLDocument doc = (HTMLDocument)pane.getDocument();
            doc.processHTMLFrameHyperlinkEvent(evt);
        } else {
            this.showPage(e);
        }
        if (add) {
            if (this.history == null) {
                this.history = new History(e);
                if (this.getVerbose()) {
                    this.history.setVerbose(this.getVerbose());
                }
            } else {
                this.history.add(e);
            }
        }
        if (this.getVerbose()) {
            System.out.println(this.history);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (e instanceof HTMLFrameHyperlinkEvent) {
                JEditorPane pane = (JEditorPane)e.getSource();
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
                this.history.add(e);
            } else {
                this.processLink(e, true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(ACTION_BACK)) {
            this.goBack();
        } else if (action.equals(ACTION_FORWARD)) {
            this.goForward();
        } else if (action.equals(ACTION_HOME)) {
            this.goHome();
        }
    }

    @Override
    public void printDescription() {
        System.out.println("Displays the help index for Proper.");
        System.out.println();
    }

    @Override
    public void printUsage() {
        super.printUsage();
        System.out.println(" -file <filename> (optional)");
        System.out.println("  the file to use as initial HTML file");
    }

    public static void main(String[] args) throws Exception {
        Help frame = new Help(null);
        frame.run(args);
    }
}

