/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.table;

import java.util.HashSet;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class PropertyTableModel
implements TableModel {
    private HashSet listeners = new HashSet();
    private Object[][] properties;
    private boolean changed;

    public PropertyTableModel(Object[][] properties) {
        this.properties = properties;
        this.changed = false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            try {
                return String.class;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result;
        switch (columnIndex) {
            case 0: {
                result = "Property";
                break;
            }
            case 1: {
                result = "Value";
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        return this.properties.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        if (columnIndex >= 0 && columnIndex < this.getColumnCount() && rowIndex >= 0 && rowIndex < this.getRowCount()) {
            result = this.properties[rowIndex][columnIndex];
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            this.changed = true;
            this.properties[rowIndex][columnIndex] = aValue;
            this.notifyListener(rowIndex, columnIndex);
        }
    }

    private void notifyListener(int rowIndex, int columnIndex) {
        if (this.listeners.size() > 0) {
            for (TableModelListener l : this.listeners) {
                l.tableChanged(new TableModelEvent(this, rowIndex, columnIndex));
            }
        }
    }
}

