/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.table;

import java.util.HashSet;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import proper.io.TextFile;
import proper.util.Matcher;
import proper.util.ProperVector;
import proper.util.Strings;

public class LoggerTableModel
implements TableModel {
    private HashSet listeners = new HashSet();
    private Vector data = new ProperVector();
    private Vector displayData = new ProperVector();
    private int colCount = 2;
    private String[] colName = new String[]{"Line", "Entry"};

    public LoggerTableModel(String filename) {
        if (filename != null) {
            this.analyze(TextFile.load(filename));
        }
    }

    private void analyze(Vector lines) {
        if (lines.size() == 0) {
            return;
        }
        String line = (String)lines.get(0);
        while (line.indexOf("[") > -1) {
            ++this.colCount;
            String lineOld = line;
            if ((line = lineOld.substring(lineOld.indexOf("]") + 1, lineOld.length())).equals(lineOld)) break;
        }
        if (this.colCount > 4) {
            this.colCount = 2;
        }
        switch (this.colCount) {
            case 3: {
                this.colName = new String[]{"Line", "Timestamp", "Entry"};
                break;
            }
            case 4: {
                this.colName = new String[]{"Line", "Timestamp", "Host", "Entry"};
                break;
            }
            default: {
                this.colName = new String[]{"Line", "Entry"};
            }
        }
        int i = 0;
        while (i < lines.size()) {
            line = ((String)lines.get(i)).trim();
            ProperVector lineData = new ProperVector();
            this.data.add(lineData);
            lineData.add(new Integer(i + 1));
            if (this.colCount > 2) {
                lineData.add(line.substring(1, line.indexOf("]")));
                line = line.substring(line.indexOf("]") + 1, line.length()).trim();
            }
            if (this.colCount > 3) {
                lineData.add(line.substring(1, line.indexOf("]")));
                line = line.substring(line.indexOf("]") + 1, line.length()).trim();
            }
            lineData.add(line);
            ++i;
        }
        this.displayData.addAll(this.data);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Integer.class;
        }
        if (columnIndex > 0 && columnIndex < this.getColumnCount()) {
            try {
                return String.class;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.colCount;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.colName[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.displayData.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result = null;
        if (rowIndex >= 0 && rowIndex < this.getRowCount() && columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            result = ((Vector)this.displayData.get(rowIndex)).get(columnIndex);
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    private void notifyListener(int rowIndex, int columnIndex) {
        if (this.listeners.size() > 0) {
            for (TableModelListener l : this.listeners) {
                l.tableChanged(new TableModelEvent(this, rowIndex, columnIndex));
            }
        }
    }

    public void filter(String searchString) {
        this.filter(searchString, false);
    }

    public void filter(String searchString, boolean casesensitive) {
        this.filter(searchString, casesensitive, -1);
    }

    public void filter(String searchString, int col) {
        this.filter(searchString, false, -1);
    }

    public void filter(String searchString, boolean casesensitive, int col) {
        int to;
        int from;
        this.displayData.clear();
        if (!casesensitive) {
            searchString = searchString.toLowerCase();
        }
        String[] search = Strings.breakUp(searchString, " ", "\"");
        if (col == -1) {
            from = 1;
            to = this.colCount - 1;
        } else {
            from = col;
            to = col;
        }
        int i = 0;
        while (i < this.data.size()) {
            int n = to;
            while (n >= from) {
                String line = (String)((Vector)this.data.get(i)).get(n);
                if (!casesensitive) {
                    line = line.toLowerCase();
                }
                if (Matcher.matches(line, search, true)) {
                    this.displayData.add(this.data.get(i));
                    break;
                }
                --n;
            }
            ++i;
        }
        if (this.listeners.size() > 0) {
            for (TableModelListener l : this.listeners) {
                l.tableChanged(new TableModelEvent(this));
            }
        }
    }

    public Vector getEntries(int[] indices) {
        ProperVector result = new ProperVector();
        int i = 0;
        while (i < indices.length) {
            result.add(this.getValueAt(indices[i], this.getColumnCount() - 1));
            ++i;
        }
        return result;
    }

    public int getLineNumber(int index) {
        int result = -1;
        Integer line = (Integer)this.getValueAt(index, 0);
        if (line != null) {
            result = line;
        }
        return result;
    }

    public int getIndex(int line) {
        int result = -1;
        Integer lineNo = new Integer(line);
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.getValueAt(i, 0).equals(lineNo)) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }
}

