/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.list;

import javax.swing.JList;
import proper.util.Matcher;
import proper.util.ProperVector;
import proper.util.Strings;

public class JListHelper {
    private JList jlist;

    public JListHelper(JList jlist) {
        this.jlist = jlist;
    }

    public JList getJList() {
        return this.jlist;
    }

    public static String[] toStringArray(Object[] array) {
        String[] result = new String[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i].toString();
            ++i;
        }
        return result;
    }

    public Object[] getListData() {
        return JListHelper.getListData(this.getJList());
    }

    public static Object[] getListData(JList jlist) {
        Object[] result = jlist.getSelectedValues();
        if (result.length == 0) {
            result = JListHelper.getAllListData(jlist);
        }
        return result;
    }

    public Object[] getAllListData() {
        return JListHelper.getAllListData(this.getJList());
    }

    public static Object[] getAllListData(JList jlist) {
        Object[] result = new Object[jlist.getModel().getSize()];
        int i = 0;
        while (i < result.length) {
            result[i] = jlist.getModel().getElementAt(i);
            ++i;
        }
        return result;
    }

    public int[] invertIndices(int[] indices) {
        return JListHelper.invertIndices(this.getJList(), indices);
    }

    public static int[] invertIndices(JList jlist, int[] indices) {
        int[] result = new int[jlist.getModel().getSize() - indices.length];
        int m = 0;
        int n = 0;
        int i = 0;
        while (i < jlist.getModel().getSize()) {
            if (m < indices.length && indices[m] == i) {
                ++m;
            } else {
                result[n] = i;
                ++n;
            }
            ++i;
        }
        return result;
    }

    public int[] getInverseSelectedIndices() {
        return JListHelper.getInverseSelectedIndices(this.getJList());
    }

    public static int[] getInverseSelectedIndices(JList jlist) {
        return JListHelper.invertIndices(jlist, jlist.getSelectedIndices());
    }

    public Object[] getInverseSelectedValues() {
        return JListHelper.getInverseSelectedValues(this.getJList());
    }

    public static Object[] getInverseSelectedValues(JList jlist) {
        int[] indices = JListHelper.getInverseSelectedIndices(jlist);
        ProperVector lines = new ProperVector();
        int i = 0;
        while (i < indices.length) {
            lines.add(jlist.getModel().getElementAt(indices[i]));
            ++i;
        }
        Object[] result = new Object[lines.size()];
        i = 0;
        while (i < lines.size()) {
            result[i] = lines.get(i);
            ++i;
        }
        return result;
    }

    public int[] getMatches(String searchString) {
        return JListHelper.getMatches(this.getJList(), searchString);
    }

    public static int[] getMatches(JList jlist, String searchString) {
        if (searchString.equals("")) {
            int[] result = new int[]{};
            return result;
        }
        String[] search = Strings.breakUp(searchString, " ", "\"");
        ProperVector indices = new ProperVector();
        int i = 0;
        while (i < jlist.getModel().getSize()) {
            if (Matcher.matches(jlist.getModel().getElementAt(i).toString(), search, true)) {
                indices.add(new Integer(i));
            }
            ++i;
        }
        int[] result = new int[indices.size()];
        i = 0;
        while (i < indices.size()) {
            result[i] = (Integer)indices.get(i);
            ++i;
        }
        return result;
    }
}

