/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.dialog;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import proper.gui.core.dialog.ProperDialog;
import proper.gui.core.frame.ApplicationFrame;
import proper.gui.core.frame.DummyFrame;
import proper.gui.core.frame.ProperFrame;
import proper.gui.core.io.ImageLoader;

public class MessageBox
extends ProperDialog {
    JLabel label;
    String[] buttons;
    String icon;
    String text;
    int pressed;
    public static final String ICON_INFORMATION = "information.gif";
    public static final String ICON_QUESTION = "question.gif";
    public static final String ICON_ERROR = "error.gif";
    public static final String[] BUTTONS_YESNO = new String[]{"Yes", "No"};
    public static final String[] BUTTONS_YESNOCANCEL = new String[]{"Yes", "No", "Cancel"};
    public static final String[] BUTTONS_OK = new String[]{"OK"};
    public static final String[] BUTTONS_OKCANCEL = new String[]{"OK", "Cancel"};

    public MessageBox(String title, String text, String[] buttons, String icon) {
        this(new DummyFrame(), title, text, buttons, icon);
    }

    public MessageBox(ProperFrame parent, String title, String text, String[] buttons, String icon) {
        this(parent, title, text, buttons, icon, 300, 100);
    }

    public MessageBox(String title, String text, String[] buttons, String icon, int width, int height) {
        this(new DummyFrame(), title, text, buttons, icon, width, height);
    }

    public MessageBox(ProperFrame parent, String title, String text, String[] buttons, String icon, int width, int height) {
        super(parent, title);
        this.buttons = buttons;
        this.width = width;
        this.height = height;
        this.icon = icon;
        this.text = text;
        this.initialize();
        this.createDialog();
    }

    @Override
    protected void createDialog() {
        super.createDialog();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constr = new GridBagConstraints();
        this.getContentPane().setLayout(gridbag);
        constr.fill = 0;
        constr.gridx = 0;
        constr.gridy = 0;
        this.label = new JLabel(this.text, ImageLoader.getImageIcon(this.icon), 0);
        this.label.setIconTextGap(20);
        gridbag.setConstraints(this.label, constr);
        this.getContentPane().add(this.label);
        JPanel panel = new JPanel();
        GridBagLayout gridbagPanel = new GridBagLayout();
        GridBagConstraints constrPanel = new GridBagConstraints();
        panel.setLayout(gridbagPanel);
        constr.fill = 0;
        constr.gridx = 0;
        constr.gridy = 1;
        int i = 0;
        while (i < this.buttons.length) {
            this.createButton(panel, this.buttons[i], gridbagPanel, constrPanel);
            ++i;
        }
        gridbag.setConstraints(panel, constr);
        this.getContentPane().add(panel);
        this.resizeDialog();
        this.setCenteredLocation();
    }

    private void createButton(JPanel panel, String caption, GridBagLayout gridbag, GridBagConstraints constr) {
        JButton button = new JButton(caption);
        button.setActionCommand(caption);
        button.addActionListener(this);
        gridbag.setConstraints(button, constr);
        panel.add(button);
    }

    public int getPressedButton() {
        return this.pressed;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        int i = 0;
        while (i < this.buttons.length) {
            if (this.buttons[i].equals(action)) {
                this.pressed = i;
                break;
            }
            ++i;
        }
        if (this.pressed > -1) {
            this.close();
        }
    }

    @Override
    public void show() {
        this.pressed = -1;
        super.show();
    }

    public static void main(String[] args) throws Exception {
        ApplicationFrame frame = new ApplicationFrame("Title");
        MessageBox box = new MessageBox(frame, "Quit", "<html>Do you really, really, really want to quit?<br>Or perhaps not?</html>", BUTTONS_YESNOCANCEL, ICON_ERROR, 300, 100);
        frame.setVisible(true);
        box.show();
        System.out.println("Button-Index: " + box.getPressedButton());
    }
}

