/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.core.dialog;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import proper.database.Connector;
import proper.gui.core.dialog.ProperDialog;
import proper.gui.core.event.ConnectorChangeListener;
import proper.gui.core.frame.ProperFrame;
import proper.gui.core.panel.ColumnChooserPanel;
import proper.gui.core.panel.DataBaseChooserPanel;
import proper.gui.core.panel.OkCancelPanel;
import proper.gui.core.panel.ProperPanel;
import proper.gui.core.panel.TableChooserPanel;
import proper.gui.experiment.Builder;

public class DataBaseConnectDialog
extends ProperDialog
implements ActionListener {
    private int type = 0;
    private ProperPanel guiChooserPanel;
    private OkCancelPanel okCancelP;
    private Connector conn;
    private boolean isValid = false;

    public DataBaseConnectDialog(ProperFrame parent) {
        super(parent, "Choose Database...");
        this.type = 1;
        this.conn = ((Builder)this.getParentFrame()).getConnector();
        this.createDialogPanel();
    }

    public DataBaseConnectDialog(ProperFrame parent, String dialogname) {
        super(parent, dialogname);
        this.conn = ((Builder)this.getParentFrame()).getConnector();
        this.notifyDialogType(dialogname);
        this.createDialogPanel();
    }

    public void createDialogPanel() {
        super.createDialog();
        if (this.type == 1) {
            this.okCancelP = new OkCancelPanel();
            JPanel p = new JPanel(new FlowLayout(2));
            p.add(this.okCancelP);
            this.getContentPane().add((Component)p, "South");
            this.guiChooserPanel = new DataBaseChooserPanel(this, this.conn);
            this.getContentPane().add((Component)this.guiChooserPanel, "Center");
        } else if (this.type == 2) {
            this.okCancelP = new OkCancelPanel();
            JPanel p = new JPanel(new FlowLayout(2));
            p.add(this.okCancelP);
            this.getContentPane().add((Component)p, "South");
            this.guiChooserPanel = new TableChooserPanel(this, this.conn);
            this.getContentPane().add((Component)this.guiChooserPanel, "Center");
        } else if (this.type == 3) {
            this.okCancelP = new OkCancelPanel();
            JPanel p = new JPanel(new FlowLayout(2));
            p.add(this.okCancelP);
            this.getContentPane().add((Component)p, "South");
            this.guiChooserPanel = new ColumnChooserPanel(this, ((Builder)this.getParentFrame()).getConnector());
            this.getContentPane().add((Component)this.guiChooserPanel, "Center");
        }
        this.okCancelP.buttonCancel.addActionListener(this);
        this.okCancelP.buttonOK.addActionListener(this);
        this.okCancelP.buttonOK.setEnabled(false);
    }

    public void notifyDialogType(String dialogname) {
        if (dialogname.equals("Choose Table...")) {
            this.type = 2;
            this.setTitle(dialogname);
        } else if (dialogname.equals("Choose Column...")) {
            this.type = 3;
            this.setTitle(dialogname);
        } else {
            this.type = 1;
            this.setTitle("Choose Database...");
        }
    }

    public boolean isValidate() {
        return this.isValid;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okCancelP.buttonOK) {
            this.isValid = true;
            this.close();
        } else {
            this.isValid = false;
            this.close();
        }
        System.out.println(this.isValidate());
    }

    public void changeOkButtonStatus(boolean b) {
        this.okCancelP.buttonOK.setEnabled(b);
    }

    public Connector getConnector() {
        return this.conn;
    }

    public void setConnector(Connector co) {
        this.conn = co;
    }

    public String getDriver() {
        return this.conn.getDriver();
    }

    public String getUrl() {
        return this.conn.getUrl();
    }

    public String getUser() {
        return this.conn.getUser();
    }

    public String getPassword() {
        return this.conn.getPassword();
    }

    public String getDatabase() {
        return this.conn.getDatabase();
    }

    public String getTable() {
        return this.conn.getTable();
    }

    public String getColumn() {
        return this.conn.getColumn();
    }

    public void removeConnectorChangeListener(ConnectorChangeListener listener) {
    }

    public void addConnectorChangeListener(ConnectorChangeListener listener) {
    }
}

