/*
 * Decompiled with CFR 0.152.
 */
package proper.engine;

import java.util.Vector;
import proper.database.Dropper;
import proper.database.Join;
import proper.database.JoinTreeNode;
import proper.database.RelationDiscoverer;
import proper.database.Table;
import proper.database.TableLister;
import proper.engine.Cardinalizer;
import proper.engine.DatabaseEngine;
import proper.engine.Relaggs;

public class Recursive
extends DatabaseEngine {
    private TableLister tabLister;
    private RelationDiscoverer discoverer;
    private Dropper dropper;
    private static final String resultTable = "_recursed";
    private static int tmpTableNumber;

    private void init() {
        this.tabLister = new TableLister(this.conn);
        this.tabLister.setSort(true);
        this.dropper = new Dropper(this.conn);
        this.discoverer = new RelationDiscoverer(this.conn);
        this.discoverer.setExcludes(this.getStringParameter("exclude_tables"));
        this.discoverer.setTable(this.getStringParameter("table"));
        this.discoverer.setMaxDepth(Integer.parseInt(this.getStringParameter("max_depth")));
        this.discoverer.setUseForeignKeys(this.exists("use_foreing_keys"));
        tmpTableNumber = 0;
    }

    private void dropTables(boolean onlyTemp) {
        Vector tables = this.tabLister.getList("_recursed_tmp_%");
        if (!onlyTemp) {
            tables.add(this.getStringParameter("result_table"));
        }
        this.dropper.drop(tables);
    }

    private JoinTreeNode buildNewTree(JoinTreeNode base) {
        JoinTreeNode tree = null;
        if (base.getTable() == null) {
            tree = new JoinTreeNode(new Table(base.getJoin().getLeftTable(), base.getJoin().getSize()));
            int i = 0;
            while (i < base.getChildCount()) {
                JoinTreeNode child = (JoinTreeNode)base.getChildAt(i);
                tree.add((JoinTreeNode)child.clone());
                ++i;
            }
        } else {
            tree = base;
        }
        return tree;
    }

    private boolean dig(JoinTreeNode root) {
        boolean result = true;
        int i = 0;
        while (i < root.getChildCount()) {
            JoinTreeNode node = (JoinTreeNode)root.getChildAt(i);
            if (node.getChildCount() > 0) {
                result = this.dig(node);
                if (!result) break;
                if (this.getStringParameter("depth-engine").equals("Relaggs")) {
                    result = this.relaggs(node, "_recursed_tmp_" + tmpTableNumber);
                    ++tmpTableNumber;
                } else if (this.getStringParameter("depth-engine").equals("Cardinalization")) {
                    result = this.cardinalize(node, "_recursed_tmp_" + tmpTableNumber);
                    ++tmpTableNumber;
                }
                node.removeAllChildren();
            }
            ++i;
        }
        return result;
    }

    private boolean relaggs(JoinTreeNode root, String resultTableName) {
        JoinTreeNode tree = this.buildNewTree(root);
        Relaggs relaggs = new Relaggs();
        this.addListener(relaggs);
        relaggs.setParameter("driver", this.getParameter("driver"));
        relaggs.setParameter("url", this.getParameter("url"));
        relaggs.setParameter("database", this.getParameter("database"));
        relaggs.setParameter("user", this.getParameter("user"));
        relaggs.setParameter("password", this.getParameter("password"));
        relaggs.setParameter("table", root.toString());
        relaggs.setParameter("field", "");
        relaggs.setParameter("join", this.getParameter("join"));
        relaggs.setParameter("result_table", resultTableName);
        relaggs.setParameter("exclude_tables", this.getParameter("exclude_tables"));
        relaggs.setParameter("max_depth", "-1");
        relaggs.setParameter("tree", tree.toTreeString(true));
        relaggs.setParameter("instead_null", this.getParameter("instead_null"));
        if (this.exists("any_index")) {
            relaggs.setParameter("any_index", this.getStringParameter("any_index"));
        }
        if (this.exists("use_foreign_keys")) {
            relaggs.setParameter("use_foreign_keys", this.getStringParameter("use_foreign_key"));
        }
        boolean result = relaggs.execute();
        if (root.getJoin() != null) {
            Join oldJoin = root.getJoin();
            root.getJoin().assign(new Join(resultTableName, oldJoin.getLeftColumn(), oldJoin.getSize(), oldJoin.getRightTable(), oldJoin.getRightColumn()));
        }
        return result;
    }

    private boolean cardinalize(JoinTreeNode root, String resultTableName) {
        JoinTreeNode tree = this.buildNewTree(root);
        Cardinalizer cardz = new Cardinalizer();
        this.addListener(cardz);
        cardz.setParameter("driver", this.getParameter("driver"));
        cardz.setParameter("url", this.getParameter("url"));
        cardz.setParameter("database", this.getParameter("database"));
        cardz.setParameter("user", this.getParameter("user"));
        cardz.setParameter("password", this.getParameter("password"));
        cardz.setParameter("table", root.toString());
        cardz.setParameter("field", "");
        cardz.setParameter("join", this.getParameter("join"));
        cardz.setParameter("result_table", resultTableName);
        cardz.setParameter("exclude_tables", this.getParameter("exclude_tables"));
        cardz.setParameter("max_depth", "-1");
        cardz.setParameter("tree", tree.toTreeString(true));
        cardz.setParameter("instead_null", this.getParameter("instead_null"));
        if (this.exists("any_index")) {
            cardz.setParameter("any_index", this.getParameter("any_index"));
        }
        if (this.exists("use_foreign_keys")) {
            cardz.setParameter("use_foreign_keys", this.getParameter("use_foreign_key"));
        }
        if (this.exists("discretize")) {
            cardz.setParameter("discretize", this.getParameter("discretize"));
            if (this.exists("discretize-parts")) {
                cardz.setParameter("discretize-parts", this.getParameter("discretize-parts"));
            }
        }
        boolean result = cardz.execute();
        if (root.getJoin() != null) {
            Join oldJoin = root.getJoin();
            root.getJoin().assign(new Join(resultTableName, oldJoin.getLeftColumn(), oldJoin.getSize(), oldJoin.getRightTable(), oldJoin.getRightColumn()));
        }
        return result;
    }

    @Override
    public boolean execute() {
        super.execute();
        this.init();
        this.dropTables(false);
        boolean result = false;
        JoinTreeNode root = !this.getStringParameter("tree").equals("") ? JoinTreeNode.parseTreeString(this.getStringParameter("tree")) : this.discoverer.discover();
        this.println("\nRelations :\n");
        this.println(root.toString(true));
        this.println("Left over tables: " + this.discoverer.leftOverTables(root));
        result = this.dig(root);
        if (this.getStringParameter("final-engine").equals("Relaggs") && result) {
            result = this.relaggs(root, this.getStringParameter("result_table"));
        } else if (this.getStringParameter("final-engine").equals("Cardinalization") && result) {
            result = this.cardinalize(root, this.getStringParameter("result_table"));
        }
        this.dropTables(true);
        return result;
    }
}

