/*
 * Decompiled with CFR 0.152.
 */
package proper.core;

import java.io.PrintStream;
import java.util.Vector;
import proper.core.ProperInterface;
import proper.io.Tee;
import proper.util.ProperVector;
import proper.util.Strings;

public abstract class ProperObject
implements ProperInterface {
    private int verboseLevel = 0;
    private Tee tee;
    private Vector listeners = new ProperVector();
    protected String verboseStr = "";
    private Runtime runtime;

    public ProperObject() {
        this.tee = new Tee();
        this.runtime = Runtime.getRuntime();
    }

    @Override
    public void addListener(ProperInterface o) {
        if (!this.listeners.contains(o)) {
            this.listeners.add(o);
            this.notifyListener(o);
        }
    }

    @Override
    public void removeListener(ProperInterface o) {
        if (this.listeners.contains(o)) {
            this.listeners.remove(this.listeners.indexOf(o));
        }
    }

    @Override
    public Vector getListeners() {
        return this.listeners;
    }

    @Override
    public void notifyListener(ProperInterface o) {
        o.setVerboseString(this.getVerboseString());
        int i = 0;
        while (i < this.tee.size()) {
            o.addOutput(this.tee.get(i));
            ++i;
        }
    }

    @Override
    public void notifyListeners() {
        int i = 0;
        while (i < this.getListeners().size()) {
            this.notifyListener((ProperInterface)this.getListeners().get(i));
            ++i;
        }
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verboseLevel = verbose ? 1 : 0;
    }

    @Override
    public boolean getVerbose() {
        return this.getVerboseLevel() > 0;
    }

    @Override
    public void setVerboseLevel(int verboseLevel) {
        if (verboseLevel >= 0) {
            this.verboseLevel = verboseLevel;
        }
    }

    @Override
    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    @Override
    public void setOutput(PrintStream out) {
        this.tee.clear();
        this.addOutput(out);
    }

    @Override
    public void addOutput(PrintStream out) {
        this.tee.add(out);
        this.notifyListeners();
    }

    @Override
    public String getVerboseStringForClass(String classname) {
        String result = "";
        if (this.verboseStr != null) {
            String[] data = Strings.fromCommalist(this.verboseStr);
            int i = 0;
            while (i < data.length) {
                String tmp = data[i];
                if (tmp.indexOf(":") > -1) {
                    tmp = tmp.substring(0, data[i].indexOf(":"));
                }
                if (classname.endsWith("." + tmp) || tmp.equals(classname) || tmp.equals("all")) {
                    result = data[i];
                    break;
                }
                if (tmp.endsWith(".*") && classname.startsWith(tmp.substring(0, tmp.length() - 1))) {
                    result = data[i];
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public int getVerboseLevelForClass(String classname) {
        int result = 0;
        String verbose = this.getVerboseStringForClass(classname);
        if (!verbose.equals("")) {
            if (verbose.indexOf(":") > -1) {
                try {
                    result = Integer.parseInt(verbose.substring(verbose.indexOf(":") + 1, verbose.length()));
                }
                catch (Exception e) {
                    this.println(e);
                    result = 0;
                }
            } else {
                result = 1;
            }
        }
        return result;
    }

    @Override
    public boolean classInVerbose(String classname) {
        return !this.getVerboseStringForClass(classname).equals("");
    }

    @Override
    public void setVerboseString(String verboseStr) {
        this.verboseStr = verboseStr;
        this.setVerboseLevel(this.getVerboseLevelForClass(this.getClass().getName()));
        this.notifyListeners();
    }

    @Override
    public String getVerboseString() {
        return this.verboseStr;
    }

    @Override
    public Runtime getRuntime() {
        return this.runtime;
    }

    @Override
    public void printMemory() {
        double free = this.getRuntime().freeMemory();
        double freeM = (double)StrictMath.round(free / 1048576.0 * 10.0) / 10.0;
        double total = this.getRuntime().totalMemory();
        double totalM = (double)StrictMath.round(total / 1048576.0 * 10.0) / 10.0;
        this.println("Memory: " + freeM + "M (" + (long)free + ") / " + totalM + "M (" + (long)total + ")");
    }

    @Override
    public void print(int x) {
        this.tee.print(x);
    }

    @Override
    public void print(boolean x) {
        this.tee.print(x);
    }

    @Override
    public void print(String x) {
        this.tee.print(x);
    }

    @Override
    public void print(Object x) {
        this.tee.print(x);
    }

    @Override
    public void println() {
        this.tee.println();
    }

    @Override
    public void println(int x) {
        this.tee.println(x);
    }

    @Override
    public void println(boolean x) {
        this.tee.println(x);
    }

    @Override
    public void println(String x) {
        this.tee.println(x);
    }

    @Override
    public void println(Object x) {
        this.tee.println(x);
    }

    @Override
    public void debugprint(int x) {
        this.print(x);
    }

    @Override
    public void debugprint(boolean x) {
        this.print(x);
    }

    @Override
    public void debugprint(String x) {
        this.print(x);
    }

    @Override
    public void debugprint(Object x) {
        this.print(x);
    }

    @Override
    public void debugprintln() {
        this.println();
    }

    @Override
    public void debugprintln(int x) {
        this.println(x);
    }

    @Override
    public void debugprintln(boolean x) {
        this.println(x);
    }

    @Override
    public void debugprintln(String x) {
        this.println(x);
    }

    @Override
    public void debugprintln(Object x) {
        this.println(x);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

