/*
 * Decompiled with CFR 0.152.
 */
package ida.utils.collections;

import ida.utils.VectorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class DoubleSet {
    private int hashCode = -1;
    private double[] values;
    public static final EmptySet emptySet = new EmptySet();

    private DoubleSet() {
    }

    private DoubleSet(double[] values) {
        this(values, false);
    }

    private DoubleSet(double[] values, boolean sort) {
        this.values = new double[values.length];
        System.arraycopy(values, 0, this.values, 0, values.length);
        if (sort) {
            Arrays.sort(this.values);
        }
    }

    public static DoubleSet createDoubleSet(double[] values) {
        Arrays.sort(values);
        if (values.length == 0) {
            return emptySet;
        }
        return DoubleSet.createDoubleSetFromSortedArray(values);
    }

    public static DoubleSet createDoubleSetFromSortedArray(double[] values) {
        int duplicates = 0;
        for (int i = 0; i < values.length - 1; ++i) {
            if (values[i] != values[i + 1]) continue;
            ++duplicates;
        }
        if (duplicates > 0) {
            double[] newValues = new double[values.length - duplicates];
            int j = 0;
            for (int i = 0; i < newValues.length; ++i) {
                if (i != values.length - 1 && values[i] == values[i + 1]) continue;
                newValues[j] = values[i];
                ++j;
            }
            values = newValues;
        }
        if (values.length == 0) {
            return emptySet;
        }
        return new DoubleSet(values, false);
    }

    public static DoubleSet createDoubleSet(Set<Double> set) {
        double[] values = new double[set.size()];
        int index = 0;
        Iterator<Double> i$ = set.iterator();
        while (i$.hasNext()) {
            double integer;
            values[index] = integer = i$.next().doubleValue();
            ++index;
        }
        return DoubleSet.createDoubleSet(values);
    }

    public static DoubleSet intersection(DoubleSet a, DoubleSet b) {
        if (a.isEmpty() || b.isEmpty() || a.values[0] > b.values[b.values.length - 1] || b.values[0] > a.values[a.values.length - 1]) {
            return emptySet;
        }
        int count = 0;
        int indexA = 0;
        int indexB = 0;
        int aLength = a.values.length;
        int bLength = b.values.length;
        while (indexA < aLength && indexB < bLength) {
            if (a.values[indexA] == b.values[indexB]) {
                ++count;
                ++indexA;
                ++indexB;
                continue;
            }
            if (a.values[indexA] < b.values[indexB]) {
                ++indexA;
                continue;
            }
            if (!(a.values[indexA] > b.values[indexB])) continue;
            ++indexB;
        }
        if (count == aLength) {
            return a;
        }
        if (count == bLength) {
            return b;
        }
        double[] newValues = new double[count];
        indexA = 0;
        indexB = 0;
        int index = 0;
        while (indexA < aLength && indexB < bLength) {
            if (a.values[indexA] == b.values[indexB]) {
                newValues[index] = a.values[indexA];
                ++indexA;
                ++indexB;
                ++index;
                continue;
            }
            if (a.values[indexA] < b.values[indexB]) {
                ++indexA;
                continue;
            }
            if (!(a.values[indexA] > b.values[indexB])) continue;
            ++indexB;
        }
        if (count == 0) {
            return emptySet;
        }
        DoubleSet set = new DoubleSet();
        set.values = newValues;
        return set;
    }

    public static DoubleSet union(DoubleSet a, DoubleSet b) {
        if (a instanceof EmptySet) {
            return b;
        }
        if (b instanceof EmptySet) {
            return a;
        }
        int aLength = a.values.length;
        int bLength = b.values.length;
        double[] aValues = a.values;
        double[] bValues = b.values;
        if (a == b) {
            return a;
        }
        if (aValues[aLength - 1] < bValues[0]) {
            double[] values = VectorUtils.concat(aValues, bValues);
            return new DoubleSet(values);
        }
        if (aValues[0] > bValues[bLength - 1]) {
            double[] values = VectorUtils.concat(bValues, aValues);
            return new DoubleSet(values);
        }
        int count = 0;
        int indexA = 0;
        int indexB = 0;
        while (indexA < aLength || indexB < bLength) {
            if (indexA < aLength && indexB < bLength) {
                double aValue = aValues[indexA];
                double bValue = bValues[indexB];
                if (aValue == bValue) {
                    ++indexA;
                    ++indexB;
                    ++count;
                    continue;
                }
                if (aValue < bValue) {
                    ++indexA;
                    ++count;
                    continue;
                }
                if (!(aValue > bValue)) continue;
                ++indexB;
                ++count;
                continue;
            }
            if (indexA < aLength) {
                ++indexA;
                ++count;
                continue;
            }
            if (indexB >= bLength) continue;
            ++indexB;
            ++count;
        }
        if (count == aLength) {
            return a;
        }
        if (count == bLength) {
            return b;
        }
        double[] newValues = new double[count];
        indexA = 0;
        indexB = 0;
        int index = 0;
        while (indexA < aLength || indexB < bLength) {
            if (indexA < aLength && indexB < bLength) {
                double aValue = aValues[indexA];
                double bValue = bValues[indexB];
                if (aValue == bValue) {
                    newValues[index] = aValue;
                    ++indexA;
                    ++indexB;
                    ++index;
                    continue;
                }
                if (aValue < bValue) {
                    newValues[index] = aValue;
                    ++indexA;
                    ++index;
                    continue;
                }
                if (!(aValue > bValue)) continue;
                newValues[index] = bValue;
                ++indexB;
                ++index;
                continue;
            }
            if (indexA < aLength) {
                newValues[index] = aValues[indexA];
                ++indexA;
                ++index;
                continue;
            }
            if (indexB >= bLength) continue;
            newValues[index] = bValues[indexB];
            ++indexB;
            ++index;
        }
        DoubleSet set = new DoubleSet();
        set.values = newValues;
        return set;
    }

    public static DoubleSet difference(DoubleSet a, DoubleSet b) {
        int indexA;
        if (a == b) {
            return emptySet;
        }
        if (a instanceof EmptySet) {
            return emptySet;
        }
        if (b instanceof EmptySet) {
            return a;
        }
        int indexB = 0;
        int count = 0;
        for (indexA = 0; indexA < a.values.length; ++indexA) {
            while (indexB < b.values.length && b.values[indexB] < a.values[indexA]) {
                ++indexB;
            }
            if (indexB < b.values.length && b.values[indexB] > a.values[indexA]) {
                ++count;
                continue;
            }
            if (indexB < b.values.length) continue;
            ++count;
        }
        double[] newValues = new double[count];
        indexB = 0;
        count = 0;
        for (indexA = 0; indexA < a.values.length; ++indexA) {
            while (indexB < b.values.length && b.values[indexB] < a.values[indexA]) {
                ++indexB;
            }
            if (indexB < b.values.length && b.values[indexB] > a.values[indexA]) {
                newValues[count] = a.values[indexA];
                ++count;
                continue;
            }
            if (indexB < b.values.length) continue;
            newValues[count] = a.values[indexA];
            ++count;
        }
        if (newValues.length == 0) {
            return emptySet;
        }
        DoubleSet set = new DoubleSet();
        set.values = newValues;
        return set;
    }

    public static boolean allAreSubsets(List<DoubleSet> a, List<DoubleSet> b) {
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).isSubsetOf(b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean allAreSubsets(DoubleSet[] a, DoubleSet[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i].isSubsetOf(b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean allAreEmpty(List<DoubleSet> a) {
        for (DoubleSet is : a) {
            if (is.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean allAreEmpty(DoubleSet[] a) {
        for (DoubleSet is : a) {
            if (is.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean someAreEmpty(List<DoubleSet> a) {
        for (DoubleSet is : a) {
            if (!is.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean someAreEmpty(DoubleSet[] a) {
        for (DoubleSet is : a) {
            if (!is.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean allAreEmpty(DoubleSet[] a, boolean[] mask) {
        int i = 0;
        for (DoubleSet is : a) {
            if (mask[i] && !is.isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean someAreEmpty(DoubleSet[] a, boolean[] mask) {
        int i = 0;
        for (DoubleSet is : a) {
            if (mask[i] && is.isEmpty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean someAreSubsets(List<DoubleSet> a, List<DoubleSet> b) {
        for (int i = 0; i < a.size(); ++i) {
            if (!a.get(i).isSubsetOf(b.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean someAreSubsets(DoubleSet[] a, DoubleSet[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].isSubsetOf(b[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean allAreSubsets(DoubleSet[] a, DoubleSet[] b, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || a[i].isSubsetOf(b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean someAreSubsets(DoubleSet[] a, DoubleSet[] b, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || !a[i].isSubsetOf(b[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean allAreEqual(List<DoubleSet> a, List<DoubleSet> b) {
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).equals(b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean allAreEqual(DoubleSet[] a, DoubleSet[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean someAreEqual(List<DoubleSet> a, List<DoubleSet> b) {
        for (int i = 0; i < a.size(); ++i) {
            if (!a.get(i).equals(b.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean someAreEqual(DoubleSet[] a, DoubleSet[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equals(b[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean allAreEqual(DoubleSet[] a, DoubleSet[] b, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean someAreEqual(DoubleSet[] a, DoubleSet[] b, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || !a[i].equals(b[i])) continue;
            return true;
        }
        return false;
    }

    public static DoubleSet intersection(Collection<DoubleSet> sets) {
        DoubleSet result = null;
        for (DoubleSet set : sets) {
            if (result == null) {
                result = set;
                continue;
            }
            result = DoubleSet.intersection(result, set);
        }
        return result;
    }

    public static DoubleSet intersection(DoubleSet ... sets) {
        DoubleSet result = null;
        for (DoubleSet set : sets) {
            result = result == null ? set : DoubleSet.intersection(result, set);
        }
        return result;
    }

    public static DoubleSet[] intersection(DoubleSet[] a, DoubleSet[] b) {
        DoubleSet[] retVal = new DoubleSet[a.length];
        for (int i = 0; i < a.length; ++i) {
            retVal[i] = DoubleSet.intersection(a[i], b[i]);
        }
        return retVal;
    }

    public static List<DoubleSet> intersection(List<DoubleSet> a, List<DoubleSet> b) {
        ArrayList<DoubleSet> retVal = new ArrayList<DoubleSet>(a.size());
        Iterator<DoubleSet> iter1 = a.iterator();
        Iterator<DoubleSet> iter2 = b.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            retVal.add(DoubleSet.intersection(iter1.next(), iter2.next()));
        }
        return retVal;
    }

    public static DoubleSet union(Collection<DoubleSet> sets) {
        DoubleSet result = null;
        for (DoubleSet set : sets) {
            if (result == null) {
                result = set;
                continue;
            }
            result = DoubleSet.union(result, set);
        }
        return result;
    }

    public static DoubleSet union(DoubleSet ... sets) {
        DoubleSet result = null;
        for (DoubleSet set : sets) {
            result = result == null ? set : DoubleSet.union(result, set);
        }
        return result;
    }

    public static DoubleSet[] union(DoubleSet[] a, DoubleSet[] b) {
        DoubleSet[] retVal = new DoubleSet[a.length];
        for (int i = 0; i < a.length; ++i) {
            retVal[i] = DoubleSet.union(a[i], b[i]);
        }
        return retVal;
    }

    public static List<DoubleSet> union(List<DoubleSet> a, List<DoubleSet> b) {
        ArrayList<DoubleSet> retVal = new ArrayList<DoubleSet>(a.size());
        Iterator<DoubleSet> iter1 = a.iterator();
        Iterator<DoubleSet> iter2 = b.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            retVal.add(DoubleSet.union(iter1.next(), iter2.next()));
        }
        return retVal;
    }

    public boolean contains(double d) {
        if (this.values.length < 16) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == d) {
                    return true;
                }
                if (!(this.values[i] > d)) continue;
                return false;
            }
        }
        return Arrays.binarySearch(this.values, d) > -1;
    }

    public boolean isSubsetOf(DoubleSet b) {
        if (b.isEmpty() || b.size() < this.size() || this.values[0] < b.values[0] || this.values[this.values.length - 1] > b.values[b.values.length - 1]) {
            return false;
        }
        int i2 = 0;
        for (int i = 0; i < this.values.length; ++i) {
            while (i2 < b.values.length && b.values[i2] < this.values[i]) {
                ++i2;
            }
            if (i2 != b.values.length && !(b.values[i2] > this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isStrictSubsetOf(DoubleSet b) {
        return !this.equals(b) && this.isSubsetOf(b);
    }

    public boolean equals(Object o) {
        if (o instanceof DoubleSet) {
            DoubleSet cis = (DoubleSet)o;
            if (this.isEmpty() != cis.isEmpty()) {
                return false;
            }
            if (cis.hashCode != -1 && this.hashCode != -1 && cis.hashCode != this.hashCode || cis.values.length != this.values.length) {
                return false;
            }
            if (cis.values[cis.values.length - 1] != this.values[this.values.length - 1]) {
                return false;
            }
            for (int i = 0; i < this.values.length - 1; ++i) {
                if (this.values[i] == cis.values[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void computeHashCode() {
        int hash = 1;
        for (int i = 0; i < this.values.length; ++i) {
            hash = (hash + 1) * (1 + (int)(this.values[i] * (double)i * (double)i * (double)i)) % 0xFFFFFF;
        }
        this.hashCode = hash;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.computeHashCode();
        }
        return this.hashCode;
    }

    public Set<Double> toSet() {
        LinkedHashSet<Double> retVal = new LinkedHashSet<Double>();
        for (double i : this.values) {
            retVal.add(i);
        }
        return retVal;
    }

    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        return "DoubleSet" + VectorUtils.doubleArrayToString(this.values);
    }

    public double[] values() {
        return this.values;
    }

    public int size() {
        return this.values.length;
    }

    private static class EmptySet
    extends DoubleSet {
        private EmptySet() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(double integer) {
            return false;
        }

        @Override
        public boolean isSubsetOf(DoubleSet b) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof EmptySet;
        }

        @Override
        public String toString() {
            return "EmptySet[]";
        }

        @Override
        public double[] values() {
            return new double[0];
        }

        @Override
        public Set<Double> toSet() {
            return new HashSet<Double>(1);
        }
    }
}

