/*
 * Decompiled with CFR 0.152.
 */
package ida.utils;

import ida.utils.VectorUtils;
import ida.utils.collections.MultiMap;
import ida.utils.tuples.Pair;
import ida.utils.tuples.Tuple;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class Sugar {
    private static Random random = new Random();

    public static <T> List<T> list() {
        return new ArrayList();
    }

    public static <T> List<T> list(T ... args) {
        ArrayList<T> list = new ArrayList<T>();
        for (T o : args) {
            list.add(o);
        }
        return list;
    }

    public static <T> List<T> list(List<T> list, int[] indices) {
        ArrayList<T> retVal = new ArrayList<T>();
        for (int index : indices) {
            retVal.add(list.get(index));
        }
        return retVal;
    }

    public static <T> List<T> filledList(T t, int count) {
        return Sugar.filledArrayList(t, count);
    }

    public static <T> List<T> filledArrayList(T t, int count) {
        ArrayList<T> retVal = new ArrayList<T>();
        for (int i = 0; i < count; ++i) {
            retVal.add(t);
        }
        return retVal;
    }

    public static <T> List<T> filledLinkedList(T t, int count) {
        LinkedList<T> retVal = new LinkedList<T>();
        for (int i = 0; i < count; ++i) {
            retVal.add(t);
        }
        return retVal;
    }

    public static <T> Tuple<T> tuple(T ... args) {
        Tuple<T> tuple = new Tuple<T>(args.length);
        int i = 0;
        for (T o : args) {
            tuple.set(o, i);
            ++i;
        }
        return tuple;
    }

    public static <T> Tuple<T> tuple(List<T> list, int[] indices) {
        Tuple<T> retVal = new Tuple<T>(indices.length);
        int i = 0;
        for (int index : indices) {
            retVal.set(list.get(index), i++);
        }
        return retVal;
    }

    public static <T> List<T> shuffle(List<T> list) {
        Collections.shuffle(list);
        return list;
    }

    public static <T> List<T> shuffle(List<T> list, Random random) {
        Collections.shuffle(list, random);
        return list;
    }

    public static <T> List<T> shuffle(List<T> list, double p) {
        for (int i = 0; i < list.size() / 2; ++i) {
            if (!(Math.random() < p)) continue;
            Collections.swap(list, i, random.nextInt(list.size() - i) + i);
        }
        return list;
    }

    public static int random() {
        return random.nextInt();
    }

    public static double randomDouble() {
        return random.nextDouble();
    }

    public static int random(int n) {
        return random.nextInt(n);
    }

    public static <T> List<T> listFromCollections(Collection<T> ... args) {
        return Sugar.arrayListFromCollections(args);
    }

    public static <T> ArrayList<T> arrayListFromCollections(Collection<T> ... args) {
        int size = 0;
        for (Collection<T> c : args) {
            size += c.size();
        }
        ArrayList<T> list = new ArrayList<T>(size);
        for (Collection<T> o : args) {
            list.addAll(o);
        }
        return list;
    }

    public static <T> LinkedList<T> linkedListFromCollections(Collection<T> ... args) {
        LinkedList<T> list = new LinkedList<T>();
        for (Collection<T> o : args) {
            list.addAll(o);
        }
        return list;
    }

    public static <R> List<R> listDifference(List<R> a, List<R> b) {
        HashSet<R> set = new HashSet<R>();
        set.addAll(b);
        ArrayList<R> diff = new ArrayList<R>();
        for (R r : a) {
            if (b.contains(r)) continue;
            diff.add(r);
        }
        return diff;
    }

    public static <R> Set<R> setDifference(Set<R> a, Set<R> b) {
        HashSet<R> diff = new HashSet<R>();
        for (R r : a) {
            if (b.contains(r)) continue;
            diff.add(r);
        }
        return diff;
    }

    public static <R> Collection<R> collectionDifference(Collection<? extends R> a, Collection<? extends R> b) {
        HashSet<? extends R> set = new HashSet<R>();
        set.addAll(b);
        ArrayList<R> diff = new ArrayList<R>();
        for (R r : a) {
            if (set.contains(r)) continue;
            diff.add(r);
        }
        return diff;
    }

    public static <R, S> Map<R, S> mapFromPairs(Collection<Pair<R, S>> coll) {
        HashMap map = new HashMap();
        for (Pair<R, S> pair : coll) {
            map.put(pair.r, pair.s);
        }
        return map;
    }

    public static <R, S> MultiMap<R, S> multiMapFromPairs(Collection<Pair<R, S>> coll) {
        MultiMap map = new MultiMap();
        for (Pair<R, S> pair : coll) {
            map.put(pair.r, pair.s);
        }
        return map;
    }

    public static <T> Set<T> set() {
        return new HashSet();
    }

    public static <T> Set<T> set(T ... args) {
        HashSet<T> set = new HashSet<T>();
        for (T o : args) {
            set.add(o);
        }
        return set;
    }

    public static <T> Set<T> setFromCollections(Collection<T> ... args) {
        HashSet<T> set = new HashSet<T>();
        for (Collection<T> o : args) {
            set.addAll(o);
        }
        return set;
    }

    public static <T> LinkedHashSet<T> linkedHashSetFromCollections(Collection<T> ... args) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (Collection<T> o : args) {
            set.addAll(o);
        }
        return set;
    }

    public static boolean isSubsetOf(Set first, Set second) {
        if (first.size() > second.size()) {
            return false;
        }
        for (Object o : first) {
            if (second.contains(o)) continue;
            return false;
        }
        return true;
    }

    public static <R> Set<R> union(List<R> a, List<R> b) {
        return Sugar.setFromCollections(a, b);
    }

    public static <R> Set<R> union(Set<R> a, Set<R> b) {
        return Sugar.setFromCollections(a, b);
    }

    public static <R> Set<R> intersection(Set<R> a, Set<R> b) {
        HashSet<R> ret = new HashSet<R>();
        if (a.size() < b.size()) {
            for (R r : a) {
                if (!b.contains(r)) continue;
                ret.add(r);
            }
        } else {
            for (R r : b) {
                if (!a.contains(r)) continue;
                ret.add(r);
            }
        }
        return ret;
    }

    public static boolean areDisjoint(Set a, Set b) {
        if (a.size() > b.size()) {
            Set temp = a;
            a = b;
            b = temp;
        }
        for (Object o : a) {
            if (!b.contains(o)) continue;
            return false;
        }
        return true;
    }

    public static <R, S> Map<R, S> mapFromMaps(Map<R, S> ... maps) {
        LinkedHashMap<R, S> map = new LinkedHashMap<R, S>();
        for (Map<R, S> m : maps) {
            map.putAll(m);
        }
        return map;
    }

    public static <T> List<T> getAll(Map<?, T> map, Collection<?> keys) {
        ArrayList<T> list = new ArrayList<T>();
        for (Object o : keys) {
            list.add(map.get(o));
        }
        return list;
    }

    public static <T> List<T> getAll(List<T> list, Collection<Integer> indices) {
        ArrayList<T> retVal = new ArrayList<T>(indices.size());
        for (int index : indices) {
            retVal.add(list.get(index));
        }
        return retVal;
    }

    public static <T> List<T> removeAll(List<T> list, Collection<Integer> indices) {
        Set<T> indexSet = Sugar.setFromCollections(indices);
        ArrayList<T> retVal = new ArrayList<T>(indices.size());
        int index = 0;
        Iterator<T> iter = list.iterator();
        while (iter.hasNext()) {
            T t = iter.next();
            if (indexSet.contains(index)) {
                retVal.add(t);
                iter.remove();
            }
            ++index;
        }
        return retVal;
    }

    public static <T, U> Map.Entry<T, U> removeOne(Map<T, U> map) {
        if (map.isEmpty()) {
            return null;
        }
        Map.Entry<T, U> entry = null;
        Iterator<Map.Entry<T, U>> i$ = map.entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry<T, U> e;
            entry = e = i$.next();
        }
        map.remove(entry.getKey());
        return entry;
    }

    public static <T> T removeOne(List<T> l) {
        if (l.isEmpty()) {
            return null;
        }
        if (l instanceof LinkedList) {
            return (T)((LinkedList)l).removeFirst();
        }
        T t = l.get(l.size() - 1);
        l.remove(l.size() - 1);
        return t;
    }

    public static <T> T removeOne(Collection<T> c) {
        T t = null;
        Iterator<T> iter = c.iterator();
        if (iter.hasNext()) {
            t = iter.next();
            iter.remove();
        }
        return t;
    }

    public static <T> T chooseOne(Collection<T> c) {
        T t;
        block0: {
            t = null;
            Iterator<T> i$ = c.iterator();
            if (!i$.hasNext()) break block0;
            T tt = i$.next();
            t = tt;
        }
        return t;
    }

    public static <T> T chooseOne(Map<? extends Object, T> map) {
        T t;
        block0: {
            t = null;
            Iterator<T> i$ = map.values().iterator();
            if (!i$.hasNext()) break block0;
            T tt = i$.next();
            t = tt;
        }
        return t;
    }

    public static <T> T chooseRandomOne(List<T> l) {
        if (l.isEmpty()) {
            return null;
        }
        return l.get(random.nextInt(l.size()));
    }

    public static String objectArrayToString(Object[] array) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Object a : array) {
            sb.append(a).append(", ");
        }
        if (sb.lastIndexOf(", ") != -1) {
            sb.delete(sb.lastIndexOf(", "), sb.length());
        }
        sb.append("]");
        return sb.toString();
    }

    public static <T> T findBest(Collection<T> c, MyComparator comparator) {
        Object best = null;
        for (T t : c) {
            if (best != null && !comparator.isABetterThanB(t, best)) continue;
            best = t;
        }
        return best;
    }

    public static <T extends Comparable> List<T> sortAsc(List<T> elements) {
        Collections.sort(elements);
        return elements;
    }

    public static <T extends Comparable> List<T> sortDesc(List<T> elements) {
        Collections.sort(elements);
        Collections.reverse(elements);
        return elements;
    }

    public static <T> List<T> sortAsc(List<T> elements, Map<T, ? extends Comparable> scores) {
        Collections.sort(elements, new MapBasedComparator<T>(scores, 1));
        return elements;
    }

    public static <T> List<T> sortDesc(List<T> elements, Map<T, ? extends Comparable> scores) {
        Collections.sort(elements, new MapBasedComparator<T>(scores, 2));
        return elements;
    }

    public static <T> List<T> removeNulls(List<T> list) {
        ArrayList<T> retVal = new ArrayList<T>();
        for (T t : list) {
            if (t == null) continue;
            retVal.add(t);
        }
        return retVal;
    }

    public static <T> Set<T> removeNulls(Set<T> set) {
        LinkedHashSet<T> retVal = new LinkedHashSet<T>();
        for (T t : set) {
            if (t == null) continue;
            retVal.add(t);
        }
        return retVal;
    }

    public static int countNulls(Collection coll) {
        int count = 0;
        for (Object o : coll) {
            if (o != null) continue;
            ++count;
        }
        return count;
    }

    public static int countOccurences(Object match, Collection coll) {
        int count = 0;
        for (Object o : coll) {
            if (!match.equals(o)) continue;
            ++count;
        }
        return count;
    }

    public static int countOccurences(Object match, Object[] array) {
        int count = 0;
        for (Object o : array) {
            if (!match.equals(o)) continue;
            ++count;
        }
        return count;
    }

    public static double max(Collection<Number> coll) {
        double max = Double.NEGATIVE_INFINITY;
        for (Number d : coll) {
            max = Math.max(max, d.doubleValue());
        }
        return max;
    }

    public static double min(Collection<Number> coll) {
        double min = Double.POSITIVE_INFINITY;
        for (Number d : coll) {
            min = Math.min(min, d.doubleValue());
        }
        return min;
    }

    public static <T, U> List<U> funcall(List<T> list, Fun<T, U> fun) {
        ArrayList<U> us = new ArrayList<U>();
        for (T t : list) {
            us.add(fun.apply(t));
        }
        return us;
    }

    public static <T, U> Set<U> funcall(Set<T> set, Fun<T, U> fun) {
        LinkedHashSet<U> us = new LinkedHashSet<U>();
        for (T t : set) {
            us.add(fun.apply(t));
        }
        return us;
    }

    public static <T, U> List<U> funcall(List<T> list, MultiFun<T, U> fun) {
        ArrayList<U> us = new ArrayList<U>();
        for (T t : list) {
            us.addAll(fun.apply(t));
        }
        return us;
    }

    public static <T, U> Set<U> funcall(Set<T> set, MultiFun<T, U> fun) {
        LinkedHashSet<U> us = new LinkedHashSet<U>();
        for (T t : set) {
            us.addAll(fun.apply(t));
        }
        return us;
    }

    public static <T, U> Map<T, U> mapcall(Collection<T> coll, Fun<T, U> fun) {
        HashMap<T, U> us = new HashMap<T, U>();
        for (T t : coll) {
            us.put(t, fun.apply(t));
        }
        return us;
    }

    public static <V, T, U> Map<V, U> funcall(Map<V, T> map, Fun<T, U> fun) {
        LinkedHashMap<V, U> us = new LinkedHashMap<V, U>();
        for (Map.Entry<V, T> entry : map.entrySet()) {
            us.put(entry.getKey(), fun.apply(entry.getValue()));
        }
        return us;
    }

    public static <T, U> List<U> funcall(List<T> list, FunWithParams<T, U> fun, Object ... params) {
        ArrayList<U> us = new ArrayList<U>();
        for (T t : list) {
            us.add(fun.apply(t, params));
        }
        return us;
    }

    public static <T, U> Set<U> funcall(Set<T> set, FunWithParams<T, U> fun, Object ... params) {
        LinkedHashSet<U> us = new LinkedHashSet<U>();
        for (T t : set) {
            us.add(fun.apply(t, params));
        }
        return us;
    }

    public static <T, U> Map<T, U> mapcall(Collection<T> list, FunWithParams<T, U> fun, Object ... params) {
        HashMap<T, U> us = new HashMap<T, U>();
        for (T t : list) {
            us.put(t, fun.apply(t, params));
        }
        return us;
    }

    public static <V, T, U> Map<V, U> funcall(Map<V, T> map, FunWithParams<T, U> fun, Object ... params) {
        LinkedHashMap<V, U> us = new LinkedHashMap<V, U>();
        for (Map.Entry<V, T> entry : map.entrySet()) {
            us.put(entry.getKey(), fun.apply(entry.getValue(), params));
        }
        return us;
    }

    public static <T, U> List<U> funcall(List<T> list, MultiFunWithParams<T, U> fun, Object ... params) {
        ArrayList<U> us = new ArrayList<U>();
        for (T t : list) {
            us.addAll(fun.apply(t, params));
        }
        return us;
    }

    public static <T, U> Set<U> funcall(Set<T> set, MultiFunWithParams<T, U> fun, Object ... params) {
        LinkedHashSet<U> us = new LinkedHashSet<U>();
        for (T t : set) {
            us.addAll(fun.apply(t, params));
        }
        return us;
    }

    public static void runInParallel(Runnable ... tasks) {
        ArrayList<Runnable> list = new ArrayList<Runnable>(tasks.length);
        list.addAll(Arrays.asList(tasks));
        Sugar.runInParallel(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runInParallel(final List<? extends Runnable> tasks, int processors) {
        final Int counter = new Int();
        counter.value = tasks.size();
        for (int i = 0; i < processors; ++i) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Runnable action;
                    do {
                        action = null;
                        Object object = tasks;
                        synchronized (object) {
                            if (tasks.size() > 0) {
                                action = (Runnable)tasks.get(tasks.size() - 1);
                                tasks.remove(tasks.size() - 1);
                            }
                        }
                        if (action == null) continue;
                        action.run();
                        object = counter;
                        synchronized (object) {
                            --counter.value;
                            counter.notify();
                        }
                    } while (action != null);
                }
            }).start();
        }
        Int intVal = counter;
        synchronized (intVal) {
            while (counter.value > 0) {
                try {
                    counter.wait();
                }
                catch (InterruptedException ie) {
                    System.out.println(ie.getMessage());
                }
            }
        }
    }

    public static void runInParallel(List<? extends Runnable> tasks) {
        Sugar.runInParallel(tasks, tasks.size());
    }

    public static String readFile(Reader r) throws IOException {
        BufferedReader b = new BufferedReader(r);
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = b.readLine()) != null) {
            sb.append(line).append("\n");
        }
        b.close();
        return sb.toString();
    }

    public static List<String> readLines(Reader r) throws IOException {
        BufferedReader b = new BufferedReader(r);
        ArrayList<String> retVal = new ArrayList<String>();
        String line = null;
        while ((line = b.readLine()) != null) {
            retVal.add(line);
        }
        b.close();
        return retVal;
    }

    public static void saveFile(String s, Writer writer) throws IOException {
        PrintWriter pw = new PrintWriter(writer);
        pw.print(s);
        pw.close();
    }

    public static int stringHashCode(String str) {
        int ret = 0;
        int cap = Integer.MAX_VALUE;
        char[] vector = str.toCharArray();
        for (int i = 0; i < vector.length; ++i) {
            ret = (ret + 1) * (vector[i] + '\u0001') % cap;
        }
        if (ret < 0) {
            ret = (cap - ret) % cap;
        }
        return ret;
    }

    public static <R> List<Collection<R>> splitCollection(Collection<R> coll, int count) {
        int i;
        ArrayList<Collection<R>> retVal = new ArrayList<Collection<R>>();
        for (i = 0; i < count; ++i) {
            retVal.add(new ArrayList());
        }
        i = 0;
        for (R r : coll) {
            ((Collection)retVal.get(i % count)).add(r);
            ++i;
        }
        return retVal;
    }

    public static <R> List<List<R>> splitList(List<R> list, int count) {
        int i;
        ArrayList<List<R>> retVal = new ArrayList<List<R>>();
        for (i = 0; i < count; ++i) {
            retVal.add(new ArrayList());
        }
        i = 0;
        for (R r : list) {
            ((List)retVal.get(i % count)).add(r);
            ++i;
        }
        return retVal;
    }

    public static <R, S> List<Map<R, S>> splitMap(Map<R, S> map, int count) {
        int i;
        ArrayList<Map<R, S>> retVal = new ArrayList<Map<R, S>>();
        for (i = 0; i < count; ++i) {
            retVal.add(new HashMap());
        }
        i = 0;
        for (Map.Entry<R, S> entry : map.entrySet()) {
            ((Map)retVal.get(i % count)).put(entry.getKey(), entry.getValue());
            ++i;
        }
        return retVal;
    }

    public static <T> List<T> flatten(List<List<T>> list) {
        ArrayList<T> retVal = new ArrayList<T>();
        for (List<T> l : list) {
            for (T t : l) {
                retVal.add(t);
            }
        }
        return retVal;
    }

    public static <T> Collection<T> flatten(Collection<? extends Collection<T>> coll) {
        ArrayList<T> retVal = new ArrayList<T>();
        for (Collection<T> l : coll) {
            for (T t : l) {
                retVal.add(t);
            }
        }
        return retVal;
    }

    public static <T> T println(T t) {
        System.out.println(t);
        return t;
    }

    public static <T> T print(T t) {
        System.out.println(t);
        return t;
    }

    public static int find(Object[] array, Object o) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    public static String reverse(String str) {
        char[] ch = str.toCharArray();
        VectorUtils.reverse(ch);
        return String.valueOf(ch);
    }

    public static String firstCharacterToUpperCase(String s) {
        char[] chars = s.toCharArray();
        if (chars.length > 0) {
            chars[0] = Character.toUpperCase(chars[0]);
        }
        return new String(chars);
    }

    public static String firstCharacterToLowerCase(String s) {
        char[] chars = s.toCharArray();
        if (chars.length > 0) {
            chars[0] = Character.toLowerCase(chars[0]);
        }
        return new String(chars);
    }

    public static void setRandomNumberGenerator(Random random) {
        Sugar.random = random;
    }

    private static class Int {
        int value;

        private Int() {
        }
    }

    public static interface MyComparator<T> {
        public boolean isABetterThanB(T var1, T var2);
    }

    public static interface MultiFunWithParams<T, U> {
        public Collection<U> apply(T var1, Object ... var2);
    }

    public static interface FunWithParams<T, U> {
        public U apply(T var1, Object ... var2);
    }

    public static interface MultiFun<T, U> {
        public Collection<U> apply(T var1);
    }

    public static class IdentityFun<T>
    implements Fun<T, T> {
        @Override
        public T apply(T t) {
            return t;
        }
    }

    public static interface Fun<T, U> {
        public U apply(T var1);
    }

    public static interface VoidFun<T> {
        public void apply(T var1);
    }

    private static class MapBasedComparator<T>
    implements Comparator<T> {
        private static final int ASC = 1;
        private static final int DESC = 2;
        private Map<T, ? extends Comparable> scores;
        private int mode = 1;

        public MapBasedComparator(Map<T, ? extends Comparable> scores, int mode) {
            this.scores = scores;
            this.mode = mode;
        }

        @Override
        public int compare(T arg0, T arg1) {
            int scoreDiff = this.scores.get(arg0).compareTo(this.scores.get(arg1));
            if (scoreDiff == 0) {
                return arg0.toString().compareTo(arg1.toString());
            }
            if (this.mode == 1) {
                return scoreDiff;
            }
            return -scoreDiff;
        }
    }
}

