/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.treeLiker.impl;

import ida.ilp.treeLiker.Domain;
import ida.ilp.treeLiker.Settings;
import ida.utils.Parallel;
import ida.utils.Sugar;
import ida.utils.collections.Counters;
import ida.utils.collections.IntegerMultiMap;
import ida.utils.collections.IntegerSet;
import ida.utils.collections.MultiMap;
import ida.utils.tuples.Pair;
import ida.utils.tuples.Quadruple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IrrelevancyFiltering {
    private boolean[] mask;
    private boolean[] negMask;
    private Collection<Integer> candidates;
    private Map<Integer, Domain[]> computedDomains;
    private List<Pair<Integer, Integer>> exampleTermPairs = Collections.synchronizedList(new ArrayList());
    private static Parallel parallel = new Parallel(Runtime.getRuntime().availableProcessors());

    public IrrelevancyFiltering(Collection<Integer> cands, Map<Integer, Domain[]> computedDomains, boolean[] mask, boolean[] negMask) {
        this.mask = mask;
        this.negMask = negMask;
        this.candidates = cands;
        this.computedDomains = Collections.synchronizedMap(computedDomains);
        LinkedHashSet<Pair<Integer, Integer>> set = new LinkedHashSet<Pair<Integer, Integer>>();
        Counters<Pair<Integer, Integer>> exampleTermPairCounter = new Counters<Pair<Integer, Integer>>();
        for (Integer id : this.candidates) {
            Domain[] domains = computedDomains.get(id);
            for (int i = 0; i < domains.length; ++i) {
                for (int j : domains[i].integerSet().values()) {
                    set.add(new Pair<Integer, Integer>(i, j));
                    exampleTermPairCounter.increment(new Pair<Integer, Integer>(i, j));
                }
            }
        }
        this.exampleTermPairs.addAll(set);
    }

    public List<Integer> filter() {
        if (Settings.USE_REDUNDANCY_FILTERING) {
            List<Integer> retVal = Collections.synchronizedList(this.findRelevant(Sugar.listFromCollections(this.candidates)));
            return retVal;
        }
        return Sugar.listFromCollections(this.candidates);
    }

    private List<Integer> findRelevant(List<Integer> candidates) {
        if (candidates.size() <= 100) {
            return this.filterIrrelevant(candidates);
        }
        Pair<List<Integer>, List<Integer>> splitted = this.split(candidates);
        List<Integer> a = this.findRelevant((List)splitted.r);
        List<Integer> b = this.findRelevant((List)splitted.s);
        List<Integer> c = this.findRelevant(a, b);
        return Sugar.listFromCollections(a, c);
    }

    private List<Integer> findRelevant(List<Integer> better, List<Integer> worse) {
        if (worse.isEmpty()) {
            return better;
        }
        if (better.isEmpty()) {
            return worse;
        }
        if (better.size() < 200 || worse.size() < 200) {
            return this.filterIrrelevant(better, worse);
        }
        Quadruple<List<Integer>, List<Integer>, List<Integer>, List<Integer>> quad = this.split(better, worse);
        List betterBetter = (List)quad.r;
        List betterWorse = (List)quad.s;
        List worseBetter = (List)quad.t;
        List worseWorse = (List)quad.u;
        if (betterBetter.isEmpty() || betterWorse.isEmpty() || worseBetter.isEmpty() || worseWorse.isEmpty()) {
            return this.filterIrrelevant(better, worse);
        }
        List<Integer> a = this.findRelevant(betterBetter, worseBetter);
        List<Integer> b = this.findRelevant(betterWorse, worseWorse);
        List<Integer> c = this.findRelevant(betterBetter, b);
        return Sugar.listFromCollections(a, c);
    }

    private List<Integer> buildSplitBag(List<Integer> candidates, MultiMap<Pair<Integer, Integer>, Integer> outputBag) {
        List splitted = Sugar.splitList(candidates, Runtime.getRuntime().availableProcessors());
        ArrayList<SplitBagBuilder> tasks = new ArrayList<SplitBagBuilder>();
        int index = 0;
        for (List<Integer> list : splitted) {
            tasks.add(new SplitBagBuilder(index, list, outputBag));
            index += list.size();
        }
        parallel.runTasks(tasks);
        return Sugar.flatten(splitted);
    }

    private Pair<List<Integer>, List<Integer>> split(List<Integer> candidates) {
        MultiMap<Pair<Integer, Integer>, Integer> bag = new MultiMap<Pair<Integer, Integer>, Integer>();
        candidates = this.buildSplitBag(candidates, bag);
        Set<Pair<Integer, Integer>> splits = bag.keySet();
        IntegerMultiMap ib = IntegerMultiMap.createIntegerMultiMap(bag);
        IntegerSet a = IntegerSet.emptySet;
        IntegerSet b = IntegerSet.emptySet;
        IntegerSet candidateIndices = IntegerSet.createIntegerSet(0, candidates.size());
        for (Pair<Integer, Integer> split : splits) {
            if (candidates.size() > 4 && 2 * candidates.size() - 4 * ((IntegerSet)a).size() < candidates.size() || candidates.size() > 4 && 2 * candidates.size() - 4 * ((IntegerSet)b).size() < candidates.size()) break;
            IntegerSet newA = null;
            IntegerSet newB = null;
            if (this.mask[(Integer)split.r]) {
                newA = IntegerSet.union(ib.get(split), a);
                if (newA.size() <= candidates.size() / 2 + candidates.size() % 2) {
                    a = newA;
                }
                if ((newB = IntegerSet.union(b, IntegerSet.difference(candidateIndices, ib.get(split)))).size() > candidates.size() / 2 + candidates.size() % 2) continue;
                b = newB;
                continue;
            }
            newA = IntegerSet.union(a, IntegerSet.difference(candidateIndices, ib.get(split)));
            if (newA.size() <= candidates.size() / 2 + candidates.size() % 2) {
                a = newA;
            }
            if ((newB = IntegerSet.union(b, ib.get(split))).size() > candidates.size() / 2 + candidates.size() % 2) continue;
            b = newB;
        }
        if (((IntegerSet)a).isEmpty()) {
            HashSet<Integer> bSet = new HashSet<Integer>();
            for (int i : ((IntegerSet)b).values()) {
                bSet.add(candidates.get(i));
            }
            return new Pair<List<Integer>, List<Integer>>(Sugar.listFromCollections(Sugar.collectionDifference(candidates, bSet)), Sugar.listFromCollections(bSet));
        }
        HashSet<Integer> aSet = new HashSet<Integer>();
        for (int i : ((IntegerSet)a).values()) {
            aSet.add(candidates.get(i));
        }
        return new Pair<List<Integer>, List<Integer>>(Sugar.listFromCollections(aSet), Sugar.listFromCollections(Sugar.collectionDifference(candidates, aSet)));
    }

    /*
     * WARNING - void declaration
     */
    private Quadruple<List<Integer>, List<Integer>, List<Integer>, List<Integer>> split(List<Integer> better, List<Integer> worse) {
        void var13_15;
        HashSet<Pair<Integer, Integer>> splits = new HashSet<Pair<Integer, Integer>>();
        MultiMap<Pair<Integer, Integer>, Integer> betterBag = new MultiMap<Pair<Integer, Integer>, Integer>();
        MultiMap<Pair<Integer, Integer>, Integer> worseBag = new MultiMap<Pair<Integer, Integer>, Integer>();
        better = this.buildSplitBag(better, betterBag);
        splits.addAll(betterBag.keySet());
        IntegerSet betterCI = IntegerSet.createIntegerSet(0, better.size());
        IntegerMultiMap betterIB = IntegerMultiMap.createIntegerMultiMap(betterBag);
        worse = this.buildSplitBag(worse, worseBag);
        splits.addAll(worseBag.keySet());
        IntegerSet worseCI = IntegerSet.createIntegerSet(0, worse.size());
        IntegerMultiMap worseIB = IntegerMultiMap.createIntegerMultiMap(worseBag);
        LinkedHashSet<Pair> splitsOfBoth_Set = new LinkedHashSet<Pair>();
        HashMap<Pair, Integer> evals = new HashMap<Pair, Integer>();
        for (Pair pair : splits) {
            if (betterIB.get(pair).size() <= 0 || worseIB.get(pair).size() <= 0) continue;
            splitsOfBoth_Set.add(pair);
            evals.put(pair, Math.min(Math.abs(better.size() / 2 + better.size() % 2 - betterIB.get(pair).size()), worse.size() / 2 + worse.size() % 2 - worseIB.get(pair).size()));
        }
        List<Pair> splitsOfBoth = Sugar.listFromCollections(splitsOfBoth_Set);
        Sugar.sortDesc(splitsOfBoth, evals);
        IntegerSet.EmptySet emptySet = IntegerSet.emptySet;
        IntegerSet betterWorse = IntegerSet.emptySet;
        IntegerSet worseBetter = IntegerSet.emptySet;
        IntegerSet worseWorse = IntegerSet.emptySet;
        for (Pair split : splitsOfBoth) {
            IntegerSet newBetterBetter = null;
            IntegerSet newBetterWorse = null;
            IntegerSet newWorseBetter = null;
            IntegerSet newWorseWorse = null;
            if (better.size() > 4 && 2 * better.size() - 4 * var13_15.size() < better.size() && worse.size() > 4 && 2 * worse.size() - 4 * ((IntegerSet)worseBetter).size() < better.size() || better.size() > 4 && 2 * better.size() - 4 * ((IntegerSet)betterWorse).size() < better.size() && worse.size() > 4 && 2 * worse.size() - 4 * ((IntegerSet)worseWorse).size() < better.size()) break;
            if (this.mask[(Integer)split.r]) {
                newBetterBetter = IntegerSet.union(betterIB.get(split), (IntegerSet)var13_15);
                newWorseBetter = IntegerSet.union(worseIB.get(split), worseBetter);
                if (newBetterBetter.size() <= better.size() / 2 + better.size() % 2 && newWorseBetter.size() <= worse.size() / 2 + worse.size() % 2) {
                    IntegerSet integerSet = newBetterBetter;
                    worseBetter = newWorseBetter;
                }
                newBetterWorse = IntegerSet.union(betterWorse, IntegerSet.difference(betterCI, betterIB.get(split)));
                newWorseWorse = IntegerSet.union(worseWorse, IntegerSet.difference(worseCI, worseIB.get(split)));
                if (newBetterWorse.size() > better.size() / 2 + better.size() % 2 || newWorseWorse.size() > worse.size() / 2 + worse.size() % 2) continue;
                betterWorse = newBetterWorse;
                worseWorse = newWorseWorse;
                continue;
            }
            newBetterBetter = IntegerSet.union((IntegerSet)var13_15, IntegerSet.difference(betterCI, betterIB.get(split)));
            newWorseBetter = IntegerSet.union(worseBetter, IntegerSet.difference(worseCI, worseIB.get(split)));
            if (newBetterBetter.size() <= better.size() / 2 + better.size() % 2 && newWorseBetter.size() <= worse.size() / 2 + worse.size() % 2) {
                IntegerSet integerSet = newBetterBetter;
                worseBetter = newWorseBetter;
            }
            newBetterWorse = IntegerSet.union(betterWorse, betterIB.get(split));
            newWorseWorse = IntegerSet.union(worseWorse, worseIB.get(split));
            if (newBetterWorse.size() > better.size() / 2 + better.size() % 2 || newWorseWorse.size() > worse.size() / 2 + worse.size() % 2) continue;
            betterWorse = newBetterWorse;
            worseWorse = newWorseWorse;
        }
        if (var13_15.isEmpty() || ((IntegerSet)worseBetter).isEmpty()) {
            HashSet<Integer> betterWorseSet = new HashSet<Integer>();
            HashSet<Integer> worseWorseSet = new HashSet<Integer>();
            for (int i : ((IntegerSet)betterWorse).values()) {
                betterWorseSet.add(better.get(i));
            }
            for (int i : ((IntegerSet)worseWorse).values()) {
                worseWorseSet.add(worse.get(i));
            }
            return new Quadruple<List<Integer>, List<Integer>, List<Integer>, List<Integer>>(Sugar.listFromCollections(Sugar.collectionDifference(better, betterWorseSet)), Sugar.listFromCollections(betterWorseSet), Sugar.listFromCollections(Sugar.collectionDifference(worse, worseWorseSet)), Sugar.listFromCollections(worseWorseSet));
        }
        HashSet<Integer> betterBetterSet = new HashSet<Integer>();
        HashSet<Integer> worseBetterSet = new HashSet<Integer>();
        for (int i : var13_15.values()) {
            betterBetterSet.add(better.get(i));
        }
        for (int i : ((IntegerSet)worseBetter).values()) {
            worseBetterSet.add(worse.get(i));
        }
        return new Quadruple<List<Integer>, List<Integer>, List<Integer>, List<Integer>>(Sugar.listFromCollections(betterBetterSet), Sugar.listFromCollections(Sugar.collectionDifference(better, betterBetterSet)), Sugar.listFromCollections(worseBetterSet), Sugar.listFromCollections(Sugar.collectionDifference(worse, worseBetterSet)));
    }

    private List<Integer> filterIrrelevant(Collection<Integer> candidates) {
        candidates = Sugar.listFromCollections(candidates);
        LinkedList<Integer> candidatesList = new LinkedList<Integer>();
        candidatesList.addAll(candidates);
        HashMap<Integer, Integer> evaluationMap = new HashMap<Integer, Integer>();
        for (Integer id : candidatesList) {
            evaluationMap.put(id, this.sumSizes(this.computedDomains.get(id), this.mask) - this.sumSizes(this.computedDomains.get(id), this.negMask));
        }
        Sugar.sortDesc(candidatesList, evaluationMap);
        Iterator iter1 = candidatesList.iterator();
        block1: while (iter1.hasNext()) {
            Integer id1 = (Integer)iter1.next();
            for (Integer id2 : candidatesList) {
                boolean couldADominateB;
                if (id1.equals(id2) || !(couldADominateB = this.couldADominateB(this.computedDomains.get(id2), this.computedDomains.get(id1))) || !this.allAreSubsets(this.computedDomains.get(id1), this.computedDomains.get(id2), this.mask) || !this.allAreSubsets(this.computedDomains.get(id2), this.computedDomains.get(id1), this.negMask)) continue;
                iter1.remove();
                continue block1;
            }
        }
        return candidatesList;
    }

    private List<Integer> filterIrrelevant(List<Integer> better, List<Integer> worse) {
        List<Integer> filtered = Collections.synchronizedList(new ArrayList());
        ArrayList<FilterIrrelevant2> tasks = new ArrayList<FilterIrrelevant2>();
        better = Collections.synchronizedList(better);
        for (Integer pair : worse) {
            tasks.add(new FilterIrrelevant2(better, Sugar.list(pair), filtered));
        }
        parallel.runTasks(tasks);
        return filtered;
    }

    private List<Integer> filterIrrelevantImpl(List<Integer> better, List<Integer> worse) {
        Iterator<Integer> iter1 = worse.iterator();
        block0: while (iter1.hasNext()) {
            Integer id1 = iter1.next();
            for (Integer id2 : better) {
                boolean couldADominateB = this.couldADominateB(this.computedDomains.get(id2), this.computedDomains.get(id1));
                if (!couldADominateB || !this.allAreSubsets(this.computedDomains.get(id1), this.computedDomains.get(id2), this.mask) || !this.allAreSubsets(this.computedDomains.get(id2), this.computedDomains.get(id1), this.negMask)) continue;
                iter1.remove();
                continue block0;
            }
        }
        return worse;
    }

    private int sumSizes(Domain[] domains, boolean[] mask) {
        int sum = 0;
        int index = 0;
        for (Domain is : domains) {
            if (mask[index]) {
                sum += is.integerSet().size();
            }
            ++index;
        }
        return sum;
    }

    private boolean allAreSubsets(Domain[] a, Domain[] b, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || a[i].integerSet().isSubsetOf(b[i].integerSet())) continue;
            return false;
        }
        return true;
    }

    private boolean couldADominateB(Domain[] a, Domain[] b) {
        for (int i = 0; i < a.length; ++i) {
            if ((a[i].integerSet().size() >= b[i].integerSet().size() || !this.mask[i]) && (b[i].integerSet().size() >= a[i].integerSet().size() || !this.negMask[i])) continue;
            return false;
        }
        return true;
    }

    private class FilterIrrelevant2
    implements Runnable {
        private List<Integer> better;
        private List<Integer> worse;
        private List<Integer> output;

        public FilterIrrelevant2(List<Integer> better, List<Integer> worse, List<Integer> output) {
            this.better = better;
            this.worse = worse;
            this.output = output;
        }

        @Override
        public void run() {
            this.output.addAll(IrrelevancyFiltering.this.filterIrrelevantImpl(this.better, this.worse));
        }
    }

    private class SplitBagBuilder
    implements Runnable {
        private int startIndex;
        private List<Integer> input;
        private final MultiMap<Pair<Integer, Integer>, Integer> outputBag;

        public SplitBagBuilder(int startIndex, List<Integer> input, MultiMap<Pair<Integer, Integer>, Integer> outputBag) {
            this.startIndex = startIndex;
            this.input = input;
            this.outputBag = outputBag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MultiMap<Pair<Integer, Integer>, Integer> tempBag = new MultiMap<Pair<Integer, Integer>, Integer>();
            int index = this.startIndex;
            for (Integer id : this.input) {
                Domain[] domains = (Domain[])IrrelevancyFiltering.this.computedDomains.get(id);
                for (int i = 0; i < domains.length; ++i) {
                    for (int d : domains[i].integerSet().values()) {
                        tempBag.put(new Pair<Integer, Integer>(i, d), index);
                    }
                }
                ++index;
            }
            MultiMap<Pair<Integer, Integer>, Integer> multiMap = this.outputBag;
            synchronized (multiMap) {
                this.outputBag.putAll(tempBag);
            }
        }
    }
}

