/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.treeLiker;

import ida.utils.StringUtils;
import ida.utils.Sugar;
import ida.utils.collections.MultiList;
import ida.utils.collections.MultiMap;
import ida.utils.tuples.Pair;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Table<E, A> {
    private int examplesCount;
    private MultiMap<A, String> attributeValues = new MultiMap();
    private MultiMap<A, Pair<E, String>> attributes = new MultiMap();
    private MultiMap<A, String> additionalUnseenValues = new MultiMap();
    private Map<E, String> classification = new LinkedHashMap<E, String>();
    private Set<E> examples = new HashSet();
    private Set<String> additionalUnseenClassifications = new HashSet<String>();
    private Map<A, Integer> sizes = new LinkedHashMap<A, Integer>();
    private static final String NUMERIC = "NUMERIC";

    public void processAttributes(Sugar.Fun<A, A> fun) {
        ArrayList<Pair<A, A>> pairs = new ArrayList<Pair<A, A>>();
        for (A a : this.attributes.keySet()) {
            pairs.add(new Pair<A, A>(a, fun.apply(a)));
        }
        for (Pair pair : pairs) {
            Set<Pair<E, String>> values = this.attributes.remove(pair.r);
            this.attributes.putAll(pair.s, values);
        }
    }

    public void addClassification(E example, String classif) {
        this.examples.add(example);
        this.classification.put(example, classif);
    }

    public String getClassification(E example) {
        return this.classification.get(example);
    }

    public void add(E example, A attribute, String value) {
        this.add(example, attribute, value, Integer.MAX_VALUE);
    }

    public void add(E example, A attribute, String value, int size) {
        this.examples.add(example);
        this.attributes.put(attribute, new Pair<E, String>(example, value));
        this.attributeValues.put(attribute, value);
        this.sizes.put(attribute, size);
    }

    public void removeAttribute(A attribute) {
        if (attribute instanceof String && attribute.equals("classification")) {
            this.classification.clear();
        }
        this.attributes.remove(attribute);
        this.attributeValues.remove(attribute);
        this.sizes.remove(attribute);
    }

    public Map<E, String> getAttributeVector(A attribute) {
        return Sugar.mapFromPairs(this.attributes.get(attribute));
    }

    public Set<A> attributes() {
        return this.attributes.keySet();
    }

    public Set<E> examples() {
        return this.examples;
    }

    public Set<A> filteredAttributes() {
        MultiMap<Set<Pair<E, String>>, A> filter = new MultiMap<Set<Pair<E, String>>, A>();
        for (Map.Entry<A, Set<Pair<E, String>>> entry : this.attributes.entrySet()) {
            filter.put(entry.getValue(), entry.getKey());
        }
        HashSet retVal = new HashSet();
        Sugar.MyComparator sizeComparator = new Sugar.MyComparator<A>(){

            @Override
            public boolean isABetterThanB(A a, A b) {
                if (Table.this.sizes.containsKey(a) && Table.this.sizes.containsKey(b)) {
                    return (Integer)Table.this.sizes.get(a) < (Integer)Table.this.sizes.get(b) || Table.this.sizes.get(a) == Table.this.sizes.get(b) && a.toString().compareTo(b.toString()) < 0;
                }
                return a.toString().compareTo(b.toString()) < 0;
            }
        };
        for (Set set : filter.values()) {
            retVal.add(Sugar.findBest(set, sizeComparator));
        }
        return retVal;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.save(sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    public void save(Writer out) throws IOException {
        List selectedAttributes = Sugar.listFromCollections(this.filteredAttributes());
        Collections.sort(selectedAttributes, new Comparator<A>(){

            @Override
            public int compare(A o1, A o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        PrintWriter pw1 = new PrintWriter(out);
        this.printHeader(selectedAttributes, pw1);
        pw1.println("\n@data");
        this.printRows(selectedAttributes, pw1);
        pw1.flush();
    }

    public void makeCompatible(Table<E, A> table) {
        for (A key : table.attributes.keySet()) {
            for (Pair<E, String> pair : table.attributes.get(key)) {
                if (((String)pair.s).equals("?")) continue;
                this.additionalUnseenValues.put(key, (String)pair.s);
            }
        }
        for (String classLabel : table.classification.values()) {
            if (classLabel.equals("?")) continue;
            this.additionalUnseenClassifications.add(classLabel);
        }
    }

    public void saveWithoutFiltering(Writer out) throws IOException {
        HashSet<Integer> exs = new HashSet<Integer>();
        for (int i = 0; i < this.examplesCount; ++i) {
            exs.add(i);
        }
        PrintWriter pw1 = new PrintWriter(out);
        List selectedAttributes = Sugar.listFromCollections(this.attributes.keySet());
        Collections.sort(selectedAttributes, new Comparator<A>(){

            @Override
            public int compare(A o1, A o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        this.printHeader(selectedAttributes, pw1);
        pw1.println("\n@data");
        this.printRows(selectedAttributes, pw1);
        pw1.flush();
    }

    public void addAll(Table<E, A> table) {
        for (A attribute : table.attributes.keySet()) {
            for (Pair<E, String> pair : table.attributes.get(attribute)) {
                if (table.sizes.containsKey(attribute)) {
                    this.add(pair.r, attribute, (String)pair.s, table.sizes.get(attribute));
                    continue;
                }
                this.add(pair.r, attribute, (String)pair.s);
            }
        }
    }

    private void printHeader(List<A> selectedAttributes, PrintWriter pw) throws IOException {
        pw.print("@relation propositionalization\n\n");
        for (A attribute : selectedAttributes) {
            pw.print("@attribute '" + attribute.toString().replaceAll("\\'", "\\\\'") + "' " + this.attributeType(attribute) + "\n");
        }
        if (this.classification.size() > 0) {
            pw.print("@attribute 'classification' " + this.classificationType() + "\n");
        }
        pw.print("\n");
    }

    private String classificationType() {
        for (String val : Sugar.setFromCollections(this.classification.values())) {
            if (StringUtils.isNumeric(val) || val.equals("?")) continue;
            return this.collectionToWekaString(Sugar.setFromCollections(this.classification.values(), this.additionalUnseenClassifications));
        }
        return NUMERIC;
    }

    private String attributeType(A attribute) {
        for (Pair<E, String> pair : this.attributes.get(attribute)) {
            if (StringUtils.isNumeric((String)pair.s) || ((String)pair.s).equals("?")) continue;
            return this.nominalAttribute(attribute);
        }
        return NUMERIC;
    }

    public Set<String> getAttributeValues(A attribute) {
        return this.attributeValues.get(attribute);
    }

    private String nominalAttribute(A attribute) {
        LinkedHashSet<String> valuesSet = new LinkedHashSet<String>();
        for (Pair<E, String> o : this.attributes.get(attribute)) {
            if (((String)o.s).equals("?")) continue;
            valuesSet.add((String)o.s);
        }
        valuesSet.addAll(this.additionalUnseenValues.get(attribute));
        return this.collectionToWekaString(valuesSet);
    }

    public void addAdditionalUnseenValue(A attribute, String value) {
        this.additionalUnseenValues.put(attribute, value);
    }

    public void addAdditionalUnseenClassification(String value) {
        this.additionalUnseenClassifications.add(value);
    }

    private String collectionToWekaString(Set<String> valuesSet) {
        List<String> values = Sugar.listFromCollections(valuesSet);
        Collections.sort(values);
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (String value : values) {
            String str = value.toString();
            if (str.charAt(0) == '\'' && str.charAt(str.length() - 1) == '\'') {
                str = str.substring(1, str.length() - 1);
            }
            str = str.replaceAll("'", "\\'");
            sb.append("'").append(str).append("'");
            sb.append(",");
        }
        sb.delete(sb.length() - 1, sb.length());
        sb.append("}");
        return sb.toString();
    }

    private void printRows(List<A> selectedAttributes, PrintWriter pw) throws IOException {
        MultiList rows = new MultiList();
        for (A t : selectedAttributes) {
            for (Pair<E, String> pair : this.attributes.get(t)) {
                rows.put(pair.r, pair.s);
            }
        }
        for (Object example : rows.keySet()) {
            List row = rows.get(example);
            int index = 0;
            for (String inRow : row) {
                if (inRow.charAt(0) == '\'' && inRow.charAt(inRow.length() - 1) == '\'') {
                    inRow = inRow.substring(1, inRow.length() - 1);
                }
                if ((inRow = inRow.replaceAll("'", "\\'")).equals("?")) {
                    pw.print("?");
                } else {
                    pw.print("'" + inRow + "'");
                }
                if (index < row.size() - 1) {
                    pw.print(", ");
                }
                ++index;
            }
            if (this.classification.containsKey(example)) {
                String classLabel = this.classification.get(example);
                if (classLabel.charAt(0) == '\'' && classLabel.charAt(classLabel.length() - 1) == '\'') {
                    classLabel = classLabel.substring(1, classLabel.length() - 1);
                }
                if (classLabel.equals("?")) {
                    pw.print(classLabel);
                } else {
                    pw.print(", '" + classLabel + "'");
                }
            }
            pw.print("\n");
        }
    }

    public int countOfAttributes() {
        return this.attributes.size();
    }

    public static Table<Integer, String> load(Reader reader) throws IOException {
        HashMap<Integer, String> attributesOrdering = new HashMap<Integer, String>();
        Table<Integer, String> table = new Table<Integer, String>();
        int attributeIndex = 0;
        boolean data = false;
        int example = 0;
        for (String line : Sugar.readLines(reader)) {
            if ((line = line.trim()).startsWith("@attribute")) {
                String attribute = null;
                attribute = line.contains("'") ? line.substring(line.indexOf("'") + 1, line.lastIndexOf("'")) : line.substring("@attribute".length()).trim();
                attributesOrdering.put(attributeIndex, attribute);
                ++attributeIndex;
            }
            if (line.startsWith("@data")) {
                data = true;
                continue;
            }
            if (!data || line.length() <= 0) continue;
            String[] array = line.split(",");
            for (int i = 0; i < array.length; ++i) {
                String attribute = (String)attributesOrdering.get(i);
                if (!attribute.equalsIgnoreCase("classification")) {
                    table.add(example, attribute, StringUtils.unquote(array[i]), array[i].length());
                    continue;
                }
                table.addClassification(example, StringUtils.unquote(array[i]));
            }
            ++example;
        }
        return table;
    }

    public <U, V> Table<U, V> transform(Sugar.Fun<E, U> exampleTransformer, Sugar.Fun<A, V> attributeTransformer, Sugar.Fun<String, String> valueTransformer) {
        Table<U, V> newTable = new Table<U, V>();
        for (Map.Entry<A, Set<Pair<E, String>>> entry : this.attributes.entrySet()) {
            for (Pair<E, String> pair : entry.getValue()) {
                newTable.add(exampleTransformer.apply(pair.r), attributeTransformer.apply(entry.getKey()), valueTransformer.apply((String)pair.s), this.sizes.get(entry.getKey()));
            }
        }
        for (Map.Entry<A, Set<Object>> entry : this.additionalUnseenValues.entrySet()) {
            for (String string : entry.getValue()) {
                newTable.addAdditionalUnseenValue(attributeTransformer.apply(entry.getKey()), valueTransformer.apply(string));
            }
        }
        for (Map.Entry<Object, Object> entry : this.classification.entrySet()) {
            newTable.addClassification(exampleTransformer.apply(entry.getKey()), valueTransformer.apply((String)entry.getValue()));
        }
        for (String string : this.additionalUnseenClassifications) {
            newTable.addAdditionalUnseenClassification(valueTransformer.apply(string));
        }
        return newTable;
    }
}

