/*
 * Decompiled with CFR 0.152.
 */
package model.tree;

import data.catalog.Catalog;
import data.feature.SimpleFeature;
import data.instance.Instance;
import data.instance.Instances;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import model.Model;
import model.ModelOptions;
import model.inference.hc.AggregateBase;
import model.tree.RandomForest;
import model.tree.RunnableDecisionTree;
import util.GlobalRandom;

public class RestrictedRandomForest
extends RandomForest {
    private ArrayList<SimpleFeature> sfToUse;
    private ArrayList<AggregateBase> aggsToUse;

    public RestrictedRandomForest(ModelOptions o, ArrayList<SimpleFeature> sf, ArrayList<AggregateBase> aggs) {
        super(o);
        this.sfToUse = sf;
        this.aggsToUse = aggs;
    }

    @Override
    public void build(Instances instsTrain, Catalog cat) {
        this.allInsts = instsTrain;
        this.tests = new HashMap();
        CountDownLatch cdl = new CountDownLatch(this.opts.treesInForest);
        int proc = Runtime.getRuntime().availableProcessors();
        Semaphore sem = new Semaphore(proc);
        int n = 1;
        while (n <= this.opts.treesInForest) {
            Instances train = new Instances();
            int i = 0;
            while (i < instsTrain.size()) {
                train.add((Instance)instsTrain.get(GlobalRandom.instance().nextInt(instsTrain.size())));
                ++i;
            }
            Instances test = new Instances();
            int i2 = 0;
            while (i2 < instsTrain.size()) {
                if (!train.contains(instsTrain.get(i2))) {
                    test.add((Instance)instsTrain.get(i2));
                }
                ++i2;
            }
            ModelOptions optsIndiv = this.opts.clone();
            Random gr = new Random(GlobalRandom.instance().nextLong());
            RunnableDecisionTree dt = new RunnableDecisionTree(optsIndiv, cat, train, gr, sem, cdl, this.sfToUse, this.aggsToUse, n);
            dt.addToName("_tree_" + n);
            this.tests.put(dt, test);
            new Thread((Runnable)dt, dt.name()).start();
            ++n;
        }
        try {
            cdl.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (RunnableDecisionTree dt : this.tests.keySet()) {
            this.forest.put(dt, 1.0);
        }
        this.oob = this.computeOob(cat);
    }

    @Override
    public Model clone() {
        return new RestrictedRandomForest(this.opts.clone(), new ArrayList<SimpleFeature>(this.sfToUse), new ArrayList<AggregateBase>(this.aggsToUse));
    }
}

