/*
 * Decompiled with CFR 0.152.
 */
package model.reframe;

import data.catalog.Catalog;
import data.instance.Instances;
import data.parameter.NumericShiftFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import model.Model;
import model.ModelOptions;
import model.reframe.Reframer;
import util.GlobalRandom;

public class RSHC
extends Reframer {
    public RSHC(Model baseCls, ModelOptions opt) {
        super(baseCls, opt);
    }

    public RSHC(Model baseCls, ModelOptions opt, boolean i, boolean o) {
        super(baseCls, opt, i, o);
    }

    @Override
    public void reframe(Instances deploy, Catalog cat) throws Exception {
        if (this.input) {
            this.shifts.addAll(this.cls.getShifts());
        }
        if (this.shifts.isEmpty()) {
            this.input = false;
        }
        if (!this.opts.mode.equals("regression")) {
            this.output = false;
        }
        this.cls.deployShifts(deploy, cat);
        Random r = GlobalRandom.instance();
        for (NumericShiftFunction sh2 : this.shifts) {
            double[] parTrain = sh2.getParamsOrig();
            double[] parDeploy = sh2.getParamsDeploy();
            double baseAlpha = (parTrain[1] - parTrain[0]) / (parDeploy[1] - parDeploy[0]);
            double baseBeta = parTrain[0] - baseAlpha * parDeploy[0];
            sh2.setParameters(new double[]{baseAlpha, baseBeta});
        }
        double overallBestPerf = this.evaluatePerformance(deploy, cat);
        HashMap<NumericShiftFunction, double[]> origShifts = new HashMap<NumericShiftFunction, double[]>();
        for (NumericShiftFunction sh3 : this.shifts) {
            origShifts.put(sh3, Arrays.copyOf(sh3.getParameters(), sh3.getParameters().length));
        }
        double adjAlpha = 0.1;
        double adjBeta = 0.01;
        int count = 0;
        ArrayList bestParams = new ArrayList();
        bestParams.add(origShifts);
        HashMap<NumericShiftFunction, double[]> currentParams = new HashMap<NumericShiftFunction, double[]>();
        for (NumericShiftFunction sh4 : this.shifts) {
            currentParams.put(sh4, Arrays.copyOf(sh4.getParameters(), sh4.getParameters().length));
        }
        while (count < 50) {
            double chosenBeta;
            double maxBeta;
            double minBeta;
            double chosenAlpha;
            double baseAlpha;
            double[] paramsDeploy;
            double[] paramsTrain;
            boolean iterImp = true;
            while (iterImp) {
                iterImp = false;
                for (NumericShiftFunction attr : this.shifts) {
                    boolean localImp = this.slopeHillClimbing(deploy, cat, currentParams, attr, adjAlpha);
                    iterImp = iterImp || localImp;
                    localImp = this.interceptHillClimbing(deploy, cat, currentParams, attr, adjBeta);
                    boolean bl = iterImp = iterImp || localImp;
                }
            }
            this.applyShifts(currentParams);
            double endPerf = this.evaluatePerformance(deploy, cat);
            if (endPerf >= overallBestPerf) {
                if (endPerf > overallBestPerf) {
                    overallBestPerf = endPerf;
                    bestParams.clear();
                    count = 0;
                }
                HashMap<NumericShiftFunction, double[]> toInsert = new HashMap<NumericShiftFunction, double[]>();
                for (Map.Entry<NumericShiftFunction, double[]> ent : currentParams.entrySet()) {
                    toInsert.put(ent.getKey(), Arrays.copyOf(ent.getValue(), ent.getValue().length));
                }
                bestParams.add(toInsert);
            }
            if (this.input) {
                HashSet inShifts = new HashSet(this.shifts.stream().filter(sh -> !sh.isOutput()).collect(Collectors.toSet()));
                for (NumericShiftFunction sh5 : inShifts) {
                    paramsTrain = sh5.getParamsOrig();
                    paramsDeploy = sh5.getParamsDeploy();
                    double m1 = paramsTrain[0];
                    double mm1 = paramsTrain[1];
                    double m2 = paramsDeploy[0];
                    double mm2 = paramsDeploy[1];
                    baseAlpha = (mm1 - m1) / (mm2 - m2);
                    chosenAlpha = Math.pow(10.0, 0.5 * r.nextGaussian()) * baseAlpha;
                    minBeta = m1 - chosenAlpha * mm2;
                    maxBeta = mm1 - chosenAlpha * m2;
                    chosenBeta = 0.5 * (minBeta + maxBeta + r.nextGaussian() * 0.5 * (maxBeta - minBeta));
                    currentParams.put(sh5, new double[]{chosenAlpha, chosenBeta});
                }
            }
            if (this.output) {
                HashSet outShifts = new HashSet(this.shifts.stream().filter(sh -> sh.isOutput()).collect(Collectors.toSet()));
                for (NumericShiftFunction outShift : outShifts) {
                    paramsTrain = outShift.getParamsOrig();
                    paramsDeploy = outShift.getParamsDeploy();
                    double m2 = paramsTrain[0];
                    double mm2 = paramsTrain[1];
                    double m1 = paramsDeploy[0];
                    double mm1 = paramsDeploy[1];
                    baseAlpha = (mm1 - m1) / (mm2 - m2);
                    chosenAlpha = Math.pow(10.0, 0.5 * r.nextGaussian()) * baseAlpha;
                    minBeta = m1 - chosenAlpha * m2;
                    maxBeta = mm1 - chosenAlpha * m2;
                    chosenBeta = 0.5 * (minBeta + maxBeta + r.nextGaussian() * 0.5 * (maxBeta - minBeta));
                    currentParams.put(outShift, new double[]{chosenAlpha, chosenBeta});
                }
            }
            this.applyShifts(currentParams);
            ++count;
        }
        HashMap chosenParams = null;
        if (bestParams.size() == 1) {
            chosenParams = (HashMap)bestParams.get(0);
        } else if (bestParams.size() > 1) {
            chosenParams = (HashMap)bestParams.get(r.nextInt(bestParams.size()));
        }
        if (chosenParams != null) {
            this.applyShifts(chosenParams);
        }
    }

    private boolean slopeHillClimbing(Instances deploy, Catalog cat, HashMap<NumericShiftFunction, double[]> currentParams, NumericShiftFunction attr, double adjust) throws Exception {
        this.applyShifts(currentParams);
        double bestPerf = this.evaluatePerformance(deploy, cat);
        int direction = 0;
        boolean localImprovement = false;
        HashMap<NumericShiftFunction, double[]> origParams = new HashMap<NumericShiftFunction, double[]>();
        for (Map.Entry<NumericShiftFunction, double[]> ent : currentParams.entrySet()) {
            origParams.put(ent.getKey(), Arrays.copyOf(ent.getValue(), ent.getValue().length));
        }
        HashMap<NumericShiftFunction, double[]> downParams = new HashMap<NumericShiftFunction, double[]>();
        for (Map.Entry ent : origParams.entrySet()) {
            downParams.put((NumericShiftFunction)ent.getKey(), Arrays.copyOf((double[])ent.getValue(), ((double[])ent.getValue()).length));
        }
        double[] dArray = (double[])downParams.get(attr);
        dArray[0] = dArray[0] * Math.pow(10.0, -adjust);
        this.applyShifts(downParams);
        double downPerf = this.evaluatePerformance(deploy, cat);
        if (downPerf > bestPerf) {
            bestPerf = downPerf;
            currentParams.get((Object)attr)[0] = downParams.get(attr)[0];
            localImprovement = true;
            direction = -1;
        }
        HashMap<NumericShiftFunction, double[]> upParams = new HashMap<NumericShiftFunction, double[]>();
        for (Map.Entry ent : origParams.entrySet()) {
            upParams.put((NumericShiftFunction)ent.getKey(), Arrays.copyOf((double[])ent.getValue(), ((double[])ent.getValue()).length));
        }
        double[] dArray2 = (double[])upParams.get(attr);
        dArray2[0] = dArray2[0] * Math.pow(10.0, adjust);
        this.applyShifts(upParams);
        double upPerf = this.evaluatePerformance(deploy, cat);
        if (upPerf > bestPerf) {
            bestPerf = upPerf;
            currentParams.get((Object)attr)[0] = upParams.get(attr)[0];
            localImprovement = true;
            direction = 1;
        }
        boolean localKeepGoing = localImprovement;
        while (localKeepGoing) {
            int incr = 1;
            boolean accelerate = true;
            while (accelerate) {
                HashMap<NumericShiftFunction, double[]> nextParams = new HashMap<NumericShiftFunction, double[]>();
                for (Map.Entry<NumericShiftFunction, double[]> ent : currentParams.entrySet()) {
                    nextParams.put(ent.getKey(), Arrays.copyOf(ent.getValue(), ent.getValue().length));
                }
                double[] dArray3 = (double[])nextParams.get(attr);
                dArray3[0] = dArray3[0] * Math.pow(10.0, (double)(direction * incr) * adjust);
                this.applyShifts(nextParams);
                double nextPerf = this.evaluatePerformance(deploy, cat);
                if (nextPerf > bestPerf) {
                    bestPerf = nextPerf;
                    currentParams.get((Object)attr)[0] = nextParams.get(attr)[0];
                    incr *= 2;
                    continue;
                }
                accelerate = false;
            }
            boolean bl = localKeepGoing = incr > 1;
        }
        this.applyShifts(currentParams);
        return localImprovement;
    }

    private boolean interceptHillClimbing(Instances deploy, Catalog cat, HashMap<NumericShiftFunction, double[]> currentParams, NumericShiftFunction attr, double adjust) throws Exception {
        this.applyShifts(currentParams);
        double bestPerf = this.evaluatePerformance(deploy, cat);
        double range = attr.isOutput() ? attr.getParamsDeploy()[1] - attr.getParamsDeploy()[0] : attr.getParamsOrig()[1] - attr.getParamsOrig()[0];
        int direction = 0;
        boolean localImprovement = false;
        HashMap<NumericShiftFunction, double[]> origParams = new HashMap<NumericShiftFunction, double[]>();
        for (Map.Entry<NumericShiftFunction, double[]> ent : currentParams.entrySet()) {
            origParams.put(ent.getKey(), Arrays.copyOf(ent.getValue(), ent.getValue().length));
        }
        HashMap<NumericShiftFunction, double[]> downParams = new HashMap<NumericShiftFunction, double[]>();
        for (Map.Entry ent : origParams.entrySet()) {
            downParams.put((NumericShiftFunction)ent.getKey(), Arrays.copyOf((double[])ent.getValue(), ((double[])ent.getValue()).length));
        }
        double[] dArray = (double[])downParams.get(attr);
        dArray[1] = dArray[1] - adjust * range;
        this.applyShifts(downParams);
        double downPerf = this.evaluatePerformance(deploy, cat);
        if (downPerf > bestPerf) {
            bestPerf = downPerf;
            currentParams.get((Object)attr)[1] = downParams.get(attr)[1];
            localImprovement = true;
            direction = -1;
        }
        HashMap<NumericShiftFunction, double[]> upParams = new HashMap<NumericShiftFunction, double[]>();
        for (Map.Entry ent : origParams.entrySet()) {
            upParams.put((NumericShiftFunction)ent.getKey(), Arrays.copyOf((double[])ent.getValue(), ((double[])ent.getValue()).length));
        }
        double[] dArray2 = (double[])upParams.get(attr);
        dArray2[1] = dArray2[1] + adjust * range;
        this.applyShifts(upParams);
        double upPerf = this.evaluatePerformance(deploy, cat);
        if (upPerf > bestPerf) {
            bestPerf = upPerf;
            currentParams.get((Object)attr)[1] = upParams.get(attr)[1];
            localImprovement = true;
            direction = 1;
        }
        boolean localKeepGoing = localImprovement;
        while (localKeepGoing) {
            int incr = 1;
            boolean accelerate = true;
            while (accelerate) {
                HashMap<NumericShiftFunction, double[]> nextParams = new HashMap<NumericShiftFunction, double[]>();
                for (Map.Entry<NumericShiftFunction, double[]> ent : currentParams.entrySet()) {
                    nextParams.put(ent.getKey(), Arrays.copyOf(ent.getValue(), ent.getValue().length));
                }
                double[] dArray3 = (double[])nextParams.get(attr);
                dArray3[1] = dArray3[1] + (double)(direction * incr) * adjust * range;
                this.applyShifts(nextParams);
                double nextPerf = this.evaluatePerformance(deploy, cat);
                if (nextPerf > bestPerf) {
                    bestPerf = nextPerf;
                    currentParams.get((Object)attr)[1] = nextParams.get(attr)[1];
                    incr *= 2;
                    continue;
                }
                accelerate = false;
            }
            boolean bl = localKeepGoing = incr > 1;
        }
        this.applyShifts(currentParams);
        return localImprovement;
    }
}

