/*
 * Decompiled with CFR 0.152.
 */
package model.inference.hc;

import data.catalog.Catalog;
import data.feature.AggregateFeature;
import data.instance.Instance;
import data.instance.Instances;
import data.value.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.TreeMap;
import model.ModelOptions;
import model.NodeSplit;
import model.criterion.cancel.CancelCriterion;
import model.inference.SplitFinder;
import util.Couple;

public abstract class HillClimbing {
    protected ModelOptions opts;
    protected Random rt;

    public HillClimbing(ModelOptions opt, Random gr) {
        this.opts = opt;
        this.rt = gr;
    }

    public abstract NodeSplit run(Instances var1, Catalog var2, ArrayList<CancelCriterion> var3);

    protected boolean evaluateAggregate(AggregateFeature aggFeat, Instances insts, Catalog cat, boolean strict, ArrayList<NodeSplit> bestSplits, ArrayList<CancelCriterion> cancels) {
        boolean res = false;
        if (aggFeat.getAggregateFunction().getKindOut() == 0) {
            HashMap<Value, Instances> decomposition = new HashMap<Value, Instances>();
            Instances mainNoValue = new Instances();
            insts.stream().map(inst -> new Couple<Instance, Value>((Instance)inst, aggFeat.result(inst.getId(), cat))).forEach(coup -> {
                Instance inst = (Instance)coup.getLeft();
                Value val = (Value)coup.getRight();
                if (val.getStringValue() == null) {
                    mainNoValue.add(inst);
                } else {
                    if (!decomposition.containsKey(val)) {
                        decomposition.put(val, new Instances());
                    }
                    ((Instances)decomposition.get(val)).add(inst);
                }
            });
            NodeSplit bs = null;
            if (this.opts.mode.equals("classification")) {
                bs = SplitFinder.inferNominalSplitOnNominalTarget(aggFeat, decomposition, mainNoValue, this.opts.complexity);
            } else if (this.opts.mode.equals("regression")) {
                bs = SplitFinder.inferNominalSplitOnNumericTarget(aggFeat, decomposition, mainNoValue, this.opts.complexity);
            }
            res = this.updateBestSplits(bs, bestSplits, strict, cancels);
        } else if (aggFeat.getAggregateFunction().getKindOut() == 1) {
            TreeMap<Value, Instances> groups = new TreeMap<Value, Instances>();
            Instances noValue = new Instances();
            insts.stream().map(inst -> new Couple<Instance, Value>((Instance)inst, aggFeat.result(inst.getId(), cat))).forEach(coup -> {
                Instance inst = (Instance)coup.getLeft();
                Value val = (Value)coup.getRight();
                if (val.getStringValue() == null) {
                    noValue.add(inst);
                } else {
                    if (!groups.containsKey(val)) {
                        groups.put(val, new Instances());
                    }
                    ((Instances)groups.get(val)).add(inst);
                }
            });
            NodeSplit bs = null;
            if (this.opts.mode.equals("classification")) {
                bs = SplitFinder.inferNumericSplitOnNominalTarget(aggFeat, groups, noValue, this.opts.complexity);
            } else if (this.opts.mode.equals("regression")) {
                bs = SplitFinder.inferNumericSplitOnNumericTarget(aggFeat, groups, noValue, this.opts.complexity);
            }
            res = this.updateBestSplits(bs, bestSplits, strict, cancels);
        }
        return res;
    }

    protected boolean updateBestSplits(NodeSplit ns, ArrayList<NodeSplit> bestNodeSplits, boolean strict, ArrayList<CancelCriterion> cancels) {
        boolean res = false;
        if (ns != null) {
            boolean cancelNow = false;
            for (CancelCriterion cancel : cancels) {
                boolean bl = cancelNow = cancelNow || cancel.cancelCriterion(ns);
            }
            if (!cancelNow) {
                double score = ns.getScore();
                if (bestNodeSplits.isEmpty() || !bestNodeSplits.isEmpty() && score >= bestNodeSplits.get(0).getScore()) {
                    if (bestNodeSplits.isEmpty() || !bestNodeSplits.isEmpty() && (score > bestNodeSplits.get(0).getScore() || !strict)) {
                        res = true;
                        bestNodeSplits.clear();
                    }
                    bestNodeSplits.add(ns);
                }
            }
        }
        return res;
    }

    protected NodeSplit chooseBestSplit(ArrayList<NodeSplit> bestNodeSplits) {
        ArrayList<NodeSplit> candidates = new ArrayList<NodeSplit>();
        double bestScore = this.opts.m.getMin();
        for (NodeSplit ns : bestNodeSplits) {
            if (!(ns.getScore() >= bestScore)) continue;
            if (ns.getScore() > bestScore) {
                bestScore = ns.getScore();
                candidates.clear();
            }
            candidates.add(ns);
        }
        ArrayList<NodeSplit> candidates2 = new ArrayList<NodeSplit>();
        double bestComplexity = Double.MAX_VALUE;
        for (NodeSplit ns : candidates) {
            double compl = ns.getSplitCondition().complexity();
            if (!(compl <= bestComplexity)) continue;
            if (compl < bestComplexity) {
                bestComplexity = compl;
                candidates2.clear();
            }
            candidates2.add(ns);
        }
        if (candidates2.isEmpty()) {
            return null;
        }
        return (NodeSplit)candidates2.get(this.rt.nextInt(candidates2.size()));
    }
}

