/*
 * Decompiled with CFR 0.152.
 */
package model.distribution;

import data.instance.Instance;
import data.instance.Instances;
import data.value.Value;
import java.util.HashSet;
import model.distribution.Distribution;
import org.jdom2.Content;
import org.jdom2.Element;

public class NumericDistribution
extends Distribution {
    private Value prediction;

    public NumericDistribution() {
    }

    public NumericDistribution(Element distrEl) {
        int count = 0;
        for (Element valEl : distrEl.getChildren("value")) {
            this.originalDistribution.add(new Instance(new Value(String.valueOf(count)), new Value(new Double(valEl.getAttributeValue("val")))));
        }
    }

    @Override
    public void init(Instances distr) {
        this.originalDistribution.addAll(distr);
        if (distr.isEmpty()) {
            this.prediction = new Value(Double.NaN);
        } else {
            double pred = 0.0;
            double w = 0.0;
            for (Instance inst : distr) {
                pred += inst.getWeight() * inst.getLabel().getNumericValue();
                w += inst.getWeight();
            }
            this.prediction = new Value(pred /= w);
        }
    }

    @Override
    public Value predict() {
        return this.prediction;
    }

    @Override
    public boolean canPredict() {
        return !this.prediction.getNumericValue().isNaN();
    }

    @Override
    public Distribution clone() {
        NumericDistribution res = new NumericDistribution();
        return res;
    }

    @Override
    public HashSet<Value> predictMajority() {
        HashSet<Value> res = new HashSet<Value>();
        res.add(this.prediction);
        return res;
    }

    public String toString() {
        return "[" + this.prediction.toString() + "]";
    }

    @Override
    public Element toXMLElement() {
        Element el = new Element("distribution");
        el.setAttribute("type", "regression");
        for (Instance inst : this.originalDistribution) {
            Element ch = new Element("value");
            ch.setAttribute("val", inst.getLabel().getStringValue());
            el.addContent((Content)ch);
        }
        return el;
    }
}

