/*
 * Decompiled with CFR 0.152.
 */
package main;

import data.catalog.CatalogFile;
import data.instance.Instances;
import eval.SimpleEvaluation;
import java.io.File;
import java.io.FileWriter;
import java.util.Collections;
import model.ModelOptions;
import model.reframe.RRS;
import model.reframe.RSHC;
import model.tree.DecisionTree;
import util.FileWrite;
import util.GlobalRandom;

public class Reframing {
    public static void main(String[] args) throws Exception {
        String sourceDirectory = String.valueOf(new File(".").getAbsolutePath()) + "/";
        String train = new String();
        train = args[0].charAt(0) == '/' ? args[0] : String.valueOf(sourceDirectory) + args[0];
        FileWrite.setFileWrite(train);
        FileWrite.clearLog();
        ModelOptions optTrain = ModelOptions.getOptions(train);
        GlobalRandom.init(optTrain.seed);
        CatalogFile cat = new CatalogFile();
        cat.fillCatalog(String.valueOf(train) + ".prd", String.valueOf(train) + ".fct");
        cat.setClassInstances(optTrain.classPredicate);
        cat.setFunctions(optTrain.aggFunctions);
        String refr = new String();
        refr = args[1].charAt(0) == '/' ? args[1] : String.valueOf(sourceDirectory) + args[1];
        CatalogFile catRefr = new CatalogFile();
        catRefr.fillCatalog(String.valueOf(refr) + ".prd", String.valueOf(refr) + ".fct");
        catRefr.setClassInstances(optTrain.classPredicate);
        catRefr.setFunctions(optTrain.aggFunctions);
        String deploy = new String();
        deploy = args[1].charAt(0) == '/' ? args[1] : String.valueOf(sourceDirectory) + args[1];
        CatalogFile catTest = new CatalogFile();
        catTest.fillCatalog(String.valueOf(deploy) + ".prd", String.valueOf(deploy) + ".fct");
        catTest.setClassInstances(optTrain.classPredicate);
        catTest.setFunctions(optTrain.aggFunctions);
        Instances reframeAll = new Instances(catRefr.getClassInstances());
        Collections.shuffle(reframeAll, GlobalRandom.instance());
        Instances test = new Instances(catTest.getClassInstances());
        optTrain.name = "tree";
        DecisionTree mod = new DecisionTree(optTrain);
        mod.build(cat.getClassInstances(), cat);
        SimpleEvaluation evalBase = new SimpleEvaluation(optTrain.mode);
        evalBase.evaluateModel(mod, test, catTest, false);
        double accBase = (Double)evalBase.getStatistics().getStat("accuracy");
        FileWriter fw = new FileWriter("/Users/ccharnay/Documents/these/aggregates/reframe/results.csv", false);
        fw.write("Dataset;Deploy;ID;Base;Retrain;RSHC;RRS\n");
        fw.close();
        int nr = 4;
        while (nr < 50) {
            int k = 0;
            while (k < 30) {
                Instances reframe = new Instances(reframeAll.subList(0, nr));
                DecisionTree retrain = new DecisionTree(optTrain);
                retrain.build(reframe, catRefr);
                SimpleEvaluation evalRetrain = new SimpleEvaluation(optTrain.mode);
                evalRetrain.evaluateModel(retrain, test, catTest, false);
                double accRetrain = (Double)evalRetrain.getStatistics().getStat("accuracy");
                RSHC rshc = new RSHC(mod, optTrain);
                rshc.reframe(reframe, catRefr);
                SimpleEvaluation evalRshc = new SimpleEvaluation(optTrain.mode);
                evalRshc.evaluateModel(mod, test, catTest, true);
                double accRshc = (Double)evalRshc.getStatistics().getStat("accuracy");
                RRS rrs = new RRS(mod, optTrain);
                rrs.reframe(reframe, catRefr);
                SimpleEvaluation evalRrs = new SimpleEvaluation(optTrain.mode);
                evalRrs.evaluateModel(mod, test, catTest, true);
                double accRrs = (Double)evalRrs.getStatistics().getStat("accuracy");
                FileWriter fw2 = new FileWriter("/Users/ccharnay/Documents/these/aggregates/reframe/results.csv", true);
                fw2.write("city2;" + nr + ";" + k + ";" + accBase + ";" + accRetrain + ";" + accRshc + ";" + accRrs + "\n");
                fw2.close();
                ++k;
            }
            nr += 2;
        }
    }
}

